<?php
// Check File Is Included
if(!defined('IncludedFile')) {header("Location:index.php");exit;}
// Include Required Files
require("../functions.php");
// JSON Object Variables
$errors = array();
$data = array();
// Get Action
if(isset($_REQUEST['form_name'])){$process_name = $_REQUEST['form_name'];}else{exit;}
// Confirm Logged In
if((($process_name!="install_form")&&($process_name!="login")&&($process_name!="forgot_password"))&&($logged_in!=1)){
	$errors['logged_in'] = 'Session Expired - Please Re-Login';
	$data['success'] = false;
    $data['errors']  = $errors;
	goto ShowError;
	}
// Select Action
switch ($process_name) {
	case "login":
		// Check If Installation Required
		if($install_required==1){$errors['error'] = $product_name.' Has Not Yet Been Installed';}
		if(!empty($errors)){goto ShowError;}
		// Check Variables Available
		if(empty($_POST['password'])){$errors['error'] = 'Please Enter Your Password';}
        if(empty($_POST['username'])){$errors['error'] = 'Please Enter Your Username';}
		if(!empty($errors)){goto ShowError;}
		// Set Variables
		$tmpusername = $conn->real_escape_string($_POST['username']);
		$tmppassword = $conn->real_escape_string($_POST['password']);
		// Check Against Existing Username
		if(($username!="")&&(strtolower($username)!=strtolower($tmpusername))){
			$errors['error'] = $product_name.' Was Not Installed With This BHT Account';
			goto ShowError;
			}
		// Call Server
		$content = Return_Content("https://www.blackhattoolz.com/licensing/script_access.php?u=".$tmpusername."&p=".$tmppassword);
		// Check Response
		if($content!="111"){
			// Check Error
			if($content=="0:0:0"){
				$errors['error'] = 'Unknown Username For BlackHatToolz.com';
			}elseif($content=="0:1:0"){
				$errors['error'] = 'Invalid BlackHatToolz.com Login Information';
			}elseif($content=="0:2:0"){
				$errors['error'] = 'Your BlackHatToolz Subscription Has Expired';
				}
			goto ShowError;
			}
		// Update Settings
		$sql = "UPDATE settings SET admin_username='".$tmpusername."', admin_password='".$tmppassword."';";
		$conn->query($sql);
		// Set Logged In Cookies
		$_SESSION['username'] = $tmpusername;
		$_SESSION['password'] = $tmppassword;
		break;
	case "install_form":
		// Check If Installation Required
		if($install_required==0){$errors['error'] = $product_name.' Has Already Been Installed';}
		if(!empty($errors)){goto ShowError;}
		// Check Variables Available
		// if(empty($_POST['db_password'])){$errors['error'] = 'Please Enter Your Database Password';}
		if(empty($_POST['db_username'])){$errors['error'] = 'Please Enter Your Database Username';}
		if(empty($_POST['db_name'])){$errors['error'] = 'Please Enter Your Database Name';}
		if(empty($_POST['password'])){$errors['error'] = 'Please Enter Your BHT Password';}
        if(empty($_POST['username'])){$errors['error'] = 'Please Enter Your BHT Username';}
		// If Error Do Not Proceed
		if(!empty($errors)){goto ShowError;}
		// Set Variables
		$username = MakeSafe($_POST['username']);
		$password = MakeSafe($_POST['password']);
		$db_name = MakeSafe($_POST['db_name']);
		$db_username = MakeSafe($_POST['db_username']);
		$db_password = MakeSafe($_POST['db_password']);
		// Call Server
		$content = Return_Content("http://www.blackhattoolz.com/licensing/script_access.php?u=".$username."&p=".$password);
		// Check Response
		if($content!="111"){
			// Check Error
			if($content=="0:0:0"){
				$errors['error'] = 'Unknown Username For BlackHatToolz.com';
			}elseif($content=="0:1:0"){
				$errors['error'] = 'Invalid BlackHatToolz.com Login Information';
			}elseif($content=="0:2:0"){
				$errors['error'] = 'Your BlackHatToolz Subscription Has Expired';
				}
			goto ShowError;
			}
		// If Error Do Not Proceed
		if(!empty($errors)){goto ShowError;}
		// Connect To Database & Check Connection
		try{
			$conn = new mysqli('localhost', $db_username, $db_password, $db_name);
			if($conn->connect_error){
				$errors['error'] = 'Database Connection Failed: '.$conn->connect_error;
				goto ShowError;
				}
		}catch(Exception $e){
			$errors['error'] = 'Database Connection Failed ('.$db_username." ".$db_password." ".$db_name.'): '.$e;
			goto ShowError;
			}
		// Install Core DB File
		$connect_code="<?php \$dbhost='localhost';\$dbuser='".$db_username."';\$dbpass='".$db_password."';\$dbname='".$db_name."'; ?>";
		$fp = fopen('../db.php', 'w');
		fwrite($fp,$connect_code);
		fclose($fp);
		// Create Campaigns Table
		$qry = "CREATE TABLE `campaigns` (
		  `id` INT(11) NOT NULL auto_increment,
		  `name` VARCHAR(255) NOT NULL,
		  `reftype` VARCHAR(255) NOT NULL,
		  `url` LONGTEXT NOT NULL,
		  `fakeref` LONGTEXT,
		  `linktag` VARCHAR(255) NOT NULL UNIQUE,
		  `hits` bigint(20) NOT NULL,
		  `latest_hit` bigint(20),
		  `notes` LONGTEXT,
		  PRIMARY KEY  (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8;";           
		mysqli_query($conn,$qry);
		// Create Logs Table
		$qry = "CREATE TABLE `logs` (
		  `id` bigint(20) NOT NULL auto_increment,
		  `campaignid` bigint(20) NOT NULL,
		  `ip` varchar(255) NOT NULL,
		  `useragent` varchar(255),
		  `referrer` varchar(255),
		  `keyword` varchar(255),
		  `time_stamp` bigint(20) NOT NULL,
		  `action` varchar(255) NOT NULL,
		  PRIMARY KEY  (`id`)
		) ENGINE=MyISAM DEFAULT CHARSET=utf8;";           
		mysqli_query($conn,$qry);
		// Create Settings Table
		$qry = "CREATE TABLE `settings` (
		  `admin_username` varchar(255),
		  `admin_password` varchar(255),
		  `twitter_consumer_key` varchar(255),
		  `twitter_consumer_secret` varchar(255),
		  `twitter_access_token` varchar(255),
		  `twitter_access_token_secret` varchar(255),
		  `stumbleupon_username` varchar(255),
		  `stumbleupon_password` varchar(255),
		  `block_bots` tinyint(1) NOT NULL,
		  `disable_logs` tinyint(1) NOT NULL,
		  `whitehat_html` LONGTEXT,
		  `captcha_api_key` varchar(255),
  		  `captcha_max_wait_time` bigint(20),
		  `bot_user_agents` LONGTEXT
		) ENGINE=MyISAM DEFAULT CHARSET=utf8;";           
		mysqli_query($conn,$qry);
		// Set MySQLi Safe Variables
		$username = $conn->real_escape_string($_POST['username']);
		$password = $conn->real_escape_string($_POST['password']);
		// Set Default Bot Useragents
		$bot_user_agents = "Bot\nAltaVista\nSlurp\nSpider\nMagic Browser\n=Mozilla\nHttpRequest\nia_archiver\nlibwww";
		// Set Insert Statement
		$sql = "INSERT INTO settings (admin_username,admin_password,block_bots,disable_logs,captcha_max_wait_time, bot_user_agents) VALUES('".$username."','".$password."','0','0','120','".$bot_user_agents."')";
		// Insert Settings Into DB
		if($conn->query($sql) === false){
			$errors['error'] = 'SQL Insert Failed: '.$conn->error;
			goto ShowError;
		}else{
			$campid = $conn->insert_id;
		}
		break;
    case "create_campaign":
		// Check Variables Available
        if(empty($_POST['name'])){$errors['name'] = 'Campaign Name Is Required';}
		if((!isset($_POST['reftype'])) or (empty($_POST['reftype'])&&($_POST['reftype']!="0"))){$errors['reftype'] = 'Please Select A Referrer Type';}
		if(empty($_POST['url'])){$errors['url'] = 'Please Enter A Destination URL';}
		if(empty($_POST['linktag'])){$errors['linktag'] = 'Please Enter A Link Tag';}
		if(!empty($errors)){goto ShowError;}
		// Set Variables
		$name = $conn->real_escape_string($_POST['name']);
		$reftype = $conn->real_escape_string($_POST['reftype']);
		$url = $conn->real_escape_string($_POST['url']);
		$linktag = $conn->real_escape_string($_POST['linktag']);
		if(empty($_POST['fakeref'])){$fakeref = "";}else{$fakeref = $conn->real_escape_string($_POST['fakeref']);}
		if(empty($_POST['google_keywords'])){$google_keywords = "";}else{$google_keywords = $conn->real_escape_string($_POST['google_keywords']);}
		if(empty($_POST['google_tld'])){$google_tld = "";}else{$google_tld = $conn->real_escape_string($_POST['google_tld']);}
		if(empty($_POST['notes'])){$notes = "";}else{$notes = $conn->real_escape_string($_POST['notes']);}
		// Check Valid URL
		if((!parse_url($url))||(!strstr($url,"http"))){$errors['url'] = "Invalid URL - Make Sure To Include http://";}
		// Check Valid Link Tag
		if(strstr($linktag, " ")){$errors['linktag'] = 'Your Link Tag Cannot Contain Spaces';}
		// Settings SQL
		$settings_sql = "SELECT * FROM settings";
		$settings_rs=$conn->query($settings_sql);
		$settings_row=$settings_rs->fetch_assoc();
		// Check For Twitter Login Information
		$twitter_consumer_key = $settings_row['twitter_consumer_key'];
		$twitter_consumer_secret = $settings_row['twitter_consumer_secret'];
		$twitter_access_token = $settings_row['twitter_access_token'];
		$twitter_access_token_secret = $settings_row['twitter_access_token_secret'];
		if(($reftype==4)&&($twitter_consumer_key==""||$twitter_consumer_secret==""||$twitter_access_token==""||$twitter_access_token_secret=="")){$errors['error'] = 'Please Add Twitter API Information To The Settings Tab';}
		// Check For StumbleUpon Login Information
		$stumbleupon_username = $settings_row['stumbleupon_username'];
		$stumbleupon_password = $settings_row['stumbleupon_password'];
		if(($reftype==5)&&($stumbleupon_username==""||$stumbleupon_password=="")){$errors['error'] = 'Please Add StumbleUpon Login Information To The Settings Tab';}
		// Check For 2Captcha Information
		$captcha_api_key = $settings_row['captcha_api_key'];
		if(($reftype==5)&&($captcha_api_key=="")){$errors['error'] = 'Please Enter 2Captcha API Key To The Settings Tab';}
		// Confirm Fake Referrer Available
		if(($reftype=="2")&&($fakeref=="")){$errors['fakeref'] = "Please Enter A URL To Fake The Referrer To";}
		// Confirm Google Variables Available
		if(($reftype=="3")&&($google_tld=="")){$errors['google_tld'] = "Please Enter A Google TLD, E.g: .com";}
		// Check Link Tag Not Already Used
		$sql = "SELECT id FROM campaigns WHERE linktag='".$linktag."' LIMIT 1";
		$rs=$conn->query($sql);
		$total_found = $rs->num_rows;
		if($total_found>0){$errors['linktag'] = 'You Already Have A Campaign With This Link Tag';}
		// Check If Ok To Create Campaign
		if(empty($errors)){
			// Generate Link
			try{
				if($reftype=="3"){
					// Google Referrer
					$fakeref = GenerateGoogleRef($url,strtolower($google_keywords),strtolower($google_tld));
				}elseif($reftype=="4"){
					// Twitter Referrer
					$fakeref = GenerateTwitterDesktopRef($url);
				}elseif($reftype=="5"){
					// StumbleUpon Referrer
					$fakeref = GenerateStumbleUponRef($url);
					}
			}catch(Exception $e){
				$errors['error'] = $e->getMessage();
				}
			// Confirm Link Created Successfully
			if(!empty($errors)){goto ShowError;}
			// If No Error Insert Into DB
			$sql = "INSERT INTO campaigns (name,reftype,url,fakeref,linktag,hits,latest_hit,notes) 
					VALUES('".$name."','".$reftype."','".$url."','".$fakeref."','".$linktag."','0','0','".$notes."')";
			// Insert Into DB
			if($conn->query($sql) === false){
				$errors['error'] = 'SQL Insert Failed: '.$conn->error;
				goto ShowError;
			}else{
				$campid = $conn->insert_id;
				}
			}
		break;
	case "edit_campaign":
		// Check Variables Available
        if(empty($_POST['camp_id'])){$errors['camp_id'] = 'Campaign ID Not Provided';}
		if(empty($_POST['name'])){$errors['name'] = 'Campaign Name Is Required';}
		if(empty($_POST['reftype'])&&($_POST['reftype']!="0")){$errors['reftype'] = 'Please Select A Referrer Type';}
		if(empty($_POST['url'])){$errors['url'] = 'Please Enter A Destination URL';}
		if(empty($_POST['linktag'])){$errors['linktag'] = 'Please Enter A Link Tag';}
		if(!empty($errors)){goto ShowError;}
		// Set Variables
		$camp_id = $conn->real_escape_string($_POST['camp_id']);
		$name = $conn->real_escape_string($_POST['name']);
		$reftype = $conn->real_escape_string($_POST['reftype']);
		$url = $conn->real_escape_string($_POST['url']);
		$linktag = $conn->real_escape_string($_POST['linktag']);
		if(empty($_POST['fakeref'])){$fakeref = "";}else{$fakeref = $conn->real_escape_string($_POST['fakeref']);}
		if(empty($_POST['google_keywords'])){$google_keywords = "";}else{$google_keywords = $conn->real_escape_string($_POST['google_keywords']);}
		if(empty($_POST['google_tld'])){$google_tld = "";}else{$google_tld = $conn->real_escape_string($_POST['google_tld']);}
		if(empty($_POST['edit_notes'])){$edit_notes = "";}else{$edit_notes = $conn->real_escape_string($_POST['edit_notes']);}
		// Check Valid URL
		if((!parse_url($url))||(!strstr($url,"http"))){$errors['url'] = "Invalid URL - Make Sure To Include http://";}
		// Check Valid Link Tag
		if(strstr($linktag, " ")){$errors['linktag'] = 'Your Link Tag Cannot Contain Spaces';}
		// Settings SQL
		$settings_sql = "SELECT * FROM settings";
		$settings_rs=$conn->query($settings_sql);
		$settings_row=$settings_rs->fetch_assoc();
		// Check For Twitter Login Information
		$twitter_consumer_key = $settings_row['twitter_consumer_key'];
		$twitter_consumer_secret = $settings_row['twitter_consumer_secret'];
		$twitter_access_token = $settings_row['twitter_access_token'];
		$twitter_access_token_secret = $settings_row['twitter_access_token_secret'];
		if(($reftype==4)&&($twitter_consumer_key==""||$twitter_consumer_secret==""||$twitter_access_token==""||$twitter_access_token_secret=="")){$errors['error'] = 'Please Add Twitter API Information To The Settings Tab';}
		// Check For StumbleUpon Login Information
		$stumbleupon_username = $settings_row['stumbleupon_username'];
		$stumbleupon_password = $settings_row['stumbleupon_password'];
		if(($reftype==5)&&($stumbleupon_username==""||$stumbleupon_password=="")){$errors['error'] = 'Please Add StumbleUpon Login Information To The Settings Tab';}
		// Confirm Fake Referrer Available
		if(($reftype=="2")&&($fakeref=="")){$errors['fakeref'] = "Please Enter A URL To Fake The Referrer To";}
		// Confirm Google Variables Available
		if(($reftype=="3")&&($google_tld=="")){$errors['google_tld'] = "Please Enter A Google TLD, E.g: .com";}
		// Check Link Tag Not Already Used
		$sql = "SELECT id FROM campaigns WHERE linktag='".$linktag."'";
		$rs=$conn->query($sql);
		$total_found = $rs->num_rows;
		while($row = $rs->fetch_assoc()){
			if($row['id']!=$camp_id){$errors['linktag'] = 'You Have Another Campaign With This Link Tag';}
			}
		// Fetch Original Campaign Data
		$campaign_sql = "SELECT * FROM campaigns WHERE id='".$camp_id."' LIMIT 1";
		$campaign_rs=$conn->query($campaign_sql);
		$campaign_row=$campaign_rs->fetch_assoc();
		// Set Original Campaign Data
		$original_url = $campaign_row['url'];
		$original_reftype = $campaign_row['reftype'];
		// Check If Ok To Create Campaign
		if(empty($errors)){
			// Check If Link Needs To Be Re-Generated
			if(($original_url!=$url)||($reftype!=$original_reftype)){
				// Generate Link If Required
				try{
					if($reftype=="3"){
					// Google Referrer
					$fakeref = GenerateGoogleRef($url,strtolower($google_keywords),strtolower($google_tld));
				}elseif($reftype=="4"){
					// Twitter Referrer
					$fakeref = GenerateTwitterDesktopRef($url);
				}elseif($reftype=="5"){
					// StumbleUpon Referrer
					$fakeref = GenerateStumbleUponRef($url);
					}
				}catch(Exception $e){
					$errors['error'] = $e->getMessage();
					}
				}
			// Confirm Link Created Successfully
			if(!empty($errors)){goto ShowError;}
			// If No Error Update DB
			$sql = "UPDATE campaigns SET name='".$name."',reftype='".$reftype."',url='".$url."',fakeref='".$fakeref."',linktag='".$linktag."',notes='".$edit_notes."' WHERE id='".$camp_id."'";
			// Insert Into DB
			if($conn->query($sql) === false){
				$errors['error'] = 'SQL Update Failed: '.$conn->error;
				goto ShowError;
			}else{
				$campid = $conn->insert_id;
				}
			}
		break;
	case "get_camp_data":
		// Check Variables
		if(empty($_REQUEST['camp_id'])){$errors['error'] = 'Campaign ID Not Specified';}
		// Set Variables
		$camp_id = $conn->real_escape_string($_REQUEST['camp_id']);
		// Lookup Campaign Data
		$sql = "SELECT * FROM campaigns WHERE id='".$camp_id."' LIMIT 1";
		$rs=$conn->query($sql);
		while($row = $rs->fetch_assoc()){
			$camp_name = $row['name'];
			$reftype = $row['reftype'];
			$url = $row['url'];
			$fakeref = $row['fakeref'];
			$linktag = $row['linktag'];
			$notes = $row['notes'];
			}
		// Set JSON Respoinse
		$data['success'] = true;
		$data['campaign_name'] = $camp_name;
		$data['ref_type'] = $reftype;
		$data['url'] = $url;
		$data['fake_ref'] = $fakeref;
		$data['linktag'] = $linktag;
		$data['google_keywords'] = "";
		$data['google_tld'] = "";
		$data['notes'] = $notes;
		$data['message'] = 'Success';
		// JSON Encode Data
		echo json_encode($data);
		exit;
	case "clear_stats":
		foreach($_POST['camp_id'] as $camp_id){
			$sql="UPDATE campaigns SET hits='0' WHERE id='".$conn->real_escape_string($camp_id)."'";
			$conn->query($sql);
			$sql="UPDATE campaigns SET latest_hit='0' WHERE id='".$conn->real_escape_string($camp_id)."'";
			$conn->query($sql);
			$sql="DELETE FROM logs WHERE campaignid='".$conn->real_escape_string($camp_id)."'";
			$conn->query($sql);
			}
        break;
	case "delete_campaigns":
		foreach($_POST['camp_id'] as $camp_id){
			$sql="DELETE FROM campaigns WHERE id='".$conn->real_escape_string($camp_id)."'";
			$conn->query($sql);
			$sql="DELETE FROM logs WHERE campaignid='".$conn->real_escape_string($camp_id)."'";
			$conn->query($sql);
			}
		break;
	case "get_full_log":
		// Check Variables
		if(empty($_REQUEST['log_id'])){$errors['error'] = 'Campaign ID Not Specified';}
		// Set Variables
		$log_id = $conn->real_escape_string($_REQUEST['log_id']);
		// Lookup Campaign Data
		$sql = "SELECT * FROM logs WHERE id='".$log_id."' LIMIT 1";
		$rs=$conn->query($sql);
		while($row = $rs->fetch_assoc()){
			$campaign_id = $row['campaignid'];
			$ip = $row['ip'];
			$useragent = $row['useragent'];
			$referrer = $row['referrer'];
			$keyword = $row['keyword'];
			$time_stamp = $row['time_stamp'];
			$action = $row['action'];
			}
		// Lookup Campaign Name Used In This Log
		$sql = "SELECT * FROM campaigns WHERE id='".$campaign_id."' LIMIT 1";
		$rs=$conn->query($sql);
		$row = $rs->fetch_assoc();
		$tmp_count = $rs->num_rows;
		if($tmp_count>0){
			$tmp_row = $rs->fetch_assoc();
			$campaign_name = $row['name'];
		}else{
			$campaign_name = "The Campaign For This Hit Is No Longer Available";
			}
		// Set JSON Respoinse
		$data['success'] = true;
		$data['log_data'] = 'Log ID: '.$log_id.'
Campaign Name: '.$campaign_name.'
IP Address: '.$ip.'
User Agent: '.$useragent.'
Referring URL: '.$referrer.'
Keyword: '.$keyword .'
Time: '.adminmkdate($time_stamp).'

Action:
'.$action;
		// JSON Encode Data
		echo json_encode($data);
		exit;
	case "delete_logs":
		// Check Data Sent
		if(!isset($_POST['camp_id'])){
			exit;
			}
		// Loop Campaigns
		foreach($_POST['camp_id'] as $camp_id){
			if($camp_id=="ALL"){
				$sql="TRUNCATE logs";
				$conn->query($sql);
			}else{
				$sql="DELETE FROM logs WHERE id='".$conn->real_escape_string($camp_id)."'";
				$conn->query($sql);
				}
			}
		break;
	case "reset_db":
		// Clear Old Entries
		$sql = "TRUNCATE campaigns";
		$conn->query($sql);
		$sql = "TRUNCATE logs";
		$conn->query($sql);
		// Reset Database Entries
		$sql = "UPDATE settings SET admin_username='', admin_password='', twitter_consumer_key='', twitter_consumer_secret='', twitter_access_token='', twitter_access_token_secret='', stumbleupon_username='', stumbleupon_password='', block_bots='0', disable_logs='0', whitehat_html=''";
		$conn->query($sql);
		break;	
	case "save_settings_page_one":
		// Set Variables
		if(empty($_POST['twitter_consumer_key'])){$twitter_consumer_key = "";}else{$twitter_consumer_key = $conn->real_escape_string($_POST['twitter_consumer_key']);}
		if(empty($_POST['twitter_consumer_secret'])){$twitter_consumer_secret = "";}else{$twitter_consumer_secret = $conn->real_escape_string($_POST['twitter_consumer_secret']);}
		if(empty($_POST['twitter_access_token'])){$twitter_access_token = "";}else{$twitter_access_token = $conn->real_escape_string($_POST['twitter_access_token']);}
		if(empty($_POST['twitter_access_token_secret'])){$twitter_access_token_secret = "";}else{$twitter_access_token_secret = $conn->real_escape_string($_POST['twitter_access_token_secret']);}
		if(empty($_POST['stumbleupon_username'])){$stumbleupon_username = "";}else{$stumbleupon_username = $conn->real_escape_string($_POST['stumbleupon_username']);}
		if(empty($_POST['stumbleupon_password'])){$stumbleupon_password = "";}else{$stumbleupon_password = $conn->real_escape_string($_POST['stumbleupon_password']);}
		if(empty($_POST['captcha_api_key'])){$captcha_api_key = "";}else{$captcha_api_key = $conn->real_escape_string($_POST['captcha_api_key']);}
		if(empty($_POST['captcha_max_wait_time'])){$captcha_max_wait_time = "120";}else{$captcha_max_wait_time = $conn->real_escape_string($_POST['captcha_max_wait_time']);}
		if(!empty($errors)){goto ShowError;}
		// Check If Ok To Create Campaign
		if(empty($errors)){
			// Confirm Link Created Successfully
			if(!empty($errors)){goto ShowError;}
			// If No Error Update DB
			$sql = "UPDATE settings SET twitter_consumer_key='".$twitter_consumer_key."', twitter_consumer_secret='".$twitter_consumer_secret."', twitter_access_token='".$twitter_access_token."', twitter_access_token_secret='".$twitter_access_token_secret."', stumbleupon_username='".$stumbleupon_username."', stumbleupon_password='".$stumbleupon_password."', captcha_api_key='".$captcha_api_key."', captcha_max_wait_time='".$captcha_max_wait_time."'";
			// Insert Into DB
			if($conn->query($sql) === false){
				$errors['error'] = 'SQL Update Failed: '.$conn->error;
				goto ShowError;
				}
			}
		break;
	case "save_settings_page_two":
		// Set Variables
		if(empty($_POST['block_bots'])){$block_bots = "";}else{$block_bots = $conn->real_escape_string($_POST['block_bots']);}
		if(empty($_POST['disable_logs'])){$disable_logs = "";}else{$disable_logs = $conn->real_escape_string($_POST['disable_logs']);}
		if(empty($_POST['whitehat_html'])){$whitehat_html = "";}else{$whitehat_html = $conn->real_escape_string($_POST['whitehat_html']);}
		if(empty($_POST['bot_user_agents'])){$bot_user_agents = "";}else{$bot_user_agents = $conn->real_escape_string($_POST['bot_user_agents']);}
		if(!empty($errors)){goto ShowError;}
		// Check If Ok To Create Campaign
		if(empty($errors)){
			// Confirm Link Created Successfully
			if(!empty($errors)){goto ShowError;}
			// If No Error Update DB
			if($block_bots==""){$block_bots ="0";}
			if($disable_logs==""){$disable_logs ="0";}
			$sql = "UPDATE settings SET block_bots='".$block_bots."', disable_logs='".$disable_logs."', whitehat_html='".$whitehat_html."', bot_user_agents='".$bot_user_agents."'";
			// Insert Into DB
			if($conn->query($sql) === false){
				$errors['error'] = 'SQL Update Failed: '.$conn->error;
				goto ShowError;
				}
			}
		break;
	case "download_error_logs":
		// Check Zip Enabled
		if($zip_enabled==false){
			$errors['error'] = "Zip Is Not Enabled On Your Server\n\nYou Can Manually Download Error Log Files From The /admin/logs/ Folder Via FTP";
			goto ShowError;
			}
		// Set File Name
		$filename = "logs/exports/Error_Logs_".time()."_".GenerateRand(10).".zip";
		// Check If Already Exists
		if(file_exists($filename)){unlink($filename);}
		// Lookup Files
		$rootPath = realpath('logs');
		$files = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($rootPath), RecursiveIteratorIterator::LEAVES_ONLY);
		// Loop Files To Confirm Available
		$logs_available=false;
		foreach ($files as $name => $file){
			if(strstr($name, ".txt")){
				$logs_available=true;
				break;
				}
			}
		// Confirm Files Available
		if($logs_available==false){
			$errors['error'] = "No Error Log Files Available To Download";
			goto ShowError;
			}
		// Create Zip File
		$zip = new ZipArchive();
		if ($zip->open($filename, ZipArchive::CREATE)!==TRUE){
			$errors['error'] = "Failed To Create New Zip File (".$filename.")";
			goto ShowError;
			}
		// Loop Files
		foreach ($files as $name => $file){
			// Skip Directories Within Folder
			if (!$file->isDir()){
				// Get File Paths
				$filePath = $file->getRealPath();
				$relativePath = substr($filePath, strlen($rootPath) + 1);
				// Check File Ok
				if(!strstr($relativePath, ".txt")){continue;}
				// Add File To Zip
				$zip->addFile($filePath, $relativePath);
				}
			}
		// Close Zip
		$zip->close();
		// Set JSON Respoinse
		$data['success'] = true;
		$data['filepath'] = $filename;	
		$data['message'] = 'Success';
		break;	
	case "empty_actions_logs":
		// Clear Table
		$sql="TRUNCATE logs";
		$conn->query($sql);
		// Set JSON Respoinse
		$data['success'] = true;
		$data['message'] = 'Success';
		break;	
	default:
		$errors['error'] = "Unknown Form Processor Function Called: ".$process_name;
		goto ShowError;
		break;
	}
ShowError:
// Return Response
if(!empty($errors)){
	$data['success'] = false;
    $data['errors']  = $errors;
}else{
	// Display Success
    $data['success'] = true;
    $data['message'] = 'Success';
    }
// JSON Encode Data
echo json_encode($data);
?>