<?php
/**
 *	The template for displaying social icons.
 *
 *	@package Decode
 */
?>

<div class="contact-links">
	<div class="contact-links-container">
		<?php decode_social_icons_first(); ?>
		<?php if ( get_theme_mod( 'twitter_username', '' ) !== '' ) : ?>
			<a class="contact-link TwitterLink" href="<?php echo esc_url( 'https://twitter.com/' . get_theme_mod( 'twitter_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.772,0 0,44.772 0,100 C0,155.228 44.772,200 100,200 C155.228,200 200,155.228 200,100 C200,44.772 155.228,0 100,0 Z M131.085844,49.1820697 C135.882815,50.1099098 141.754127,52.7769806 144.349825,55.2862809 L146.460943,57.2809493 L150.570486,56.2253903 C152.865669,55.6318732 156.377938,54.4335696 158.436466,53.5245117 C160.494994,52.6154537 162.373213,51.9430514 162.546009,52.1158475 C163.263489,52.8333271 159.112625,58.6745877 155.502689,61.9764964 L151.629801,65.5000349 L155.033134,65.0304802 C156.937648,64.7787989 160.247069,63.9786777 162.31311,63.268711 C164.551947,62.4986412 166.069548,62.2619857 166.069548,62.6827067 C166.069548,63.0696198 163.34613,66.0296927 160.081786,69.2564726 L154.21423,75.1240283 L153.744676,81.8142438 C152.294691,102.455869 144.781815,119.371108 130.852945,133.465262 C119.910442,144.53924 107.288811,151.270776 92.2330088,154.125669 C85.3925358,155.425396 72.9775093,155.85363 67.1099537,155.064778 C59.920132,154.099374 50.9873232,151.402252 43.6322182,147.905008 L37.0584523,144.734575 L43.9853234,144.26502 C52.2419734,143.746632 57.9404893,142.375532 64.529281,139.336574 C69.3976242,137.090224 75.832402,133.149721 75.3290393,132.646358 C75.1787818,132.496101 73.2855372,131.988982 71.1030469,131.590799 C63.2896566,130.159597 56.0021675,124.953174 52.3208586,117.973713 L50.5590893,114.57038 L55.9608467,114.217275 C61.3776298,113.879196 63.3309774,113.270653 61.0094989,112.571955 C53.9924733,110.46835 46.9341269,104.642115 43.7524242,98.3688646 C42.471479,95.840782 40.5819908,89.0153348 40.5819908,86.8666524 C40.5819908,86.7389335 41.2318546,87.0469614 41.990655,87.4526567 C43.4594221,88.2377522 52.1856268,90.1685611 52.5575141,89.8004302 C52.6777201,89.6802242 51.0436698,87.8658648 49.0339756,85.8110934 C47.0280379,83.756322 44.5675712,80.322938 43.5157687,78.1817685 C41.7878073,74.6544736 41.6413063,73.6402354 41.6375498,67.2655607 C41.6337934,61.852534 41.9230391,59.4709525 42.9297644,56.9353571 L44.221979,53.6484741 L46.9228576,56.6987015 C59.2477296,70.5186357 77.2523354,79.5265732 96.9285559,81.7015506 L100.684994,82.0546558 L100.452094,76.7731044 C100.189144,70.3383267 101.402473,65.7442034 104.678087,60.8082443 C109.681662,53.2578046 118.787267,48.5134238 127.445856,48.712515 C128.681724,48.7425665 129.880027,48.9491706 131.085844,49.1820697 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'adn_username', '' ) !== '' ) : ?>
			<a class="contact-link ADNLink" href="<?php echo esc_url( 'https://alpha.app.net/' . get_theme_mod( 'adn_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,60.7447149 L130.378918,106.980358 L69.6210822,106.980358 Z M200,100 C200,155.23 155.228,200 100,200 C44.77,200 0,155.23 0,100 C0,44.772 44.77,0 100,0 C155.228,0 200,44.772 200,100 Z M30.5111332,141.808594 L44.7259545,141.808594 L60.531831,118.58977 L139.470495,118.58977 L155.267067,141.808594 L169.488867,141.808594 L99.9965108,37.3192437 Z M30.5111332,141.808594" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'facebook_username', '' ) !== '' ) : ?>
			<a class="contact-link FacebookLink" href="<?php echo esc_url( 'https://facebook.com/' . get_theme_mod( 'facebook_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C155.2286,0 200,43.710622 200,97.6306793 C200,148.238532 160.560101,189.852716 110.051993,194.774255 L110.051993,158.959922 L110.051993,122.527905 L124.471404,122.397324 L138.890815,122.266743 L139.306759,112.603771 C139.588936,107.28151 139.836506,101.324314 139.861352,99.4151196 L140,96.0200212 L125.025997,96.0200212 L110.051993,96.0200212 L110.190641,83.7454348 C110.322191,71.8949744 110.326406,71.3586533 111.299827,69.6427184 C113.362468,66.0067247 116.171813,65.3456729 129.740035,65.3335551 L139.445407,65.3335551 L139.722704,53.1895493 C139.898177,46.5698387 139.96983,41.1477099 139.861352,41.0455435 C139.358669,40.5721101 130.494503,40.0219997 122.807626,40.0008979 C113.439445,39.9751996 108.802828,40.4950153 103.258232,42.3513506 C92.4161664,45.9812853 85.2503847,53.0437168 81.7677643,63.5054252 C80.9145789,66.0681499 80.8160832,67.5452788 80.6585789,81.1338206 L80.5199307,96.0200212 L70.2599653,96.0200212 L60,96.0200212 L60,109.208673 L60,122.527905 L70.3986135,122.527905 L80.6585789,122.527905 L80.3812825,158.56818 C80.2399717,174.801548 80.213175,188.737218 80.3034396,193.368062 C34.5074589,184.437036 0,144.968308 0,97.6306793 C0,43.710622 44.7714,0 100,0 Z M100,0" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'google_plus_username', '' ) !== '' ) : ?>
			<a class="contact-link GooglePlusLink" href="<?php echo esc_url( 'https://plus.google.com/' . get_theme_mod( 'google_plus_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 L100,0 L100,0 Z M173.163613,87.3180651 L173.163613,87.2198751 L153.89495,87.2198751 L153.89495,67.5861017 L142.615733,67.5861017 L142.615733,87.2198751 L123.22582,87.2198751 L123.22582,98.1767526 L123.347071,98.1767526 L123.347071,98.5934728 L142.615733,98.5934728 L142.615733,117.855628 L153.89495,117.855628 L153.89495,98.5934728 L173.63358,98.5934728 L173.63358,87.3180651 L173.163613,87.3180651 Z M95.9225951,130.283006 C98.9548245,133.750194 100.472819,137.817797 100.472819,142.482997 C100.472819,148.223589 98.2555131,152.918387 93.8227808,156.56833 C89.2734967,160.27653 82.6817343,162.189591 74.0484337,162.310332 C64.4235019,162.190061 56.8401084,160.036928 51.2987231,155.850933 C45.4645481,151.663058 42.5493405,146.340126 42.5493405,139.881667 C42.5493405,136.591597 43.219514,133.781201 44.5612708,131.448601 C45.7286698,129.235333 47.1569006,127.380528 48.8492531,125.886537 C50.5989416,124.451741 52.3190222,123.344402 54.0113747,122.567808 C55.7023173,121.849001 57.0144662,121.31154 57.9487614,120.952136 C61.9143461,119.755534 65.7929868,118.889207 69.5856235,118.351276 C73.4355962,117.992812 75.8272602,117.872071 76.7610853,117.992812 C78.335946,117.992812 79.7059009,118.051068 80.8728299,118.171809 C87.698636,122.95587 92.7141278,126.991997 95.9225951,130.283006 Z M89.9760979,76.1760831 C89.5333886,78.6336522 88.5365878,81.0296763 86.9861655,83.3655649 C83.7706487,86.6622123 79.7519577,88.4000345 74.9296225,88.5790316 C71.1120775,88.5790316 67.7189131,87.4124967 64.7505992,85.074259 C61.7818153,82.7383704 59.3581935,79.8922696 57.4816138,76.5364264 C53.6025031,69.3469445 51.6643577,62.4247838 51.6643577,55.7737027 C51.544516,50.742052 52.8726438,46.1881968 55.6478011,42.1126067 C58.9375727,38.2183628 63.0667061,36.2108704 68.0314414,36.0905994 C71.7846008,36.2108704 75.1039804,37.3200886 77.9914599,39.4163748 C80.8206635,41.6334019 83.1004752,44.5095705 84.832775,48.0444108 C88.5276585,55.4152387 90.3751002,62.7249916 90.3751002,69.9750787 C90.3751002,71.653705 90.2411595,73.7208631 89.9760979,76.1760831 Z M79.3698742,30 C74.5075918,30 69.2980035,30.5689383 63.7411093,31.7035262 C58.1264091,33.01993 52.7147348,35.8303254 47.5065563,40.1337727 C39.9236328,47.4895667 36.131936,55.6792712 36.131936,64.7080539 C36.131936,72.1822398 38.8074603,78.7285535 44.1594487,84.3484046 C49.2722238,90.3877949 56.7061677,93.4669208 66.4579906,93.5857824 C68.3007327,93.5857824 70.2623765,93.4669208 72.344332,93.2273184 C71.9998459,94.1885469 71.6266918,95.2395089 71.2248697,96.3820835 C70.7652416,97.4640528 70.5363675,98.8180414 70.5363675,100.440291 C70.5363675,103.146388 71.1383957,105.462075 72.344332,107.385002 C73.3773203,109.369474 74.5545885,111.233675 75.8756668,112.977135 C71.6013136,113.096936 66.2300565,113.632518 59.7628354,114.588578 C53.2335787,115.722227 47.0004015,117.989993 41.0661235,121.392817 C35.7827503,124.554159 32.1325137,128.225244 30.1163536,132.403722 C28.0390979,136.581731 27,140.371207 27,143.774031 C27,150.756797 30.1948382,156.754845 36.5812248,161.769112 C42.9093355,167.139965 52.4905603,169.885527 65.3225495,170.006267 C80.6510053,169.766665 92.3809209,166.089003 100.510417,158.973281 C108.349002,152.096222 112.26853,144.202967 112.26853,135.293985 C112.157148,129.014993 110.728447,123.932133 107.984778,120.044936 C105.07333,116.217875 101.686275,112.721559 97.8236131,109.55082 L91.6092345,104.438362 C90.7125368,103.541498 89.7885809,102.495704 88.8373669,101.298631 C87.7174347,100.042833 87.1577036,98.4591076 87.1577036,96.5451071 C87.1577036,94.5719108 87.7038056,92.837847 88.7955399,91.3424461 C89.7227855,89.9071806 90.7322754,88.6227238 91.8240096,87.4857868 C93.733957,85.8123284 95.5353419,84.1670585 97.2272245,82.5523262 C98.7550884,80.937124 100.201648,79.1744019 101.566903,77.2594619 C104.35099,73.3130692 105.797549,68.0516821 105.906582,61.4734213 C105.906582,57.8850228 105.50288,54.7457614 104.698296,52.0546974 C103.719824,49.3641033 102.598482,47.0324429 101.333799,45.0592466 C100.010371,42.966249 98.6573352,41.2021175 97.277511,39.7663823 C95.8394108,38.3917222 94.5451207,37.3445187 93.3946406,36.6271209 L104.691716,36.6271209 L116.008061,30 L79.3698742,30 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'ello_username', '' ) !== '' ) : ?>
			<a class="contact-link ElloLink" href="<?php echo esc_url( 'https://ello.co/' . get_theme_mod( 'ello_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.772,0 0,44.772 0,100 C0,155.228 44.772,200 100,200 C155.228,200 200,155.228 200,100 C200,44.772 155.228,0 100,0 Z M100,160.000391 C72.6621094,160.000391 48.79375,141.496484 41.9609375,114.997656 C41.1734375,111.944141 43.0125,108.825391 46.0660156,108.037109 C49.1257813,107.246484 52.2378906,109.089062 53.0257813,112.145703 C58.5597656,133.592578 77.8734375,148.574219 100,148.574219 C122.123047,148.574219 141.440234,133.592578 146.971094,112.145703 C147.758594,109.089062 150.867578,107.242969 153.930859,108.037109 C156.9875,108.825391 158.826563,111.944141 158.035547,114.997656 C151.202734,141.496484 127.338281,160.000391 100,160.000391 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'sina_weibo_username', '' ) !== '' ) : ?>
			<a class="contact-link SinaWeiboLink" href="<?php echo esc_url( 'http://weibo.com/' . get_theme_mod( 'sina_weibo_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M139.537314,100.737216 C137.518821,100.133584 136.134023,99.721135 137.19107,97.0689856 C139.479954,91.3085456 139.717575,86.3401952 137.234724,82.7948839 C132.580495,76.146753 119.84688,76.5045478 105.250479,82.6172161 C105.250479,82.6076845 100.667241,84.6220409 101.83899,80.9865993 C104.084182,73.7676058 103.745488,67.723088 100.252085,64.2324114 C92.3338585,56.3087325 71.275039,64.5328644 53.2152787,82.5844466 C39.6923,96.1101514 31.8396311,110.44434 31.8396311,122.839262 C31.8396311,146.547504 62.2424233,160.9609 91.9869678,160.9609 C130.977177,160.9609 156.914197,138.306978 156.914197,120.320954 C156.914197,109.455596 147.761408,103.288178 139.537276,100.737082 L139.537314,100.737216 Z M92.066213,152.463766 C68.3334169,154.804539 47.8454601,144.078475 46.3022285,128.496056 C44.7617419,112.916362 62.7586894,98.3855002 86.4887785,96.0392558 C110.22432,93.6902854 130.712276,104.419095 132.252763,119.996043 C133.790524,135.583933 115.801773,150.117522 92.066213,152.463766 Z M94.4384022,108.029659 C83.1442203,105.090725 70.3778167,110.720049 65.4722981,120.670418 C60.4766304,130.820149 65.3083557,142.087032 76.7173164,145.771638 C88.5386493,149.581887 102.468606,143.74224 107.314037,132.786733 C112.091204,122.077063 106.125893,111.050545 94.4384022,108.029659 L94.4384022,108.029659 Z M93.375903,124.243028 C92.5455729,125.663341 90.7100854,126.34618 89.2733972,125.753471 C87.8585362,125.171704 87.4160634,123.58478 88.2190761,122.189039 C89.0466801,120.801515 90.8111578,120.124147 92.2205286,120.684067 C93.6544907,121.208492 94.1679926,122.814537 93.375903,124.243028 Z M85.8127449,133.950305 C83.5184093,137.613064 78.6019485,139.216363 74.8982231,137.525659 C71.2491323,135.86498 70.1729649,131.609512 72.4700456,128.039629 C74.7370829,124.483394 79.4869134,122.899196 83.1633406,124.439682 C86.8807152,126.023881 88.0688591,130.249305 85.8127449,133.950305 Z M150.969151,70.3999622 C146.385932,65.3168903 139.620334,63.3858205 133.37371,64.7132582 C130.819888,65.2568035 129.191997,67.7696591 129.740994,70.3262072 C130.287265,72.8691062 132.797395,74.5051941 135.34302,73.9507256 L135.34302,73.9545383 C138.396695,73.3071946 141.707111,74.2495202 143.949557,76.7295873 C146.192003,79.2178706 146.795635,82.6047488 145.831463,85.5764715 L145.835276,85.5764715 C145.034989,88.0565577 146.39247,90.7223753 148.875282,91.5281141 C151.360821,92.3229487 154.023912,90.9681936 154.824199,88.4826554 C156.788038,82.4053682 155.561654,75.4813566 150.967511,70.3983037 L150.969151,70.3999622 Z M165.428984,57.3514061 C156.013982,46.9121456 142.124993,42.9325394 129.303992,45.6584438 L129.30018,45.6584438 C126.336654,46.2921193 124.443825,49.2119524 125.080226,52.1727519 C125.711176,55.1335515 128.628264,57.0291068 131.594534,56.3954313 C140.714554,54.4588904 150.582971,57.2940453 157.280266,64.7069674 C163.966637,72.1226155 165.783004,82.2368506 162.917806,91.1028551 L162.919712,91.1047614 C161.985584,93.9945511 163.564311,97.0837214 166.456827,98.0178308 C169.338419,98.9492333 172.43306,97.3705062 173.367189,94.4916587 C173.367189,94.4878461 173.367189,94.4764083 173.369095,94.4697362 C177.386942,81.9956075 174.849495,67.7788665 165.429022,57.3505292 L165.428984,57.3514061 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
			<?php endif; ?>
		
		<?php if ( get_theme_mod( 'myspace_username', '' ) !== '' ) : ?>
			<a class="contact-link MySpaceLink" href="<?php echo esc_url( 'https://myspace.com/' . get_theme_mod( 'myspace_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M145.621677,107.364129 C131.463129,107.364129 121.080661,119.791097 121.080661,132.633419 L121.080661,141.274484 C121.080661,142.496694 122.081161,143.5 123.31179,143.5 L167.924548,143.5 C169.16079,143.5 170.16129,142.496694 170.16129,141.274484 L170.16129,132.633419 C170.16129,119.791097 159.781629,107.364129 145.621677,107.364129 Z M95.3258548,110.976032 C82.5831613,110.976032 73.2390806,122.162548 73.2390806,133.718113 L73.2390806,141.496194 C73.2390806,142.596323 74.1385484,143.5 75.2456935,143.5 L115.400403,143.5 C116.513161,143.5 117.411226,142.596323 117.411226,141.496194 L117.411226,133.718113 C117.411226,122.162548 108.068548,110.976032 95.3258548,110.976032 Z M49.7154032,114.232919 C38.2468387,114.232919 29.8387097,124.298258 29.8387097,134.697565 L29.8387097,141.698258 C29.8387097,142.687532 30.648371,143.5 31.6446613,143.5 L67.7805323,143.5 C68.7810323,143.5 69.5906935,142.687532 69.5906935,141.698258 L69.5906935,134.697565 C69.5906935,124.298258 61.1839677,114.232919 49.7154032,114.232919 Z M49.7154032,110.118661 C59.7021613,110.118661 67.8015806,102.057129 67.8015806,92.1068548 C67.8015806,82.152371 59.7021613,74.0880323 49.7154032,74.0880323 C39.7244355,74.0880323 31.6278226,82.152371 31.6278226,92.1068548 C31.6278226,102.057129 39.7244355,110.118661 49.7154032,110.118661 Z M95.3258548,106.411339 C106.421161,106.411339 115.421452,97.4475323 115.421452,86.3915161 C115.421452,75.3326935 106.421161,66.3688871 95.3258548,66.3688871 C84.2263387,66.3688871 75.2288548,75.3326935 75.2288548,86.3915161 C75.2288548,97.4475323 84.2263387,106.411339 95.3258548,106.411339 Z M145.624484,102.291468 C157.950419,102.291468 167.947,92.3341774 167.947,80.0475323 C167.947,67.7636935 157.950419,57.8035968 145.624484,57.8035968 C133.288726,57.8035968 123.290742,67.7636935 123.290742,80.0475323 C123.290742,92.3341774 133.288726,102.291468 145.624484,102.291468 Z M145.624484,102.291468" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'diaspora_id', '' ) !== '' ) : ?>
			<a class="contact-link DiasporaLink" href="<?php list( $user, $host ) = explode( '@', get_theme_mod( 'diaspora_id' ) ); $profileUrl = 'https://'.$host.'/u/'.$user; echo esc_url( $profileUrl ); ?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M43.919708,67.9159292 L83.5839416,80.8539823 L83.5839416,35 L116.416058,35 L116.416058,80.8539823 L156.080292,67.9159292 L165,96.2654867 L124.576642,108.823009 L150.956204,146.685841 L126.664234,164 L100.284672,128.230088 L73.1459854,164 L48.8540146,146.685841 L75.4233577,108.823009 L35,96.2654867 L43.919708,67.9159292 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
						
		<?php if ( get_theme_mod( 'vk_username', '' ) !== '' ) : ?>
			<a class="contact-link VKLink" href="<?php echo esc_url( 'https://vk.com/' . get_theme_mod( 'vk_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C155.2286,0 200,44.7714 200,100 C200,155.2286 155.2286,200 100,200 C44.7714,200 0,155.2286 0,100 C0,44.7714 44.7714,0 100,0 Z M98.4982462,139.599653 L106.866163,139.599653 C106.866163,139.599653 109.393201,139.321116 110.685313,137.930408 C111.872912,136.652592 111.834953,134.254716 111.834953,134.254716 C111.834953,134.254716 111.671282,123.026997 116.881634,121.373034 C122.02001,119.743228 128.616634,132.225099 135.608138,137.024302 C140.895395,140.655132 144.913218,139.860441 144.913218,139.860441 L163.609651,139.599653 C163.609651,139.599653 173.389475,138.995747 168.751971,131.306669 C168.372373,130.678607 166.050909,125.618616 154.850304,115.222561 C143.126643,104.34141 144.697784,106.101857 158.819814,87.2802068 C167.419434,75.8178271 170.857507,68.8204068 169.782801,65.8230618 C168.759365,62.9676963 162.433883,63.7219624 162.433883,63.7219624 L141.38345,63.8526033 C141.38345,63.8526033 139.821676,63.639634 138.664641,64.3322771 C137.533242,65.0091446 136.807076,66.5906385 136.807076,66.5906385 C136.807076,66.5906385 133.474009,75.4599204 129.032219,83.0040603 C119.658615,98.9205539 115.910454,99.7630642 114.377766,98.7731515 C110.812503,96.4694355 111.703819,89.5203278 111.703819,84.5821033 C111.703819,69.1566222 114.043523,62.725148 107.147657,61.0608328 C104.859717,60.5081973 103.174203,60.1428959 97.3219855,60.0837377 C89.8103825,60.0068322 83.454335,60.106415 79.8545631,61.8698201 C77.459645,63.0431229 75.6119395,65.6554471 76.7379159,65.8063004 C78.1296107,65.9916625 81.2797809,66.6566984 82.950012,68.9293564 C85.1078046,71.8650783 85.031885,78.4552935 85.031885,78.4552935 C85.031885,78.4552935 86.2717407,96.613387 82.1370807,98.8682975 C79.2999557,100.415282 75.407351,97.2572246 67.0502799,82.8162333 C62.7692036,75.4199887 59.536212,67.2423639 59.536212,67.2423639 C59.536212,67.2423639 58.9135728,65.7146053 57.800907,64.8967442 C56.4521018,63.9058456 54.5674225,63.5918146 54.5674225,63.5918146 L34.5631025,63.7224554 C34.5631025,63.7224554 31.5608277,63.8062628 30.4575286,65.1121784 C29.4759968,66.2746355 30.3791441,68.6764554 30.3791441,68.6764554 C30.3791441,68.6764554 46.0392858,105.31604 63.7724268,123.779784 C80.0354883,140.710839 98.4982462,139.599653 98.4982462,139.599653 Z M98.4982462,139.599653" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'dribbble_username', '' ) !== '' ) : ?>
			<a class="contact-link DribbbleLink" href="<?php echo esc_url( 'http://dribbble.com/' . get_theme_mod( 'dribbble_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771526,1.51545443e-14 0,44.771526 0,100 C-7.5791226e-15,155.228474 44.771526,200 100,200 C155.228474,200 200,155.228474 200,100 C200,44.771526 155.228474,-2.27373675e-14 100,0 L100,0 L100,0 Z M99.4161023,13.2698928 C103.84631,13.2619155 108.624192,13.4117861 110.775237,13.6980497 C127.243817,15.8897057 141.743632,22.0041619 154.443097,32.1151852 C158.241927,35.1397385 164.936926,41.815777 167.909323,45.547808 C178.052573,58.2833331 184.320866,73.1416391 186.432567,89.4434721 C186.929341,93.2784407 187.109187,102.404287 186.770978,106.473891 C184.692519,131.4839 172.315001,153.992021 152.387088,168.978402 C140.335593,178.041514 126.942188,183.514845 111.337128,185.765986 C107.809939,186.274835 95.183503,186.400549 91.3325359,185.964088 C67.3428113,183.245139 45.7075301,170.929871 31.2996039,151.794614 C22.4475975,140.038219 16.9076584,126.627696 14.6344314,111.439232 C14.0440071,107.494336 13.7916768,96.1186866 14.200243,92.0060229 C16.8046862,65.7894327 30.3744332,42.7773943 51.866087,28.1339654 C63.5725562,20.1577144 76.3786929,15.4113908 91.1026714,13.5830224 C92.7380313,13.3799506 95.9703852,13.2760973 99.4161023,13.2698928 L99.4161023,13.2698928 L99.4161023,13.2698928 Z M100.96694,26.1484303 C94.8161805,26.1409534 92.9542811,26.2771645 88.5984211,27.0436876 C87.6089985,27.2177998 86.5520088,27.4022395 86.2428151,27.4563948 C84.5604081,27.7510734 83.862464,27.8911958 83.7221263,27.9706915 C83.636145,28.0193976 84.7574267,29.7038019 86.2110684,31.7104541 C94.2499228,42.8075458 102.288466,55.3423887 108.846473,67.0064472 C110.080074,69.2005177 111.176552,70.9989745 111.284621,71.0001834 C111.392694,71.0014025 112.925734,70.4003077 114.687868,69.6668215 C126.260254,64.8498286 136.499864,58.2884692 143.824999,50.9934062 C146.470464,48.3587909 149.433386,44.8529767 149.41877,44.383741 C149.407757,44.0280052 145.344426,40.8109916 142.345602,38.7836213 C132.464592,32.1034997 122.236433,28.2226152 110.078246,26.5420896 C107.981965,26.2523361 105.662604,26.1541397 100.96694,26.1484303 L100.96694,26.1484303 L100.96694,26.1484303 Z M69.4615038,33.0311173 L66.5471557,34.54861 C59.8539779,38.0300265 54.3986069,42.0767741 48.6801069,47.8187352 C40.6786354,55.8530363 35.0107128,64.903285 31.3781495,75.4193255 C30.3778609,78.3150888 28.8955567,83.5791872 28.8955567,84.2512605 C28.8955567,84.5559537 33.786265,84.5618378 39.6894384,84.2639592 C57.3929201,83.3706037 75.0417385,80.8622417 91.1889527,76.9431677 C93.9716977,76.2677663 96.3839377,75.6700687 96.5477975,75.6098058 C96.8844548,75.4859906 96.8230237,75.3726289 92.8016856,68.5239399 C86.6147362,57.9870187 77.5042958,44.0573706 70.7186735,34.7581383 L69.4615038,33.0311173 L69.4615038,33.0311173 Z M157.818949,52.9426543 C157.728992,52.9599915 157.645315,53.0652321 157.52053,53.2410734 C154.309114,57.7664171 147.255462,64.370434 140.548739,69.1207781 C134.154222,73.6499904 126.261262,78.0356649 118.960975,81.1210348 C117.971553,81.5391994 117.071208,81.956405 116.960933,82.0480388 C116.850657,82.1396725 117.570264,83.8660576 118.560967,85.8830414 C119.551647,87.9000293 121.009911,91.1073797 121.799131,93.0070033 L123.234083,96.4610455 L124.80237,96.3277093 C125.668112,96.2554609 127.696246,96.0735284 129.304054,95.9213514 C133.250811,95.5477967 148.583605,95.543148 152.802969,95.915002 C159.457051,96.5014395 164.737501,97.1349189 169.330307,97.9023461 C171.926704,98.336184 174.090757,98.7388887 174.143108,98.791254 C174.485288,99.1334216 174.561998,98.6212725 174.466924,96.6896218 C173.680941,80.7211035 168.427243,66.4814795 158.606268,53.7299727 C158.148128,53.1351155 157.968877,52.9137582 157.818949,52.9426543 L157.818949,52.9426543 L157.818949,52.9426543 Z M102.668563,87.0132243 C102.642235,87.0151972 102.61374,87.0136673 102.586022,87.0195737 C102.313486,87.0776544 100.180578,87.6559037 97.8430633,88.3021408 C78.6980635,93.5950276 55.6500835,96.8527603 34.578218,97.2420146 L27.3272692,97.3753507 L27.3082212,98.4102935 C27.1729853,108.753547 28.8255169,117.792192 32.5972232,127.331547 C35.121041,133.714747 39.9997902,141.788247 44.5149384,147.065303 L46.0070338,148.811372 L48.0769194,145.719242 C49.215201,144.0162 50.9474113,141.557381 51.9246207,140.258808 C60.1579763,129.317745 70.4060584,119.578112 81.4490618,112.194715 C88.6684873,107.367779 96.8266606,103.366665 105.189252,100.556371 C107.287231,99.8513341 108.814336,99.2216704 108.77663,99.0769744 C108.685864,98.7286587 106.614479,94.2672919 104.687654,90.2577382 C103.340498,87.4544294 103.063482,86.9836232 102.668563,87.0132243 L102.668563,87.0132243 L102.668563,87.0132243 Z M141.729716,107.051748 C137.838234,107.08321 134.063943,107.321923 130.554874,107.781923 C129.135748,107.967953 127.926265,108.169206 127.869102,108.226376 C127.811918,108.283545 128.099304,109.214552 128.510386,110.296262 C133.033208,122.197384 138.905962,143.570854 141.577332,157.852835 C141.849153,159.306046 142.172906,160.500511 142.294808,160.500511 C142.416731,160.500511 142.882285,160.272038 143.329751,159.998912 C143.777216,159.725787 144.247364,159.385111 144.371043,159.236991 C144.49472,159.088892 145.656609,158.133817 146.955225,157.116311 C149.924094,154.790113 155.962826,148.758504 158.428486,145.655749 C165.454591,136.814236 170.636061,125.848613 172.955781,114.905884 C173.753031,111.144987 173.882364,111.458421 171.209712,110.715319 C162.365458,108.25628 151.674615,106.971346 141.729716,107.051748 L141.729716,107.051748 L141.729716,107.051748 Z M113.602131,111.86455 C112.994351,111.84962 111.91057,112.331243 109.627442,113.204261 C90.5369352,120.504044 74.1502542,132.275949 62.7312011,146.89387 C60.7798806,149.391821 57.4849703,154.33647 56.4453524,156.322643 L55.7723221,157.61156 L56.7818675,158.513166 C59.7697013,161.18692 67.7663453,165.732238 73.6457203,168.094324 C80.1160514,170.693848 87.7240384,172.477394 94.8969685,173.078557 C98.275617,173.361712 106.429853,173.185385 109.849669,172.754741 C116.184574,171.956975 123.722641,170.021001 128.542133,167.954638 L129.583425,167.510184 L129.14532,165.072037 C128.444517,161.168433 126.779866,153.586404 125.443654,148.239931 C122.953236,138.275267 120.222316,129.429327 114.871999,113.991579 C114.369054,112.540374 114.290946,111.88147 113.602131,111.86455 L113.602131,111.86455 L113.602131,111.86455 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'behance_username', '' ) !== '' ) : ?>
			<a class="contact-link BehanceLink" href="http://behance.net/<?php echo get_theme_mod( 'behance_username' );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M66.6865206,91.5470353 L46.6514947,91.5470353 L46.6514947,70.5389381 L65.1739922,70.5389381 C66.9255206,70.5389381 68.6360775,70.6618524 70.2646916,70.9827952 C71.9274485,71.2695951 73.358034,71.7953951 74.6247338,72.560195 C75.9016765,73.2942663 76.912305,74.3458662 77.6736906,75.6876803 C78.4111762,77.0294944 78.779919,78.7571227 78.779919,80.8500796 C78.779919,84.6194505 77.6736906,87.3645359 75.3963623,89.0272928 C73.0985483,90.717364 70.1929916,91.5470353 66.6865206,91.5470353 Z M100,0 C155.228474,-2.27373675e-14 200,44.771526 200,100 C200,155.228474 155.228474,200 100,200 C44.771526,200 -7.5791226e-15,155.228474 0,100 C0,44.771526 44.771526,1.51545443e-14 100,0 Z M130.366355,129.52413 C127.679313,126.908788 125.938027,122.036603 125.938027,116.887861 L172.918592,116.887861 C173.253192,111.838133 172.843478,107.010333 171.675792,102.397634 C170.49445,97.7678631 168.60635,93.6434065 165.95345,90.0413355 C163.297136,86.4256074 159.920408,83.5371221 155.799366,81.4100224 C151.664666,79.2487798 146.840281,78.1903514 141.333039,78.1903514 C136.344769,78.1903514 131.841326,79.0780655 127.754427,80.8398367 C123.670942,82.6118508 120.164471,85.032579 117.204285,88.0986072 C114.254343,91.1543925 112.011157,94.7940206 110.385958,99.0072486 C108.798315,103.213648 107.982301,107.761476 107.982301,112.630247 C107.982301,117.662903 108.767586,122.309746 110.321086,126.505902 C111.891657,130.725959 114.093871,134.317787 116.931143,137.356501 C119.843528,140.381557 123.305613,142.699857 127.443727,144.355785 C131.588669,145.991228 136.204783,146.820899 141.333039,146.820899 C148.690824,146.820899 155.007252,145.134242 160.183308,141.7541 C165.424236,138.387615 169.265307,132.791601 171.795292,124.955817 L156.045194,124.955817 C155.437452,126.970245 153.860052,128.909559 151.268609,130.725959 C148.653267,132.545773 145.536024,133.453973 141.930539,133.453973 C136.914954,133.453973 133.043155,132.139473 130.366355,129.52413 Z M67.7790919,129.824587 L46.6514947,129.824587 L46.6514947,105.064191 L68.175149,105.064191 C72.436177,105.064191 75.9016765,106.044091 78.4999476,108.010719 C81.0913901,110.01149 82.3956471,113.299447 82.3956471,117.932632 C82.3956471,120.302146 82.0132472,122.255117 81.2108901,123.760817 C80.4153616,125.283588 79.3193761,126.478588 77.9946334,127.349231 C76.6698907,128.25743 75.0993195,128.872002 73.3307197,129.257816 C71.58602,129.650459 69.7320631,129.824587 67.7790919,129.824587 Z M150.913524,95.3164062 C153.047452,97.6893345 154.60778,101.059234 155.034566,105.617305 L125.938027,105.617305 C126.01997,104.350605 126.296527,102.909777 126.754041,101.328963 C127.211555,99.7037628 128.000255,98.1809916 129.150869,96.7401632 C130.311726,95.3232348 131.831083,94.1214064 133.681626,93.1551637 C135.57314,92.1752638 137.93924,91.6938496 140.796996,91.6938496 C145.187767,91.6938496 148.786424,92.967378 150.913524,95.3164062 Z M69.2472346,55.2224544 L26.8554688,55.2224544 L26.8554688,145.134242 L70.4354058,145.134242 C74.4642624,145.134242 78.3975191,144.628928 82.1873757,143.621714 C86.0182038,142.6145 89.4393176,141.067829 92.4165743,138.961215 C95.3699311,136.868258 97.7667593,134.157315 99.5285305,130.818144 C101.269816,127.516531 102.143873,123.590102 102.143873,119.032032 C102.143873,113.40529 100.808888,108.608219 98.0774593,104.596434 C95.3596882,100.615377 91.2625459,97.815663 85.7279895,96.2246061 C89.790989,94.3023635 92.8331171,91.8270067 94.902174,88.8087785 C96.9575737,85.7837218 97.9852736,82.004108 97.9852736,77.48018 C97.9852736,73.2942663 97.295588,69.7536525 95.9264596,66.9300386 C94.5231883,64.0586247 92.5633886,61.7847107 90.0573032,60.0707395 C87.5136607,58.3567683 84.5022611,57.1105542 80.9753044,56.3628257 C77.427862,55.5946115 73.5458197,55.2224544 69.2472346,55.2224544 Z M122.281328,70.1292239 L158.728823,70.1292239 L158.728823,61.2520822 L122.281328,61.2520822 Z M122.281328,70.1292239" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'linkedin_profile_url', '' ) !== '' ) : ?>
			<a class="contact-link LinkedInLink" href="<?php echo esc_url( get_theme_mod( 'linkedin_profile_url' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M82.3806444,80.7221807 L82.3806444,159.65156 L106.90504,159.65156 L106.90504,120.605335 C106.90504,110.310265 108.852259,100.338328 121.617533,100.338328 C134.189081,100.338328 134.369024,112.111232 134.369024,121.269978 L134.369024,159.65156 L158.87198,159.65156 L158.87198,116.357901 C158.87198,95.0977583 154.286864,78.7542871 129.463839,78.7542871 C117.529368,78.7542871 109.525325,85.2988733 106.249586,91.5027153 L105.914967,91.5027153 L105.914967,80.7221807 Z M100,0 C155.228474,-2.27373675e-14 200,44.771526 200,100 C200,155.228474 155.228474,200 100,200 C44.771526,200 -7.5791226e-15,155.228474 0,100 C0,44.771526 44.771526,1.51545443e-14 100,0 Z M54.7252307,41.4822291 C46.8620791,41.4822291 40.5058594,47.8568261 40.5058594,55.7023661 C40.5058594,63.556329 46.8620791,69.930926 54.7252307,69.930926 C62.5677078,69.930926 68.9423048,63.556329 68.9423048,55.7023661 C68.9423048,47.8568261 62.5677078,41.4822291 54.7252307,41.4822291 Z M42.4530786,80.7221807 L42.4530786,159.65156 L66.9950856,159.65156 L66.9950856,80.7221807 Z M42.4530786,80.7221807" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
						
		<?php if ( get_theme_mod( 'pinterest_username', '' ) !== '' ) : ?>
			<a class="contact-link PinterestLink" href="<?php echo esc_url( 'http://pinterest.com/' . get_theme_mod( 'pinterest_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C155.228474,-2.27373675e-14 200,44.771526 200,100 C200,155.228474 155.228474,200 100,200 C44.771526,200 -7.5791226e-15,155.228474 0,100 C0,44.771526 44.771526,1.51545443e-14 100,0 Z M103.549742,24.2536772 C62.2072785,24.2536772 41.3620871,53.8954253 41.3620871,78.6121841 C41.3620871,93.5785078 47.0283376,106.893182 59.181348,111.855862 C61.1731854,112.669607 62.9591705,111.883889 63.5371029,109.677502 C63.9391429,108.150523 64.890122,104.297318 65.3143901,102.69399 C65.8971547,100.511764 65.6710073,99.7463418 64.0638139,97.8443835 C60.5594946,93.7109103 58.3192816,88.35972 58.3192816,80.7799139 C58.3192816,58.7894885 74.7729597,39.1040277 101.161664,39.1040277 C124.529269,39.1040277 137.367487,53.3822445 137.367487,72.4511152 C137.367487,97.5409207 126.264033,118.715669 109.780395,118.715669 C100.67651,118.715669 93.8621257,111.187084 96.0472515,101.954662 C98.662444,90.9304562 103.728534,79.0345194 103.728534,71.0768344 C103.728534,63.955122 99.9052887,58.0134355 91.9930265,58.0134355 C82.6871548,58.0134355 75.2117245,67.6411325 75.2117245,80.5363705 C75.2117245,88.7501626 77.9873464,94.3062387 77.9873464,94.3062387 C77.9873464,94.3062387 68.4640252,134.656166 66.7949795,141.721825 C63.469452,155.795156 66.2943625,173.047115 66.5340401,174.789611 C66.6741742,175.821771 68.0010994,176.067247 68.60126,175.287328 C69.4594606,174.166256 80.543586,160.483367 84.3117441,146.812076 C85.3777298,142.940509 90.4322224,122.893598 90.4322224,122.893598 C93.45622,128.659393 102.291434,133.739013 111.688152,133.739013 C139.660854,133.739013 158.637913,108.238469 158.637913,74.1037314 C158.637913,48.2919936 136.776024,24.2536772 103.549742,24.2536772 Z M103.549742,24.2536772" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'fancy_username', '' ) !== '' ) : ?>
			<a class="contact-link FancyLink" href="<?php echo esc_url( 'http://fancy.com/' . get_theme_mod( 'fancy_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M99.075,20.3126 C102.2932,20.329 105.8914,20.7546 110,21.6002 C118.1104,23.269 122.302,24.851 127.15,28.069 C135.7624,33.7856 140.836,41.5684 144.1876,54.2002 C145.348,58.5736 145.461,62.0684 145.4626,93.619 C145.4648,130.8112 145.5186,130.242 141.8626,132.9566 C140.0906,134.2722 138.8208,134.3924 124.2126,134.6442 L108.4688,134.913 L108.425,151.8006 C108.3746,172.6596 108.0866,174.708 104.7938,177.7256 C102.689,179.6548 101.824,179.9938 99.05,179.9568 C97.2536,179.9328 95.1666,179.6562 94.4124,179.3444 C93.6582,179.0326 92.2866,177.964 91.3624,176.9694 C89.1306,174.5674 88.6632,170.073 88.6186,150.4318 L88.5874,134.9194 L73.8562,134.6382 C60.326,134.3758 58.9722,134.237 57.2312,132.9444 C53.592,130.2424 53.642,130.8036 53.6312,93.4382 C53.6216,60.4038 53.6926,58.363 55.0374,53.3444 C57.182,45.3414 60.7218,39.2126 66.6436,33.232 C73.6946,26.111 77.0564,24.5046 92.1936,21.0196 C94.2974,20.5346 96.5718,20.2998 99.075,20.3126 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'etsy_username', '' ) !== '' ) : ?>
			<a class="contact-link EtsyLink" href="<?php echo esc_url( 'http://etsy.com/people/' . get_theme_mod( 'etsy_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771526,1.51545443e-14 0,44.771526 0,100 C-7.5791226e-15,155.228474 44.771526,200 100,200 C155.228474,200 200,155.228474 200,100 C200,44.771526 155.228474,-2.27373675e-14 100,0 Z M56.6926855,41.8316307 C58.9061914,41.8316307 81.3619382,42.5482312 96.4627353,42.5482312 C127.772506,42.5482312 135.283055,40 140.659797,40 C143.664586,40.0793038 144.297423,42.3886682 144.297423,43.7425653 C144.297423,45.0964624 142.874251,47.9628642 142.874251,51.704474 C142.874251,55.4470392 143.743335,59.4284713 143.743335,62.6923475 C143.743335,65.9571791 140.97669,67.071254 139.474769,67.071254 C137.9719,67.071254 137.026915,66.5132611 136.943422,63.7271185 C136.785924,58.3927448 140.659797,50.6697029 102.629811,50.6697029 C83.2585512,50.6697029 82.7841608,52.8997635 82.7841608,59.1093453 C82.7841608,65.3198825 82.9426072,85.8624286 82.9426072,89.047001 C82.9426072,92.2325289 83.8913881,93.1879961 86.4217868,93.1879961 L114.173629,93.1879961 C119.55037,93.1879961 125.004912,90.2422906 125.637749,82.5985525 C125.874944,78.5378166 126.981222,78.3782536 128.958482,78.3782536 C130.934792,78.3782536 132.753605,79.9710175 132.437661,83.7919311 C132.120769,87.6147556 131.330434,91.6754915 131.330434,97.1684728 C131.330434,102.663365 132.437661,108.077998 132.437661,112.057519 C132.437661,116.039907 127.218418,116.994418 126.191837,112.695771 C125.163358,108.396169 123.660489,101.149905 111.484784,101.149905 L86.8164797,101.149905 C84.1285833,101.149905 82.7841608,102.663365 82.7841608,107.121575 L82.7841608,138.891817 C82.7841608,144.384799 84.4445274,150.277165 95.5139544,150.277165 C106.582433,150.277165 126.665278,151.471499 135.837143,144.225235 C139.789765,140.960404 140.97669,136.42289 142.320163,129.018019 C142.953,125.594579 150.306052,125.673883 149.990108,133.556488 C149.751964,137.21975 146.267092,145.084201 146.267092,150.130979 C146.267092,154.352233 147.225361,160 143.348642,160 C140.072501,160 141.450131,158.318378 127.06092,158.318378 C112.67076,158.318378 63.0182079,158.637504 54.7163749,158.637504 C51.6328369,158.637504 51,157.76134 51,155.850406 C51,153.940427 52.1072273,152.50627 54.7163749,152.50627 C57.3255224,152.50627 68.3940006,152.664878 68.3940006,138.493387 L68.3940006,64.8421488 C68.3940006,57.1984107 66.733634,49.5556281 57.4042712,48.5992054 C53.7675939,48.2810348 54.0047892,46.6882708 53.9250916,44.8575956 C53.8529842,43.1864833 54.4791796,41.8316307 56.6926855,41.8316307 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'pinboard_username', '' ) !== '' ) : ?>
			<a class="contact-link PinboardLink" href="<?php echo esc_url( 'http://pinboard.in/u:' . get_theme_mod( 'pinboard_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771526,1.51545443e-14 0,44.771526 0,100 C-7.5791226e-15,155.228474 44.771526,200 100,200 C155.228474,200 200,155.228474 200,100 C200,44.771526 155.228474,-2.27373675e-14 100,0 Z M38,77.2421824 C40.7318666,78.0697417 43.9790937,77.4507727 47.009687,76.4894435 C51.3993724,75.09733 54.1152766,76.6957665 56.7992557,80.0672205 C65.510216,91.0091417 74.3671191,101.842233 83.3882078,112.534753 C86.0379816,115.674944 86.8452277,118.452369 85.1395213,122.358902 C83.171574,126.863999 81.7965193,131.650239 82.9640616,137.155209 C90.247519,130.677574 96.9950927,123.855311 103.567079,116.869803 C106.095994,114.180802 108.223566,114.037963 110.93719,116.547849 C115.876441,121.114162 120.99128,125.490024 126.010344,129.967913 C138.189726,140.83048 150.355425,151.708917 163,163 C162.500602,160.417561 160.902072,159.395016 159.768735,158.134405 C147.267823,144.204201 134.605006,130.416836 122.190747,116.411812 C113.710103,106.843866 113.856046,106.716898 122.963788,97.6704273 C128.030739,92.6370529 133.09769,87.6014112 139.199923,81.5364217 C131.55845,81.7948923 126.001222,83.3275775 120.66975,85.6334071 C117.887715,86.8350686 115.623322,86.9302946 113.149135,84.8398571 C101.761037,75.2129616 90.2976868,65.672223 78.7841689,56.1927012 C76.2210486,54.0841254 75.429765,51.8825909 76.3122628,48.5972938 C77.2791338,44.9900421 78.2163602,41.260357 77.7101211,38 C64.4384486,51.1162483 51.223785,64.1758144 38,77.2421824 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'delicious_username', '' ) !== '' ) : ?>
			<a class="contact-link DeliciousLink" href="<?php echo esc_url( 'http://delicious.com/' . get_theme_mod( 'delicious_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771526,1.51545443e-14 0,44.771526 0,100 C-7.5791226e-15,155.228474 44.771526,200 100,200 C155.228474,200 200,155.228474 200,100 C200,44.771526 155.228474,-2.27373675e-14 100,0 L100,0 L100,0 Z M100,190 C149.705627,190 190,149.705627 190,100 L190,100 L100,100 L100,10 C50.2943734,10 10,50.2943734 10,100 L100,100 L100,190 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'instagram_username', '' ) !== '' ) : ?>
			<a class="contact-link InstagramLink" href="<?php echo esc_url( 'http://instagram.com/' . get_theme_mod( 'instagram_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M150.003136,165 L49.9968638,165 C41.7151679,165 35,158.282476 35,149.994964 L35,49.9969963 C35,41.7140787 41.7151679,35 49.9968638,35 L150.003136,35 C158.285981,35 165,41.7140787 165,49.9969963 L165,149.994964 C165,158.282476 158.285981,165 150.003136,165 Z M155,88 L142.438773,88 C143.354031,91.5742396 143.894519,95.3087878 143.894519,99.1703003 C143.894519,123.842429 124.018868,143.837394 99.4993626,143.837394 C74.9811316,143.837394 55.1042066,123.842429 55.1042066,99.1703003 C55.1042066,95.3087878 55.6472432,91.5742396 56.5625022,88 L44,88 L44,149.421262 C44,152.500469 46.485731,155 49.5552901,155 L149.44471,155 C152.514269,155 155,152.500469 155,149.421262 L155,88 Z M156,48.9990813 C156,46.239423 153.760577,44 150.995177,44 L135.999081,44 C133.237126,44 131,46.239423 131,48.9990813 L131,64.0009187 C131,66.760577 133.237126,69 135.999081,69 L150.995177,69 C153.760577,69 156,66.760577 156,64.0009187 L156,48.9990813 Z M100.498369,65 C80.8917497,65 65,80.890484 65,100.497554 C65,120.101362 80.8917497,136 100.498369,136 C120.104989,136 136,120.101362 136,100.497554 C136,80.890484 120.104989,65 100.498369,65 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'vsco_username', '' ) !== '' ) : ?>
			<a class="contact-link VSCOLink" href="<?php echo esc_url( 'http://' .  get_theme_mod( 'vsco_username' ) . '.vsco.co/');?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M130.001931,141 C127.185953,141 124.369976,139.926397 122.220956,137.779762 C117.926348,133.481346 117.926348,126.516366 122.220956,122.220238 C124.367688,120.073603 127.183093,119 129.998498,119 C132.814476,119 135.630453,120.073603 137.779473,122.220238 C142.073509,126.518082 142.073509,133.481346 137.779473,137.779762 C135.632741,139.926397 132.817336,141 130.001931,141 Z M100.003182,170 C97.1878041,170 94.3707104,168.925141 92.2211393,166.775995 C87.9265729,162.481708 87.9265729,155.513716 92.2194233,151.223433 C94.3672784,149.074287 97.1832281,148 99.9986058,148 C102.813983,148 105.629361,149.074287 107.776072,151.223433 C112.074643,155.518292 112.074643,162.48514 107.776072,166.779427 C105.631077,168.926285 102.817987,170 100.003182,170 Z M159.000572,111 C152.926637,110.997712 148,106.072092 148,99.9979982 C148,93.922761 152.924349,89 158.993137,89 L158.996568,89 C165.073935,89 170,93.9216171 170,100.002002 C170,106.073807 165.077939,110.997712 159.000572,111 Z M100.001573,111 C97.1862594,110.999428 94.3703738,109.925281 92.2219955,107.775842 C87.9263829,103.484401 87.9263829,96.515599 92.2197076,92.2218698 C94.3680858,90.0741473 97.1839714,89 99.999285,89 C102.814599,89 105.629912,90.0741473 107.776575,92.2218698 C112.074475,96.5190308 112.074475,103.484401 107.776575,107.77813 C105.629912,109.925853 102.815743,111 100.001573,111 Z M70.0040044,140 C67.1883614,140 64.3710022,138.925713 62.2212285,136.776567 C57.9268294,132.481708 57.9268294,125.513716 62.2177961,121.221717 C64.3652817,119.073715 67.1803527,118 69.9965677,118 C72.8127828,118 75.630142,119.074287 77.7787716,121.221717 C82.0748868,125.51772 82.0725986,132.48514 77.7787716,136.779999 C75.6324302,138.926857 72.8190754,140.000572 70.0040044,140 Z M129.003718,81 C122.925621,80.9965685 118.003432,76.0746354 118,69.9974264 C118.003432,63.9247927 122.922761,59 128.995138,59 L128.999714,59 C135.078383,59 140,63.9236488 140,70.0037175 C140,76.0746354 135.078383,80.9982842 129.003718,81 Z M71.0005363,82 C68.1848841,82 65.369804,80.9262851 63.2223115,78.7788554 C58.9261823,74.484568 58.9261823,67.5177202 63.2205953,63.2205726 C65.3686599,61.0737149 68.1848841,60 71.0005363,60 C73.8161885,60 76.6312686,61.0737149 78.7787612,63.2205726 C83.0737463,67.5177202 83.0737463,74.4822798 78.7787612,78.7788554 C76.6312686,80.9262851 73.8161885,82 71.0005363,82 Z M41.0013587,111 C38.1855144,111 35.369098,109.925601 33.222031,107.777376 C28.9267528,103.48207 28.9267528,96.512209 33.2174542,92.2214796 C35.3668096,90.0738265 38.1826539,89 40.9990703,89 C43.8149147,89 46.630759,90.0738265 48.7795423,92.2214796 C53.0742484,96.51793 53.0742484,103.483786 48.7749655,107.780809 C46.6296148,109.927317 43.8160589,111.000572 41.0013587,111 Z M99.999714,52 C93.9261926,51.9959967 89.0040036,47.0724758 89,40.9988562 C89.0040036,34.9235208 93.9261926,30 99.999714,30 C106.078383,30 111,34.9235208 111,41.0005719 C111,47.0741915 106.078383,51.9959967 99.999714,52 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( '500px_username', '' ) !== '' ) : ?>
			<a class="contact-link Five00pxLink" href="<?php echo esc_url( 'http://500px.com/' . get_theme_mod( '500px_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771526,0 0,44.771526 0,100 C0,155.228474 44.771526,200 100,200 C155.228474,200 200,155.228474 200,100 C200,44.771526 155.228474,-2.4158454e-14 100,0 L100,0 L100,0 Z M30.0875,61.9 L50.86875,61.9 L71.65625,61.9 L71.65625,68.1125 L71.65625,74.325 L56.25625,74.325 C41.67261,74.325 40.853814,74.334156 40.80625,74.49375 C40.664562,74.969104 37.85882,91.23019 37.9,91.3375 C37.979636,91.54503 38.115102,91.485992 38.7,90.98125 C42.294234,87.879576 45.036694,86.620766 49.5125,86.0125 C51.137876,85.79161 54.32255,85.790516 55.9625,86.0125 C59.178368,86.4478 61.388124,87.17029 63.875,88.59375 C67.80974,90.84595 70.39191,93.552796 72.61875,97.75625 C72.946676,98.375254 73.248884,98.88125 73.2875,98.88125 C73.326118,98.88125 73.497924,98.524426 73.675,98.0875 C74.17002,96.866068 75.341936,94.597614 76,93.58125 C79.341602,88.420226 84.768238,84.741274 91.01875,83.39375 C93.295594,82.902894 97.532068,82.705484 99.96875,82.98125 C105.556838,83.613668 110.998136,86.152648 116.2875,90.5875 C118.20346,92.19393 121.28118,95.372662 124.28125,98.85625 C125.020992,99.71521 125.674134,100.41875 125.7375,100.41875 C125.800868,100.41875 126.467134,99.701944 127.21875,98.825 C129.358104,96.328908 130.454484,95.142974 132.79375,92.8 C136.1273,89.461192 138.66778,87.580408 142.23125,85.8 C146.110508,83.861818 149.038428,83.077396 153.025,82.90625 C156.913774,82.7393 160.164014,83.151548 163.2625,84.20625 C171.876804,87.13849 177.776536,94.548034 179.40625,104.475 C179.6724,106.096144 179.824994,109.95885 179.7,111.925 C179.11304,121.158664 174.934472,128.921004 168.14375,133.38125 C165.449816,135.150668 161.997592,136.405518 158.25625,136.98125 C156.742146,137.214248 152.078636,137.215574 150.475,136.98125 C146.151088,136.349422 141.854408,134.567788 137.525,131.6125 C134.491178,129.5416 130.689208,126.039908 126.98125,121.90625 L125.7375,120.525 L125.1125,121.18125 C122.495222,123.931746 118.269084,128.207656 117.4625,128.91875 C115.340868,130.789184 112.951316,132.509796 110.85,133.6875 C108.47477,135.018728 105.456452,136.170312 103.025,136.66875 C99.032756,137.487146 93.917676,137.352202 90.075,136.33125 C87.763104,135.717002 85.054354,134.467116 82.8125,132.975 C78.737872,130.263038 75.821604,126.724334 73.8375,122.0875 L73.56875,121.46875 L72.8125,122.9375 C69.692236,128.986972 64.97179,133.296954 58.75,135.7875 C55.897726,136.929248 53.372384,137.481092 50.08125,137.68125 C48.570016,137.773158 48.24085,137.780164 46.8125,137.71875 C38.80202,137.374326 32.287248,135.037 27.7,130.86875 C24.356908,127.831012 22.078616,123.997644 21.075,119.725 C20.777226,118.457304 20.546494,116.84692 20.45,115.36875 L20.375,114.2875 L27.8625,114.2875 L35.35,114.2875 L35.39375,114.5 C35.418436,114.619162 35.536768,115.19087 35.65,115.76875 C36.6058,120.646648 39.769496,123.997436 44.55,125.18125 C45.517866,125.420928 48.536126,125.53703 49.56875,125.375 C52.581306,124.902296 55.487844,123.189344 57.35625,120.7875 C58.879576,118.829256 59.880422,116.572886 60.35,114.025 C60.588334,112.73182 60.635642,110.14361 60.45,108.7375 C59.822108,103.981614 57.524202,100.467878 53.71875,98.44375 C52.012544,97.536214 50.179818,97.143298 47.61875,97.14375 C43.44915,97.14455 41.121416,98.013484 38.48125,100.5375 C37.97185,101.02449 37.267388,101.778816 36.91875,102.21875 L36.2875,103.01875 L30.2125,103.00625 C26.871272,102.99933 23.830852,102.970298 23.45625,102.9375 L22.775,102.875 L24.6375,92.425 C25.661652,86.678744 27.2813,77.6053 28.2375,72.25625 C29.1937,66.907198 30.001524,62.390872 30.03125,62.21875 L30.0875,61.9 L30.0875,61.9 Z M96.7875,97.53125 C94.206392,97.53125 92.134016,98.200508 90.35625,99.60625 C88.202858,101.309022 86.408028,104.360762 85.74375,107.4625 C85.494906,108.62443 85.50428,112.062294 85.75625,113.225 C86.0979,114.801488 86.835606,116.563222 87.675,117.8 C88.242722,118.63649 89.473336,119.878522 90.3,120.45 C91.60805,121.354248 93.093826,121.932612 94.8625,122.23125 C95.74549,122.380346 98.132298,122.406276 99.05,122.275 C102.669544,121.757226 106.578838,119.860174 110.60625,116.6625 C111.575472,115.892962 116.158996,111.385864 116.68125,110.6875 L116.9625,110.3125 L114.25,107.64375 C110.788126,104.234474 108.836646,102.584158 106.21875,100.86875 C102.66067,98.537278 99.81375,97.53125 96.7875,97.53125 L96.7875,97.53125 L96.7875,97.53125 Z M154.11875,97.55 C152.954244,97.560574 151.723058,97.639728 151.24375,97.76875 C147.432248,98.794756 143.796174,101.073724 139.79375,104.94375 C138.270038,106.41704 134.63125,110.248754 134.63125,110.38125 C134.63125,110.753954 139.303936,115.42542 141.18125,116.93125 C144.941864,119.947692 148.964768,121.887558 152.2375,122.2625 C153.484924,122.405412 155.997802,122.389672 156.90625,122.23125 C158.107146,122.021832 159.2017,121.649656 160.29375,121.0875 C161.11442,120.665036 161.408118,120.443482 162.28125,119.58125 C164.152584,117.733278 165.295898,115.550258 165.8,112.84375 C166.062482,111.43445 166.037572,108.59717 165.75,107.25625 C165.331924,105.306874 164.767302,103.943754 163.74375,102.40625 C161.929416,99.68092 159.13925,97.959272 155.96875,97.6125 C155.493534,97.560522 154.817454,97.543656 154.11875,97.55 L154.11875,97.55 L154.11875,97.55 Z M154.11875,97.55" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'flickr_username', '' ) !== '' ) : ?>
			<a class="contact-link FlickrLink" href="<?php echo esc_url( 'http://flickr.com/photos/' . get_theme_mod( 'flickr_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771526,3.03201907e-14 0,44.771526 0,100 C1.5158245e-14,155.228474 44.771526,200 100,200 C155.228474,200 200,155.228474 200,100 C200,44.771526 155.228474,-3.03201909e-14 100,0 L100,0 L100,0 Z M59.2,64.4 C78.851056,64.4 94.78125,80.330194 94.78125,99.98125 C94.78125,119.632306 78.851056,135.5625 59.2,135.5625 C39.548944,135.5625 23.61875,119.632306 23.61875,99.98125 C23.61875,80.330194 39.548944,64.4 59.2,64.4 L59.2,64.4 L59.2,64.4 Z M141.0375,64.4 C160.688556,64.4 176.61875,80.330194 176.61875,99.98125 C176.61875,119.632306 160.688556,135.5625 141.0375,135.5625 C121.386444,135.5625 105.45625,119.632306 105.45625,99.98125 C105.45625,80.330194 121.386444,64.4 141.0375,64.4 L141.0375,64.4 L141.0375,64.4 Z M141.0375,64.4" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'deviantart_username', '' ) !== '' ) : ?>
			<a class="contact-link DeviantARTLink" href="<?php echo esc_url( 'http://' . get_theme_mod( 'deviantart_username' ) . '.deviantart.com/' );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M50.0252938,62.9206124 C55.8172892,61.042542 61.841578,59.6290585 68.0258425,58.5377177 L74.4730806,70.8426946 C107.38862,63.9462098 161.819789,70.1238999 180.039483,97.9114524 L104.901327,118.806903 L86.4208516,84.5348577 C90.0586542,83.9979531 94.1457036,83.5048775 97.9040358,83.2857328 C101.4235,83.1345229 104.820244,83.2265637 108.063586,83.5333663 L118.025905,100.304513 L143.334931,94.1399715 C127.205878,77.6383729 101.182441,78.2037663 80.1160576,81.6158499 L100.277373,120.095474 L25.0077308,141.025988 C22.2377413,135.867321 20.5766242,129.702779 20.169015,123.568918 C18.7796374,102.623064 32.9341959,85.0892939 56.0189024,75.6112841 L50.0252938,62.9206124 Z M72.8689411,111.296813 L61.6027103,87.4363341 C50.9040642,93.309413 44.9542847,102.912335 47.5511498,117.463546 L72.8689411,111.296813 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'bandcamp_username', '' ) !== '' ) : ?>
			<a class="contact-link BandcampLink" href="<?php echo esc_url( get_theme_mod( 'bandcamp_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771526,3.03201907e-14 0,44.771526 0,100 C1.5158245e-14,155.228474 44.771526,200 100,200 C155.228474,200 200,155.228474 200,100 C200,44.771526 155.228474,-1.51545443e-14 100,0 Z M167,128 C158.704905,125.945239 152.84147,119.647851 152,111 C151.891185,107.689014 151.925642,104.298818 153,101 C154.916083,90.1856222 163.231203,85.4765284 173,86 C178.263805,86.3229406 182.793818,87.6986261 186,91 C188.56381,93.9099189 189.742106,96.8455988 190,100 C187.167114,100.449362 184.637456,100.449362 181,100 C181.05307,100.449362 181.041053,99.9546356 181,100 C179.264086,95.1163198 176.932724,93.2595883 173,93 C167.890578,92.8293098 164.219907,94.777494 163,99 C160.173171,104.434178 160.063419,110.117434 163,116 C164.654482,119.488531 168.287704,121.302422 173,121 C176.500075,120.511117 179.509553,117.982961 181,114 C180.976565,112.141156 180.920513,111.889038 181,112 C185.001492,111.889038 187.597096,111.889039 190,112 C189.856778,112.648772 189.802761,113.260236 190,114 C187.780347,122.042149 181.551148,126.875533 174,128 C170.079462,128.324067 167.908834,127.725148 167,128 Z M128,128 C127.383562,127.886397 126.873988,127.745411 126,128 C122.72504,127.09163 119.428064,125.898898 117,123 C116.878802,122.522794 116.614417,122.232168 116,122 C116.104882,123.568119 116,127 116,127 L108,127 L108,72 L77,126 L10,126 L41,72 L117,72 C117,72 116.508609,85.1486788 117,92 C117.48765,90.9772738 118.182851,90.3065813 119,90 C126.871475,82.9122307 140.249108,85.6058568 145,95 C149.00345,102.946329 148.897395,110.983257 145,119 C143.046986,123.527163 139.271547,126.439628 134,128 C133.483222,127.690012 132.805974,127.847476 132,128 L128,128 Z M118,114 C119.44827,118.338842 122.514332,120.63708 127,121 C131.098042,121.278027 134.69956,119.809823 137,116 C139.843585,109.846063 139.805205,103.680997 136,98 C134.106861,94.0838863 130.578772,92.6421418 126,93 C122.34639,93.4807049 119.880975,95.1485431 118,99 C117.559904,101.184503 117.000078,102.285161 117,106 C117.000078,110.166673 116.973052,111.928854 118,114 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'soundcloud_username', '' ) !== '' ) : ?>
			<a class="contact-link SoundcloudLink" href="<?php echo esc_url( 'http://soundcloud.com/' . get_theme_mod( 'soundcloud_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M94.8071745,132.33886 L94.8073394,132.336881 L94.8071633,132.339347 C94.7943756,132.892376 94.5629384,133.393385 94.1981651,133.756697 C93.8311927,134.122569 93.3288073,134.348991 92.7790826,134.348991 C92.16,134.348991 91.6014679,134.062385 91.2278899,133.615046 C90.9515596,133.284404 90.7787156,132.864954 90.7559633,132.409541 C90.7544954,132.386422 90.7515596,132.36367 90.7511927,132.340183 C90.7511927,132.340183 89.9856881,116.046972 89.9856881,116.022752 L90.7438532,75.826055 L90.7511927,75.4433028 C90.7622018,74.7354128 91.1346789,74.1119266 91.6866055,73.7508257 C92.0033028,73.5438532 92.3779817,73.4220183 92.7790826,73.4220183 C93.1915596,73.4220183 93.5772477,73.5493578 93.8994495,73.7677064 C94.4355963,74.1310092 94.7952294,74.746055 94.8073394,75.4418349 L95.6612844,116.035596 L94.8917431,130.718165 L94.8073622,132.330574 L94.8077064,132.329541 L94.8073394,132.333578 L94.8072418,132.335824 C94.8072762,132.33422 94.8073087,132.332615 94.8073394,132.331009 L94.8073394,132.336514 L94.8071811,132.338573 C94.8071789,132.338669 94.8071767,132.338764 94.8071745,132.33886 L94.8071745,132.33886 Z M0,100 C7.5791226e-15,155.228474 44.771526,200 100,200 C155.228474,200 200,155.228474 200,100 C200,44.771526 155.228474,-2.2737368e-14 100,0 C44.771526,1.5158245e-14 0,44.771526 0,100 Z M160.106789,95.0829358 C157.413945,95.0829358 154.844404,95.6289908 152.504954,96.6088073 C150.940917,78.8979817 136.088807,65.0033028 117.971009,65.0033028 C113.537248,65.0033028 109.216147,65.8748624 105.398532,67.3519266 C103.914862,67.9266055 103.521468,68.5155963 103.507156,69.6627523 L103.507156,132.038165 C103.522936,133.241101 104.456147,134.17578 105.630092,134.293211 C105.680367,134.298349 160.106789,134.293211 160.106789,134.293211 C170.960367,134.293211 179.758532,125.592294 179.758532,114.737248 C179.758532,103.881835 170.960367,95.0829358 160.106789,95.0829358 Z M100.591193,69.9188991 C100.267523,69.7229358 99.8913761,69.6080734 99.4902752,69.6080734 C98.9743119,69.6080734 98.4983486,69.7933945 98.1247706,70.1020183 C97.6444037,70.4983486 97.333578,71.0976147 97.3247706,71.7666055 L97.320367,71.9897248 L96.4374312,116.039633 L96.8877064,124.182752 L97.3251376,132.107156 C97.3405505,133.28 98.3108257,134.24844 99.4902752,134.24844 C100.665688,134.24844 101.63633,133.28 101.652844,132.090275 L101.652844,132.108624 L101.652844,132.108991 L102.616147,116.04 L102.616147,116.039633 L101.652844,71.7640367 C101.642202,70.9812844 101.216147,70.2965138 100.591193,69.9188991 Z M86.0392661,80.0363303 C84.9988991,80.0363303 84.1673394,80.8645872 84.1475229,81.9207339 L83.3020183,116.030826 L84.1482569,132.44367 C84.1677064,133.489174 84.9988991,134.314862 86.0392661,134.314862 C87.0766972,134.314862 87.9075229,133.489174 87.9302752,132.431927 L87.9302752,132.445505 L88.8777982,116.032294 L87.9302752,81.9174312 C87.9075229,80.8638532 87.0766972,80.0363303 86.0392661,80.0363303 Z M79.3504587,78.88 C78.3882569,78.88 77.6168807,79.6469725 77.5944954,80.626055 L76.6682569,116.028991 L77.5955963,132.546055 C77.6172477,133.515963 78.3882569,134.284771 79.3504587,134.284771 C80.3086239,134.284771 81.0788991,133.515963 81.1049541,132.537615 L81.1049541,132.549358 L82.146422,116.028991 L81.1049541,80.6242202 C81.0788991,79.6462385 80.3089908,78.88 79.3504587,78.88 Z M74.3317431,79.6957798 C74.3031193,78.7930275 73.5926606,78.0866055 72.7133945,78.0866055 C71.8311927,78.0866055 71.12,78.7937615 71.0943119,79.6968807 L70.0873394,116.026055 L71.0950459,132.702385 C71.12,133.595229 71.8311927,134.301284 72.7133945,134.301284 C73.5926606,134.301284 74.3023853,133.595229 74.3317431,132.695046 L75.466422,116.027156 L74.3317431,79.6957798 Z M66.1273394,79.4058716 C65.3240367,79.4058716 64.6726606,80.053211 64.6440367,80.8785321 C64.6440367,80.879633 63.5566972,116.023853 63.5566972,116.023853 L64.6447706,132.804404 C64.6726606,133.621651 65.3240367,134.267523 66.1273394,134.267523 C66.9262385,134.267523 67.5768807,133.623119 67.6099083,132.797431 L67.6091743,132.807339 L68.8370642,116.023486 L67.6099083,80.8774312 C67.5768807,80.0521101 66.9262385,79.4058716 66.1273394,79.4058716 Z M59.4943119,82.3368807 C58.7695413,82.3368807 58.1783486,82.9225688 58.146789,83.6708257 C58.146789,83.6726606 56.9790826,116.109358 56.9790826,116.109358 L58.1482569,133.064587 C58.1783486,133.806239 58.7695413,134.391927 59.4943119,134.391927 C60.213945,134.391927 60.8051376,133.806239 60.839633,133.057982 L60.8388991,133.067523 L62.1607339,116.108991 L60.839633,83.6704587 C60.8051376,82.9222018 60.213945,82.3368807 59.4943119,82.3368807 Z M53.1108257,88.4190826 C52.4653211,88.4190826 51.933578,88.9453211 51.9009174,89.6165138 C51.9009174,89.6172477 50.6517431,116.017248 50.6517431,116.017248 L51.9009174,133.078165 C51.933578,133.74422 52.4653211,134.271193 53.1108257,134.271193 C53.7508257,134.271193 54.2818349,133.744587 54.32,133.074495 L54.32,133.079633 L55.733578,116.016881 L54.32,89.6150459 C54.2822018,88.9442202 53.7511927,88.4190826 53.1108257,88.4190826 Z M47.7522936,99.7768807 C47.7111927,99.1787156 47.2495413,98.7240367 46.6788991,98.7240367 C46.1031193,98.7240367 45.6418349,99.1794495 45.6058716,99.7838532 L44.2755963,116.010642 L45.6058716,133.073394 C45.6418349,133.674495 46.1027523,134.130642 46.6788991,134.130642 C47.2491743,134.130642 47.7104587,133.674862 47.7522936,133.072661 L49.2594495,116.010642 L47.7522936,99.7768807 Z M47.7526606,133.07156 L47.7526606,133.072661 L47.7522936,133.074862 L47.7526606,133.07156 Z M40.2998165,97.5944954 C39.8044037,97.5944954 39.4011009,97.9908257 39.3614679,98.5159633 L37.9522936,116.009174 L39.3618349,132.932477 C39.4011009,133.45578 39.8047706,133.851743 40.3001835,133.851743 C40.7889908,133.851743 41.1919266,133.45578 41.2363303,132.932477 L42.8370642,116.009174 L41.2359633,98.5130275 C41.1915596,97.9897248 40.7886239,97.5944954 40.2998165,97.5944954 Z M33.9710092,98.1963303 C33.5489908,98.1963303 33.2121101,98.5258716 33.1695413,98.9805505 C33.1695413,98.9816514 31.6788991,116.005505 31.6788991,116.005505 L33.1695413,132.408807 C33.2117431,132.864954 33.5486239,133.194128 33.9710092,133.194128 C34.3853211,133.194128 34.7214679,132.865321 34.7706422,132.41211 L36.4653211,116.005505 L34.7717431,98.9798165 C34.7214679,98.5251376 34.3853211,98.1963303 33.9710092,98.1963303 Z M21.786422,106.505321 C21.453211,106.505321 21.1897248,106.762936 21.1456881,107.130275 L19.9772477,116.004037 L21.1456881,124.726606 C21.1897248,125.093945 21.453211,125.350826 21.786422,125.350826 C22.1104587,125.350826 22.372844,125.096147 22.4256881,124.729908 L23.8095413,116.004404 L22.4256881,107.127706 C22.373578,106.761101 22.1104587,106.505321 21.786422,106.505321 Z M27.693945,101.009541 C27.3544954,101.009541 27.0748624,101.281101 27.0293578,101.655413 C27.0293578,101.656881 25.4583486,116.004037 25.4583486,116.004037 L27.0293578,130.035963 C27.0748624,130.411376 27.3544954,130.68367 27.693945,130.68367 C28.0308257,130.68367 28.3031193,130.418349 28.3570642,130.039266 L30.1453211,116.004037 L28.3577982,101.654679 C28.3031193,101.273761 28.0308257,101.009541 27.693945,101.009541 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'itunes_link', '' ) !== '' ) : ?>
			<a class="contact-link iTunesLink" href="<?php echo esc_url( get_theme_mod( 'itunes_link' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771526,0 0,44.771526 0,100 C0,155.228484 44.771526,200 100,200 C155.228474,200 200,155.228484 200,100 C200,44.771526 155.228474,0 100,0 L100,0 L100,0 Z M149,49 C148.668441,61.5550901 148.460879,86.4761451 148,104 L148,137 L147,139 C143.518359,144.25531 136.882449,149.249408 131,151 C127.118503,151.394631 119.660938,150.856832 116,150 C111.727474,147.686235 107.360918,143.224358 106,139 C105.649392,137.688869 105.506363,135.48484 106,133 C105.945624,128.281332 107.530167,125.11911 112,121 C118.01357,114.711914 123.97545,113.215118 136,115 L138,115 L138,90 L138,65 L137,65 C134.506093,64.7474554 118.179227,67.111509 108,69 C100.638618,70.2215058 89.6194811,72.6314459 81,75 L77,76 L76,107 C76.0101464,141.644043 75.5639761,152.168046 74,155 C73.3364657,157.108322 67.6672516,162.744669 65,164 C63.4753272,164.98039 61.1612794,165.871823 60,166 C56.4363802,167.16669 49.7772783,167.264166 46,166 C38.9416117,164.444789 33.7902199,158.413752 33,151 C32.8626364,147.960317 32.90928,147.368897 34,144 C37.222562,137.668539 44.1870761,131.913186 51,131 C53.8297703,129.932611 61.7150482,130.15965 65,131 L66,131 L66,88 C66.1456948,57.2466992 66.2844036,43.4063874 67,42 C67.2077808,40.6193086 66.4679619,40.9769126 78,37 C89.6126056,33.9635683 101.876124,30.3497105 112,28 C119.878756,27.1237702 134.41096,26.2067087 142,26 L149,26 L149,49 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'rdio_username', '' ) !== '' ) : ?>
			<a class="contact-link RdioLink" href="<?php echo esc_url( 'http://rdio.com/people/' . get_theme_mod( 'rdio_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771526,3.03201907e-14 0,44.771526 0,100 C1.5158245e-14,155.228474 44.771526,200 100,200 C155.228474,200 200,155.228474 200,100 C200,44.771526 155.228474,-1.51545443e-14 100,0 Z M118.655206,78.7854975 C113.344399,75.7677855 108.016188,75.3632747 102.787907,75.7677867 C89.0861297,76.8278928 74.3556565,87.9204192 72.2166939,101.16735 C70.4689254,110.710643 75.1089862,119.032609 84.2182063,123.745851 C101.771113,132.061227 124.677151,121.559776 129.895303,102.302887 C130.19225,101.014883 130.572705,100.090324 130.572705,97.3570649 L130.572705,53.9352638 C130.572705,53.9352638 130.572703,53.6992613 130.572705,48.8167346 C138.690873,53.6992615 147.325542,58.9052855 155.348335,62.8898621 C159.716248,64.427798 165.148529,67.0319906 171.077392,67.8824602 C177.006254,68.7329297 180.166321,67.6133632 181.858392,69.3466119 C183.550464,71.0798605 183.200588,74.1573278 181.858392,76.8278928 C178.733451,83.0455866 175.186882,86.8021366 167.355044,91.1984846 C165.732274,92.1094155 163.488404,92.6042323 162.398809,93.0608825 C162.398809,101.16735 162.834641,106.112667 161.298572,112.420341 C156.616643,137.01359 137.946439,154.858831 112.704969,158.978992 C93.891673,161.987493 76.2435207,158.536444 61.1362472,146.101067 C49.0495259,135.993663 42.3668186,123.103458 40.3104173,107.467293 C36.9562727,73.1602908 61.2454346,47.8378086 90.8358087,42.7305092 C100.907571,40.9921227 113.505499,42.7305092 118.655206,44.06828 C118.522046,55.4024282 118.522047,68.1747182 118.655206,78.7854975 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'spotify_username', '' ) !== '' ) : ?>
			<a class="contact-link SpotifyLink" href="<?php echo esc_url( 'http://open.spotify.com/user/' . get_theme_mod( 'spotify_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C155.228474,-1.51545443e-14 200,44.771526 200,100 C200,155.228474 155.228474,200 100,200 C44.771526,200 1.5158245e-14,155.228474 0,100 C0,44.771526 44.771526,3.03201907e-14 100,0 Z M159.465,112.671735 C159.452129,112.221004 159.478005,111.69969 159.342258,111.174312 C159.199872,110.623736 159.083633,110.07492 158.850207,109.547375 C158.539695,108.845471 158.134214,108.20277 157.679012,107.598951 C157.388415,107.21352 156.982663,106.912085 156.615657,106.587618 C156.182674,106.204762 155.678295,105.923783 155.186515,105.625735 C154.608843,105.275799 154.039435,104.911367 153.453228,104.576469 C152.999381,104.317167 152.497441,104.134815 152.066219,103.844896 C151.381249,103.384411 150.636399,103.043552 149.913361,102.65934 C149.081806,102.217416 148.241038,101.792968 147.402168,101.364997 C146.395983,100.851812 145.413101,100.281049 144.372641,99.8500985 C143.389352,99.4427205 142.443997,98.9505342 141.442554,98.5843411 C140.954432,98.4059185 140.51752,98.0689883 140.022083,97.932157 C138.988261,97.6467079 138.088561,97.0172838 137.028457,96.8156947 C135.75281,96.1808516 134.389916,95.7698158 133.05493,95.2915835 C131.500201,94.7347749 129.926641,94.2298538 128.355926,93.7188363 C127.598341,93.4724044 126.832357,93.2491391 126.062714,93.0430792 C125.554677,92.9070608 125.061678,92.7244384 124.541584,92.6203924 C123.98762,92.5095726 123.446798,92.3236987 122.904349,92.1611269 C122.298092,91.9794528 121.687093,91.8264998 121.072571,91.6801851 C120.476339,91.5383412 119.869946,91.4139737 119.288887,91.2397509 C118.459093,90.9908804 117.612093,90.8083935 116.773629,90.629158 C116.005071,90.464825 115.247486,90.1803242 114.442484,90.1929235 C113.947317,89.9177707 113.351762,90.0356353 112.849957,89.7864939 C112.18558,89.8696765 111.596799,89.4182686 110.93039,89.5155408 C110.31492,89.2459425 109.634828,89.2913271 108.993075,89.1343098 C108.753553,89.0756484 108.507256,88.9625255 108.242535,88.9706541 C107.961557,88.9791891 107.691959,88.9176828 107.413825,88.8596988 C106.827889,88.7377699 106.22258,88.7116229 105.631767,88.5779076 C105.320577,88.5074598 104.994891,88.5565023 104.668257,88.4509661 C104.37197,88.3550487 104.034904,88.4016526 103.70949,88.3161669 C103.362263,88.2248557 102.984826,88.2785044 102.614433,88.179742 C102.267748,88.087347 101.889498,88.1139004 101.520595,88.0449428 C100.897945,87.928704 100.252264,87.9346649 99.6163368,87.890635 C99.5488695,87.8860288 99.4548487,87.9190851 99.4174572,87.8853515 C99.1658773,87.6586992 98.8645774,87.7943112 98.5890181,87.7535328 C98.3135943,87.7127543 98.04088,87.6466418 97.7642369,87.6227979 C97.2635155,87.5797164 96.7671295,87.6217141 96.2576022,87.5079138 C95.7110897,87.3858494 95.1282696,87.4705223 94.5546619,87.3689148 C93.8882528,87.2509148 93.1990835,87.3495417 92.5111336,87.2356059 C91.6653535,87.0955232 90.7947812,87.2365543 89.9256991,87.1037872 C89.1094529,86.9791488 88.256899,87.0383521 87.4246665,87.0879365 C86.5971758,87.1372499 85.7944772,86.9256356 84.9743022,86.9410799 C83.2318028,86.9737297 81.4878131,86.8687354 79.746533,87.0653119 C79.1000389,87.1383338 78.438236,87.0658538 77.7838842,87.0803498 C77.1464671,87.0945748 76.5148754,87.0834658 75.8719037,87.1880537 C75.0484772,87.32204 74.1971425,87.1621776 73.3551558,87.3319297 C72.7356215,87.4568391 72.0880436,87.2972478 71.4452074,87.4629356 C70.9692783,87.5856773 70.4517578,87.4943661 69.9442627,87.5955671 C69.3935505,87.7053031 68.8130335,87.6276751 68.240916,87.7375465 C67.6192141,87.8570369 66.9721781,87.8449794 66.3362512,87.8894158 C66.291273,87.8925317 66.2282764,87.8703136 66.2034842,87.8928027 C65.9329375,88.1380152 65.6057616,87.9781529 65.3086615,88.0248923 C65.0121034,88.0716317 64.7139195,88.1587431 64.4184451,88.151021 C63.9307295,88.1382862 63.4759348,88.3956916 62.9842904,88.2962518 C62.6167425,88.5999903 62.1106021,88.2684791 61.7419704,88.5672049 C61.2944913,88.4722359 60.8811524,88.68805 60.4450534,88.7212418 C60.1051427,88.7471178 59.7350208,88.763375 59.424373,88.8634922 C59.0090019,88.997343 58.5853668,89.0221352 58.1708085,89.0904154 C57.789442,89.1532765 57.4151203,89.3413179 57.0109938,89.2444522 C56.2780656,89.5408749 55.4852568,89.589511 54.7240141,89.7617017 C54.0000274,89.9254928 53.2637124,90.0685561 52.5282102,90.196175 C52.2168851,90.2502301 51.9116564,90.3399156 51.6046665,90.4174082 C51.0120921,90.5668388 50.4280527,90.7779113 49.8264013,90.8560813 C48.9570483,90.9689332 48.1448664,91.2787681 47.3016603,91.4772412 C46.7518965,91.6066214 46.2105322,91.7985916 45.6659165,91.9293265 C44.9062994,92.1116779 44.1634815,92.3545874 43.4077933,92.5466931 C42.7295977,92.7191548 42.0676593,93.0006751 41.4490733,93.3731001 C40.9480811,93.6746709 40.4701198,93.9874863 40.0407946,94.3868711 C39.2382315,95.1333469 38.6799326,96.0310145 38.1949266,97.0092907 C37.8273787,97.7503474 37.6343246,98.5304214 37.5649606,99.3140178 C37.4978997,100.072416 37.4626758,100.850457 37.6489561,101.631073 C37.8113925,102.311978 37.9959115,102.976355 38.2898957,103.604154 C38.6295354,104.329495 39.0717308,104.992517 39.6714855,105.538488 C40.000829,105.838298 40.2941357,106.187556 40.6554517,106.440355 C41.2568321,106.86101 41.8729795,107.274484 42.5845023,107.498834 C43.0846817,107.656528 43.5893319,107.906483 44.0956078,107.915695 C45.0450274,107.9329 46.0036595,108.06079 46.9536211,107.813817 C47.5849418,107.649619 48.2101661,107.472145 48.8345775,107.284374 C49.5398684,107.072353 50.2561329,106.894337 50.9730749,106.72445 C51.5893577,106.578541 52.2022536,106.409873 52.8117626,106.247843 C53.4424059,106.080123 54.0848357,105.959955 54.7135824,105.783023 C55.2255483,105.638876 55.7371078,105.431732 56.2914778,105.501367 C56.7878639,105.230956 57.3690583,105.281624 57.8810242,105.087216 C58.2447787,104.949165 58.6570339,105.073532 58.968359,104.935211 C59.491163,104.703004 60.0463459,104.695824 60.5775494,104.580533 C61.1160687,104.463617 61.6720645,104.378267 62.2219638,104.293458 C62.8162994,104.201741 63.416596,104.155272 64.005919,104.018035 C64.2394806,103.963708 64.5306197,104.06071 64.7243512,103.956528 C64.9531711,103.83338 65.161805,103.875784 65.3698969,103.88608 C65.6217478,103.898544 65.8370201,103.744372 66.0587952,103.752907 C66.6368736,103.77499 67.1840634,103.507288 67.7643095,103.602799 C67.8279835,103.613231 67.9234944,103.623662 67.9579055,103.588574 C68.1875382,103.354741 68.4710907,103.518262 68.7238899,103.469896 C68.9754699,103.421802 69.2265079,103.362735 69.4806619,103.337265 C69.9582168,103.289171 70.4322492,103.354199 70.9206422,103.222516 C71.3715081,103.100994 71.8688425,103.167106 72.3515455,103.083788 C73.0191739,102.968633 73.7079367,103.082975 74.3954802,102.948583 C75.058367,102.819067 75.7513295,102.945873 76.439144,102.815003 C77.0273832,102.703099 77.6538267,102.791836 78.2633357,102.791836 C78.8728447,102.791836 79.4854697,102.753496 80.0910499,102.802674 C80.6967655,102.851852 81.2673928,102.636309 81.8644379,102.654057 C83.0201884,102.688468 84.1744486,102.627368 85.3325022,102.771921 C86.1549803,102.874612 87.0008959,102.777205 87.8357024,102.796036 C88.6531679,102.814461 89.4686012,102.740897 90.2893182,102.909024 C90.8847376,103.030952 91.50942,102.921758 92.1300381,103.040165 C92.838174,103.17537 93.5792307,103.00467 94.308501,103.181738 C94.7669537,103.292964 95.2607657,103.166023 95.7430622,103.31884 C96.1738776,103.4554 96.6407298,103.27901 97.1140849,103.44104 C97.5270174,103.582342 98.0156813,103.464884 98.4749469,103.588032 C98.8438495,103.68693 99.2481115,103.575704 99.6396388,103.723644 C99.8767227,103.813194 100.223543,103.649945 100.433938,103.762797 C100.70191,103.906537 100.948478,103.857766 101.202903,103.869552 C101.464643,103.881745 101.709043,103.934987 101.962655,103.996765 C102.250543,104.066942 102.552927,104.023996 102.857884,104.126822 C103.15241,104.226127 103.490424,104.191038 103.815703,104.259318 C104.400827,104.38206 105.006813,104.411188 105.596814,104.544767 C105.844736,104.600855 106.098619,104.565495 106.359276,104.668728 C106.604217,104.76573 106.901724,104.684986 107.182567,104.808405 C107.448372,104.925321 107.770535,104.914076 108.06777,104.959326 C108.365141,105.004439 108.675112,105.011484 108.956497,105.104827 C109.276086,105.210906 109.611526,105.167689 109.914722,105.248568 C110.328061,105.358846 110.734491,105.452731 111.159345,105.51776 C111.662776,105.594846 112.144124,105.810931 112.670044,105.788984 C112.700527,105.787765 112.728299,105.864715 112.766639,105.877721 C112.945197,105.938144 113.127684,106.036771 113.307732,106.034332 C113.877547,106.026881 114.379352,106.391313 114.956482,106.314091 C115.098597,106.594257 115.409109,106.354057 115.614356,106.53844 C115.798333,106.703586 116.108439,106.518525 116.35731,106.705076 C116.526113,106.831476 116.80804,106.799097 117.03388,106.858707 C117.401427,106.955708 117.766943,107.057316 118.137065,107.145104 C118.526696,107.237499 118.9231,107.324611 119.303925,107.433398 C120.252667,107.704352 121.200596,107.977066 122.151235,108.243142 C122.995525,108.479413 123.834531,108.750637 124.667712,109.030938 C124.967386,109.131732 125.256222,109.242417 125.569986,109.311916 C125.890117,109.382771 126.207132,109.517976 126.518186,109.63286 C126.990051,109.807083 127.466251,109.959901 127.941503,110.121389 C128.434096,110.288702 128.921947,110.477692 129.413591,110.653134 C130.002779,110.863529 130.597114,111.069454 131.162323,111.334717 C131.900534,111.68113 132.722064,111.823652 133.414485,112.275195 C134.921526,112.723893 136.292413,113.501529 137.748109,114.076085 C138.425762,114.343651 139.010615,114.826218 139.741917,114.984726 C140.331782,115.480435 141.081238,115.680669 141.741822,116.049436 C143.040636,116.774371 144.363835,117.458121 145.66292,118.185224 C146.214174,118.493704 146.772337,118.805842 147.283355,119.163907 C147.847208,119.558956 148.448182,119.878274 149.077471,120.071735 C149.615584,120.237152 150.163586,120.510814 150.772689,120.411239 C150.911688,120.388479 151.064641,120.470984 151.212852,120.480468 C151.469851,120.496996 151.746088,120.551999 151.979243,120.479113 C152.130841,120.431696 152.275395,120.395659 152.419677,120.409071 C152.974318,120.460959 153.485065,120.281182 154.000553,120.131345 C155.252492,119.767455 156.356219,119.133018 157.257138,118.194436 C157.893878,117.531143 158.413024,116.776132 158.795881,115.923849 C159.185105,115.057477 159.474212,114.179589 159.465,113.220686 C159.463645,113.062991 159.465,112.905025 159.465,112.671735 Z M173.554561,80.2608667 C173.510125,79.799569 173.659149,79.259695 173.419084,78.7532836 C173.425994,77.8317721 173.016719,77.0347636 172.657435,76.2239364 C172.34462,75.5179681 171.884406,74.9108977 171.428798,74.2893313 C170.793955,73.4233652 169.973645,72.8138562 169.093183,72.2459384 C168.011673,71.5483697 166.87787,70.9379124 165.759647,70.3084883 C164.814427,69.7764719 163.838996,69.2840146 162.865461,68.7983312 C162.15719,68.4448729 161.432119,68.1139037 160.719242,67.7718254 C159.362986,67.120996 157.989389,66.5102677 156.62514,65.8782696 C156.492238,65.8167633 156.373018,65.7181363 156.23551,65.6751903 C155.455029,65.430926 154.723998,65.073268 153.981586,64.7375571 C153.393212,64.4714811 152.773406,64.275853 152.16891,64.0451364 C151.584058,63.8220065 151.002051,63.59129 150.416927,63.3689729 C149.578057,63.0501966 148.741624,62.7239691 147.895844,62.4241595 C147.323727,62.2213511 146.735081,62.0659595 146.158222,61.8760214 C145.582718,61.6864897 145.014393,61.4755527 144.439837,61.282905 C143.863385,61.08958 143.291132,60.8901585 142.697609,60.7411343 C141.887595,60.537784 141.104134,60.2302522 140.304145,59.9843623 C139.741917,59.8114942 139.160994,59.6955263 138.606488,59.5020658 C137.931273,59.266472 137.232214,59.1158221 136.547786,58.9208714 C135.922291,58.7427197 135.293274,58.5571168 134.656805,58.4103957 C134.448035,58.3623015 134.218132,58.3808618 134.022097,58.3058078 C133.049917,57.9335183 132.013386,57.8226984 131.019395,57.5426684 C130.857636,57.4971483 130.697367,57.443635 130.533169,57.4096304 C130.366669,57.3750839 130.203826,57.3828061 130.027436,57.325364 C129.545681,57.1684822 129.034392,57.1020987 128.534484,57.0010332 C128.242532,56.9419654 127.944213,56.9059286 127.659305,56.8228815 C127.172403,56.6809021 126.673713,56.5652051 126.181256,56.4803968 C125.611577,56.3823118 125.028622,56.2861234 124.476826,56.15295 C123.877884,56.0085319 123.255505,55.9948488 122.669704,55.7890599 C122.410944,55.6981552 122.123327,55.6580541 121.847903,55.6537189 C121.452583,55.6474869 121.089099,55.4136544 120.684973,55.5103847 C120.112042,55.2611078 119.481263,55.2116589 118.884896,55.1361984 C118.155219,55.0439389 117.435432,54.8786575 116.700878,54.8064485 C116.361916,54.7731213 115.997755,54.7706827 115.677895,54.673546 C115.464384,54.6087882 115.263066,54.5835896 115.049825,54.5579845 C114.818025,54.5300764 114.591508,54.4604414 114.359979,54.4296882 C114.141997,54.4006962 113.88405,54.4646412 113.709285,54.3684528 C113.483039,54.2439499 113.273863,54.30085 113.061707,54.2988179 C112.8379,54.2966503 112.642949,54.203036 112.438244,54.1697087 C111.899318,54.0821909 111.349148,54.064037 110.803177,54.0209555 C110.713492,54.0139107 110.591563,54.0576696 110.537779,54.0133688 C110.323726,53.8372493 110.075668,53.8629898 109.84441,53.8927947 C109.566818,53.9285605 109.342876,53.76355 109.086554,53.7516281 C108.695027,53.7333388 108.304719,53.6726453 107.92132,53.6422985 C107.219687,53.5866177 106.525099,53.3850285 105.81195,53.4764752 C105.723078,53.4878552 105.60562,53.5144086 105.545604,53.471869 C105.263948,53.2717701 104.947204,53.3260962 104.649833,53.3522432 C104.331056,53.3802869 104.055903,53.2323465 103.7565,53.2105347 C103.18777,53.1692144 102.622155,53.2308562 102.046651,53.0929411 C101.568012,52.9781925 101.05144,53.0314347 100.546654,52.9589548 C99.7188925,52.8401419 98.872706,52.9718251 98.0286871,52.8199559 C97.2961654,52.6881372 96.5370903,52.8267297 95.7808602,52.6897629 C95.1250182,52.5710854 94.4300235,52.6827181 93.7534536,52.6600935 C93.0714646,52.6373335 92.3911014,52.5401968 91.7095189,52.535726 C89.2712119,52.5198753 86.832363,52.5087662 84.3941916,52.5353196 C81.9743094,52.5616021 79.5515823,52.4114941 77.1342742,52.6596871 C76.2763012,52.7477468 75.4153477,52.6335401 74.5447754,52.7722681 C73.6789447,52.9101832 72.7778902,52.7692876 71.8941767,52.9253566 C71.3132532,53.0279124 70.7098407,52.850709 70.1179436,53.055956 C69.855932,53.1468608 69.5297044,53.1094692 69.2443908,53.0612396 C68.9177568,53.0059652 68.6581838,53.2082316 68.3505165,53.212025 C67.8478985,53.2181214 67.3516479,53.1950904 66.8433399,53.3208127 C66.3651077,53.4392192 65.848942,53.3347667 65.3418533,53.4571021 C64.9065671,53.5620964 64.4370054,53.5045189 63.9767916,53.5943398 C63.3554961,53.7155913 62.7083246,53.7039403 62.0722622,53.7481057 C62.0047949,53.7528474 61.9049487,53.7197911 61.874331,53.7535248 C61.6926569,53.9540301 61.4588244,53.8543193 61.2481584,53.8864273 C61.0170354,53.9217866 60.7892993,53.9792287 60.5587182,54.0185169 C60.2179947,54.0765009 59.8803871,53.9645972 59.519884,54.1304205 C59.2290158,54.2642714 58.843856,54.2133322 58.4997456,54.2641359 C57.9041907,54.3520602 57.3049779,54.4078765 56.7186354,54.5590683 C56.449037,54.6285678 56.1761873,54.5005425 55.8803065,54.6715139 C55.6478287,54.8057711 55.2762165,54.6327676 55.0026894,54.83246 C54.294418,54.7469743 53.6449434,55.0851238 52.9481875,55.1198058 C52.6329336,55.1355211 52.277985,55.1627518 51.9963292,55.2638173 C51.4698674,55.4526717 50.911433,55.4373628 50.388629,55.6305524 C50.0526472,55.7546489 49.6627457,55.728231 49.2992621,55.7841828 C49.1342516,55.8095169 48.9768279,55.8810485 48.8124948,55.9135629 C48.6461296,55.9463482 48.482203,55.9692437 48.3151604,56.0153058 C47.6198947,56.207276 46.9011916,56.3133542 46.1930557,56.4603462 C45.8993426,56.5213107 45.5842241,56.5404129 45.3142193,56.6307757 C44.7139227,56.831552 44.0945239,56.9563259 43.4874535,57.1151044 C42.8965048,57.2696832 42.2924149,57.3994697 41.6999759,57.5541839 C41.0929055,57.7126915 40.4812289,57.8630704 39.879442,58.0530086 C39.3644957,58.2155804 38.8219121,58.342251 38.3001919,58.5025198 C37.7828069,58.6614338 37.2617641,58.8150642 36.7502047,59.0064925 C35.7833085,59.3682149 34.8894342,59.8450924 34.1248046,60.5051341 C33.102634,61.3874929 32.2766335,62.4287657 31.6867686,63.6846333 C31.1302309,64.8696467 30.7900493,66.0740332 30.7710826,67.3671569 C30.7617347,68.0026774 30.6771973,68.6445653 30.8866441,69.2788665 C30.9996315,69.6210803 30.9400218,70.0220909 31.0618153,70.359292 C31.5997926,71.8488567 32.2779882,73.2651285 33.4485056,74.3810489 C33.7171556,74.637235 34.0221134,74.8549459 34.298621,75.1035453 C34.7787499,75.5353091 35.3156435,75.8783357 35.8965669,76.1537596 C36.1224063,76.260786 36.3594903,76.3443751 36.5892585,76.4435439 C37.3537527,76.7734293 38.1438519,76.997372 38.9790649,77.0545431 C39.1908147,77.0690391 39.3929457,77.0514272 39.6205463,77.1352872 C39.9131757,77.2431265 40.2937293,77.2271403 40.5997708,77.1381322 C40.7710132,77.0884123 40.9335851,77.0691746 41.1025243,77.0521046 C41.4024694,77.0218933 41.7235488,77.1342034 41.9946374,76.9154087 C42.6755426,76.9445362 43.2560596,76.5723821 43.8969991,76.4329767 C44.5915874,76.2819204 45.2546096,75.9780465 45.9513655,75.8466342 C46.7865785,75.689075 47.5745101,75.3297912 48.4334314,75.2896901 C48.5769011,75.010202 48.8834845,75.2420024 49.0940151,75.0713019 C49.2575353,74.9385349 49.528082,74.9230906 49.756089,74.888544 C49.9675679,74.8564361 50.172273,74.8901698 50.3851066,74.7621444 C50.57369,74.6487506 50.8358371,74.6575565 51.0654699,74.6123074 C51.2951026,74.5671937 51.532593,74.5452465 51.7526069,74.4714117 C52.0898081,74.3581534 52.479845,74.4383555 52.7699003,74.3129042 C53.2937882,74.0862519 53.8491065,74.0954643 54.3800391,73.9544332 C55.0762531,73.7695077 55.802001,73.6608555 56.5136593,73.5574869 C57.2392718,73.4520862 57.9544525,73.2238082 58.7002509,73.2563226 C58.7646022,73.2591676 58.8341017,73.2556452 58.8939823,73.2346463 C59.3433581,73.0765452 59.8022171,72.9769699 60.2813977,72.9864533 C60.3942497,72.9886209 60.5518089,73.0348184 60.6123669,72.9784602 C60.8701788,72.7385312 61.2210631,72.9752087 61.4321355,72.8329583 C61.7200232,72.6389559 61.9943632,72.7621041 62.2693806,72.7187516 C62.379523,72.7014106 62.5261087,72.7610203 62.602111,72.708049 C62.9269838,72.4820741 63.321356,72.6946368 63.6214366,72.5499478 C63.9759787,72.3791119 64.3190053,72.4920993 64.6629803,72.4467147 C64.7517174,72.4350637 64.8781171,72.4831579 64.927566,72.4381797 C65.1181815,72.2649052 65.3411759,72.3307468 65.554416,72.3054127 C65.7862164,72.2779109 66.0124622,72.1985217 66.2442626,72.1782002 C66.7227658,72.1364734 67.2167133,72.2616537 67.6780109,72.0383884 C68.4559173,72.1027397 69.2121474,71.8002206 69.9928988,71.9008797 C70.1039895,71.9152402 70.248543,71.9474836 70.3260356,71.8950542 C70.6332964,71.6869622 70.9745618,71.7453526 71.2898158,71.7805765 C71.6574991,71.8217614 71.9696371,71.6422549 72.3187602,71.6268106 C73.0907056,71.5926705 73.8575028,71.6575638 74.6382542,71.5238484 C75.4805119,71.3795659 76.3554195,71.4760252 77.2216565,71.3844431 C78.6381994,71.234606 80.0705929,71.4380918 81.5012253,71.2486956 C82.4331685,71.1254119 83.394781,71.2253936 84.3429814,71.2253936 C85.2911818,71.2253936 86.240195,71.2043947 87.187718,71.2313546 C88.1176291,71.257908 89.0433404,71.2270193 89.9800252,71.3307944 C91.4388367,71.4924179 92.922305,71.2652237 94.392632,71.485644 C95.1546876,71.5998508 95.9296134,71.4653226 96.7105003,71.6045925 C97.5066959,71.7465719 98.3391994,71.6728726 99.1581551,71.7365466 C100.105001,71.8101104 101.053066,72.0065514 102.012375,71.9033183 C102.057082,71.8985766 102.115337,71.8843515 102.145819,71.9054859 C102.423411,72.0979981 102.739342,72.0545101 103.039423,72.0308017 C103.355083,72.0057385 103.634978,72.1397248 103.932755,72.1666847 C104.411123,72.2099017 104.885833,72.185245 105.370568,72.2882071 C105.988341,72.4193484 106.638222,72.3998398 107.27442,72.4438697 C107.341887,72.4484759 107.436585,72.4154196 107.473164,72.4491533 C107.702526,72.6607676 107.979304,72.5481866 108.234,72.5819203 C108.509966,72.6183635 108.782545,72.6825794 109.058917,72.7127906 C109.558419,72.7673877 110.078784,72.739344 110.55363,72.8746851 C110.861432,72.9623384 111.152165,72.9578677 111.452246,72.9890273 C111.773461,73.0223546 112.095624,73.0609654 112.411555,73.1258586 C112.79685,73.204977 113.214389,73.17883 113.567577,73.2839598 C114.252275,73.487852 114.957972,73.5180633 115.647277,73.6356569 C116.324118,73.7510829 116.998385,73.9533494 117.69785,73.9346537 C117.985467,74.1554804 118.348544,73.9846445 118.643341,74.1050832 C119.205569,74.3348514 119.809659,74.3330902 120.387195,74.4718182 C120.743092,74.5573039 121.123781,74.565297 121.471143,74.646312 C122.04868,74.7809757 122.618765,74.9396187 123.208765,75.0240206 C123.520361,75.0685924 123.82288,75.1749415 124.13109,75.2462021 C124.790996,75.3986133 125.446702,75.5794745 126.113924,75.6867719 C126.807564,75.7982691 127.473025,76.0128639 128.155285,76.1632429 C128.97817,76.344646 129.793738,76.5620859 130.60714,76.78359 C131.093636,76.9160861 131.590293,77.0010299 132.069609,77.1749818 C132.520881,77.3386375 132.993288,77.4728947 133.459057,77.5743667 C134.223822,77.7410028 134.97233,77.9705001 135.71596,78.1913269 C136.677573,78.4769114 137.638779,78.7749599 138.594837,79.0841173 C139.311102,79.3157822 140.044165,79.5114104 140.732928,79.8085105 C141.656607,80.2068115 142.633393,80.4510757 143.55355,80.8484285 C144.224701,81.1383483 144.931075,81.3379052 145.588814,81.6583073 C146.208755,81.9602845 146.870422,82.1586222 147.501066,82.4408198 C148.107323,82.7123148 148.721709,82.9821841 149.340024,83.231461 C149.980015,83.4895438 150.608491,83.7702512 151.230058,84.0646418 C152.457882,84.6461071 153.676358,85.247894 154.889279,85.8598415 C155.842899,86.3410543 156.79137,86.8339179 157.725074,87.3523867 C158.40747,87.7311791 159.059925,88.1637558 159.730534,88.5642245 C159.96396,88.7036298 160.203618,88.8392419 160.455469,88.9386816 C160.688759,89.0308057 160.950636,89.0505853 161.184333,89.1421674 C161.440383,89.2425555 161.696705,89.3226222 161.963052,89.3925281 C162.216664,89.4590471 162.46147,89.5063284 162.72294,89.5212308 C162.999447,89.5369461 163.274465,89.6506109 163.54745,89.641263 C164.251793,89.6170127 164.958032,89.7383997 165.66251,89.5257015 C166.284889,89.337931 166.922577,89.2394396 167.544415,88.9984268 C168.677812,88.5590763 169.627367,87.9965777 170.177131,87.5172617 C171.50304,86.3612403 172.52223,85.0612073 173.138242,83.1984047 C173.407975,82.3829714 173.604281,81.5374622 173.555509,80.660658 C173.549142,80.5490253 173.554561,80.4357669 173.554561,80.2608667 Z M80.064361,132.326131 C80.5836426,132.326131 81.1057692,132.292533 81.6215285,132.335343 C82.158693,132.38005 82.6583305,132.166133 83.1896696,132.184829 C83.8662394,132.208537 84.5467382,132.227639 85.220734,132.180223 C85.9145094,132.131451 86.5796993,132.316783 87.2648042,132.335479 C88.6686122,132.373548 90.0760781,132.197428 91.4782604,132.449956 C92.0352045,132.550209 92.6097605,132.475697 93.1855359,132.570124 C93.9409531,132.69395 94.7231947,132.612935 95.4986625,132.707768 C96.1931153,132.792712 96.8936646,132.969915 97.6070841,132.86885 C97.6513849,132.862618 97.7195296,132.848664 97.7390382,132.871017 C97.9373759,133.09916 98.1999295,132.966664 98.4311879,133.005004 C98.6619045,133.043344 98.8889632,133.111488 99.1207636,133.135468 C99.6653793,133.19169 100.225304,133.171775 100.75285,133.294788 C101.101566,133.376074 101.465456,133.321477 101.779491,133.426878 C102.479905,133.662065 103.220419,133.610584 103.921511,133.810276 C104.20845,133.891969 104.513408,133.931663 104.812269,133.944805 C105.117904,133.958217 105.379509,134.167528 105.70655,134.098841 C105.830917,134.072694 105.979806,134.196791 106.122734,134.219009 C106.486082,134.275503 106.893731,134.229576 107.204785,134.383884 C107.466526,134.513671 107.716344,134.436855 107.959118,134.529928 C108.612522,134.780289 109.309819,134.879457 109.989505,135.013037 C110.490769,135.111664 110.975368,135.272746 111.476225,135.372727 C112.211727,135.519449 112.930159,135.805711 113.661462,135.959747 C114.90324,136.221353 116.077009,136.696604 117.307136,136.985034 C117.855003,137.113466 118.3816,137.331989 118.919984,137.502825 C119.458503,137.673661 119.946896,137.99745 120.530258,138.030642 C121.330654,138.496546 122.230354,138.730649 123.08372,139.059315 C124.525597,139.614769 125.946746,140.216827 127.36925,140.815633 C128.311354,141.212173 129.195203,141.738229 130.152074,142.110789 C130.4424,142.223777 130.67542,142.563145 130.959108,142.597556 C131.499795,142.662992 131.817758,143.156668 132.341104,143.203001 C132.903467,143.660235 133.594669,143.888106 134.210545,144.251725 C135.242063,144.860557 136.337256,145.372116 137.322306,146.046518 C138.398125,146.782969 139.582461,146.986726 140.821801,147.09741 C141.137596,147.125589 141.42142,146.962069 141.714049,146.970604 C142.20881,146.984965 142.635154,146.778092 143.062176,146.61281 C144.263311,146.147855 145.238878,145.363717 145.938073,144.28004 C146.253462,143.791105 146.542298,143.260443 146.712863,142.708376 C146.949947,141.940766 147.08583,141.135629 146.997228,140.320331 C146.958211,139.960234 146.912691,139.592416 146.801465,139.250473 C146.627513,138.715882 146.439878,138.176821 146.178272,137.681654 C145.678499,136.735486 144.907231,136.018815 144.016744,135.448323 C143.058112,134.834208 142.074146,134.255181 141.083541,133.697018 C140.044165,133.111217 138.985551,132.554002 137.927751,131.999361 C136.373157,131.184199 134.801358,130.401009 133.191084,129.699918 C132.957522,129.598175 132.745095,129.445086 132.519662,129.360143 C131.776709,129.080113 131.076024,128.70281 130.324265,128.444186 C129.831943,128.27484 129.358994,128.049949 128.874801,127.856353 C128.390337,127.662621 127.8865,127.496798 127.421409,127.279629 C126.432972,126.818196 125.39346,126.499826 124.381044,126.115479 C122.856797,125.536859 121.284185,125.081793 119.719973,124.614535 C119.197305,124.45833 118.649573,124.34304 118.138555,124.172881 C117.080619,123.820777 115.992336,123.588706 114.927897,123.266949 C114.387074,123.103565 113.826201,122.951695 113.269528,122.863365 C112.676683,122.769344 112.119468,122.56342 111.540983,122.456122 C111.058686,122.366708 110.570022,122.308588 110.099648,122.163222 C109.627106,122.017178 109.121643,122.059718 108.652758,121.895927 C108.494386,121.840652 108.329782,121.766411 108.167481,121.765327 C107.4691,121.760992 106.811903,121.467821 106.112302,121.487871 C105.837014,121.297391 105.473395,121.454273 105.23333,121.327467 C104.961022,121.183591 104.68885,121.316358 104.470191,121.203777 C104.214411,121.071958 103.963779,121.105015 103.707187,121.0767 C103.519958,121.056108 103.339774,120.972383 103.152546,120.951113 C102.951905,120.928353 102.709266,121.014652 102.552656,120.929166 C102.339145,120.812656 102.135523,120.833384 101.92269,120.806831 C101.691025,120.777839 101.464372,120.709152 101.232978,120.677586 C100.868547,120.628002 100.508856,120.700346 100.12898,120.564734 C99.7790441,120.439825 99.363673,120.51095 98.9702491,120.4256 C98.5086805,120.325618 98.0189328,120.393085 97.5369072,120.286465 C97.1190975,120.19407 96.6758183,120.229836 96.2385,120.155459 C95.6377969,120.053446 95.016366,120.130938 94.3984574,120.016054 C93.7546729,119.896428 93.0867735,120.030415 92.4210417,119.884642 C91.9039277,119.771519 91.3389905,119.824761 90.8012841,119.872313 C90.2398692,119.921898 89.7163879,119.708793 89.1629661,119.721393 C88.3053996,119.740901 87.4471556,119.726541 86.5891826,119.726541 C85.3022909,119.726541 84.0147217,119.70229 82.7285074,119.73345 C81.4601759,119.764203 80.1900832,119.621546 78.920668,119.845083 C78.35126,119.945335 77.7486603,119.882068 77.1628597,119.856463 C76.5635115,119.830316 75.9955938,120.060084 75.3887943,120.011854 C74.9612303,119.97785 74.5256732,119.948316 74.0836132,120.111971 C73.7858357,120.222249 73.4128688,120.115358 73.0756677,120.137847 C72.7316927,120.160878 72.3915111,120.241081 72.0474006,120.264789 C71.2314254,120.321012 70.4142308,120.35881 69.5975782,120.403517 C69.5526,120.405956 69.4878422,120.384279 69.4650821,120.406904 C69.2189212,120.650897 68.9126087,120.495235 68.6377268,120.539535 C68.3627094,120.583836 68.0894532,120.641956 67.8129456,120.671625 C67.4689706,120.708475 67.1309566,120.662413 66.7781757,120.789625 C66.4451743,120.909793 66.0586597,120.805747 65.6831187,120.922663 C65.3239704,121.034567 64.9142893,120.955719 64.5224911,121.064236 C64.1978893,121.154193 63.8432117,121.09675 63.4938177,121.196461 C63.1502491,121.294682 62.7682053,121.219086 62.3986252,121.33397 C62.1432519,121.413359 61.8529257,121.398186 61.5757407,121.472427 C61.290969,121.5487 60.9795084,121.557506 60.6841695,121.596523 C60.0860405,121.675777 59.4915694,121.751915 58.901569,121.886172 C58.6536469,121.942666 58.3996284,121.900804 58.1385651,122.010269 C57.8957911,122.112012 57.5710538,121.96231 57.3221834,122.164848 C56.5250394,122.197497 55.7551261,122.381339 54.9827743,122.564639 C54.6270129,122.649041 54.2372469,122.609888 53.8936783,122.721385 C53.5486196,122.833289 53.1874391,122.892628 52.8454963,122.954134 C51.9013602,123.124022 50.9654882,123.328591 50.0254164,123.516091 C49.5013931,123.620679 48.9535259,123.679204 48.4541593,123.822268 C47.7847697,124.014238 47.0988519,124.131967 46.428243,124.309577 C45.7423252,124.491386 45.1166945,124.76803 44.5355001,125.139371 C44.0173023,125.470475 43.5129231,125.816076 43.1377885,126.353241 C42.8070903,126.826596 42.5208283,127.313769 42.23416,127.811104 C41.9378727,128.325102 41.8166212,128.898303 41.7671723,129.438448 C41.6913054,130.267023 41.6176062,131.127028 41.8741988,131.952486 C42.0104882,132.39116 42.0916386,132.878875 42.3441669,133.242765 C42.8546426,133.978132 43.236551,134.836918 44.0876146,135.295235 C44.3680511,135.446291 44.6021546,135.681885 44.8787977,135.842018 C45.1301067,135.987385 45.4433285,136.039137 45.6694388,136.210921 C45.9443208,136.41969 46.2934438,136.312122 46.5691386,136.511408 C46.688358,136.597706 46.9468472,136.473203 47.0916717,136.545548 C47.6101404,136.804037 48.1695231,136.710017 48.6650963,136.62846 C49.2636317,136.530104 49.8843853,136.445973 50.4617864,136.241674 C50.7676924,136.133428 51.0832173,136.126654 51.3898007,136.035208 C52.0162443,135.848386 52.6659898,135.688523 53.3054391,135.608321 C53.9275475,135.530287 54.5096902,135.214897 55.1536103,135.306073 C55.7967174,135.055848 56.4877833,135.034984 57.1479606,134.879457 C57.4512926,134.808061 57.7855132,134.862116 58.0339772,134.741678 C58.3580371,134.58466 58.7026895,134.584796 59.0221432,134.523289 C59.3753305,134.45528 59.748162,134.413689 60.1112391,134.355028 C60.2981968,134.324816 60.4785161,134.248543 60.6657447,134.227273 C60.8663854,134.204513 61.0868058,134.270761 61.2718668,134.212913 C61.7903355,134.050883 62.3180167,133.978403 62.8558586,133.951714 C62.9234614,133.948327 63.0224947,133.980299 63.0540608,133.946566 C63.2790873,133.705824 63.5910898,133.915542 63.8089361,133.802554 C64.0867985,133.658543 64.3596483,133.689838 64.6402202,133.680625 C64.7522593,133.676967 64.9171343,133.722352 64.9667187,133.665723 C65.1367418,133.471043 65.3448338,133.579153 65.5320624,133.543523 C65.7401544,133.503964 65.944453,133.433923 66.1538997,133.413737 C66.5649356,133.374042 66.9713652,133.377835 67.3890394,133.298717 C68.1738551,133.150099 68.9826501,133.091302 69.7802006,133.026816 C70.5036453,132.968425 71.2223484,132.774016 71.9574442,132.866682 C72.0018805,132.872372 72.0623031,132.886326 72.0906177,132.864515 C72.3656351,132.652087 72.6852242,132.763178 72.9847629,132.729851 C73.3058423,132.694085 73.6236703,132.624586 73.9451562,132.600064 C74.6257904,132.548041 75.3203786,132.704381 75.988549,132.461065 C76.947723,132.563621 77.8880657,132.282372 78.845072,132.322744 C79.2508243,132.340356 79.6579314,132.326131 80.064361,132.326131 Z M80.064361,132.326131" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'lastfm_username', '' ) !== '' ) : ?>
			<a class="contact-link LastFmLink" href="<?php echo esc_url( 'http://last.fm/user/' . get_theme_mod( 'lastfm_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C155.228474,-1.51545443e-14 200,44.771526 200,100 C200,155.228474 155.228474,200 100,200 C44.771526,200 1.5158245e-14,155.228474 0,100 C0,44.771526 44.771526,3.03201907e-14 100,0 Z M142.051333,141.519333 C157.877556,141.542667 170,131.184222 170,116.958667 C170,103.411333 163.267556,97.9871111 148.785333,93.2364444 C138.017778,89.6804444 130.328667,88.3722222 130.328667,79.7108889 C130.328667,73.6084444 134.998444,69.0211111 141.552,69.0211111 C146.266889,69.0211111 149.969111,70.8908889 153.330667,75.6275556 L162.250222,71.0402222 C157.704889,62.9202222 151.145111,58.8477778 142.051333,58.8477778 C128.093333,58.8477778 119.505111,67.324 119.505111,80.0344444 C119.505111,93.0653333 127.936222,98.5035556 144.250889,103.916889 C153.330667,106.956444 158.708222,108.826222 158.708222,116.604 C158.708222,124.565333 151.655333,130.862222 141.379333,130.507556 C130.918222,130.151333 127.696667,124.394222 123.913556,115.709556 C117.806444,101.681556 110.811111,85.1973333 110.263556,83.9124444 C103.132889,67.3473333 89.0971111,58 71.7091111,58 C48.6744444,58 30,76.8128889 30,100.004667 C30,123.210444 48.6744444,142 71.7091111,142 C84.7104444,142 96.332,136.025111 103.976,126.640444 L98.5875556,114.136889 C93.5288889,123.876222 83.3773333,130.518444 71.7106667,130.518444 C54.9853333,130.518444 41.4162222,116.856 41.4162222,100.004667 C41.4162222,83.1548889 54.9853333,69.4924444 71.7106667,69.4924444 C84.0711111,69.4924444 95.0315556,76.8004444 99.4415556,87.6177778 L112.760222,118.175111 L114.298667,121.628444 C119.699556,134.279778 127.469556,141.460222 142.051333,141.519333 Z M142.051333,141.519333" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'vine_username', '' ) !== '' ) : ?>
			<a class="contact-link VineLink" href="<?php echo esc_url( 'https://vine.co/' . get_theme_mod( 'vine_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M165,100.073242 C161.180006,100.957986 157.485272,101.348532 154.158953,101.348532 C135.449501,101.348532 121.044968,88.2189691 121.044968,65.3896142 C121.044968,54.1998246 125.350348,48.3809674 131.438852,48.3809674 C137.231244,48.3809674 141.092684,53.6029001 141.092684,64.1966906 C141.092684,70.2200754 139.48732,76.82095 138.301487,80.7264096 C138.301487,80.7264096 144.067168,90.8324804 159.832531,87.7312494 C163.180495,80.2632147 165,70.5921121 165,62.1083803 C165,39.2790254 153.417059,26 132.181667,26 C110.354971,26 97.5838939,42.8605725 97.5838939,65.0930029 C97.5838939,87.116741 107.829952,106.021664 124.726346,114.635887 C117.621479,128.916264 108.581056,141.495639 99.1528777,150.973319 C82.046948,130.195256 66.5827639,102.475285 60.2368301,48.3809674 L35,48.3809674 C46.6598475,138.473072 81.4072889,167.159691 90.5946169,172.668518 C95.7920196,175.801677 100.266409,175.652677 105.018492,172.965592 C112.478418,168.703366 134.877538,146.201162 147.292634,119.842549 C152.503852,119.827742 158.765051,119.227115 165,117.811155 L165,100.073242 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'vimeo_username', '' ) !== '' ) : ?>
			<a class="contact-link VimeoLink" href="<?php echo esc_url( 'http://vimeo.com/' . get_theme_mod( 'vimeo_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,2.2737368e-14 0,44.771526 0,100 C1.5158245e-14,155.228474 44.771524,200 100,200 C155.228476,200 200,155.228474 200,100 C200,44.771526 155.228476,-1.13686838e-14 100,0 L100,0 L100,0 Z M147.65,41.41875 C148.310824,41.42446 148.937952,41.44591 149.51875,41.4875 C158.46887,42.128422 164.93428,48.05062 166.96875,57.46875 C167.145904,58.28886 167.369452,61.21603 167.46875,63.975 C167.955892,77.510118 159.874926,95.14026 142.65625,118.10625 C140.196742,121.386704 138.042022,124.182066 137.86875,124.31875 C137.695478,124.455438 136.230688,126.249714 134.6125,128.3 C130.020256,134.118494 118.780412,145.356366 113.5375,149.36875 C102.776904,157.603812 93.947218,160.432786 87.775,157.63125 C83.024002,155.474798 77.29722,148.318802 74.16875,140.63125 C72.928662,137.584002 71.323158,132.647872 69.75625,127.05625 C59.52,90.527482 58.551242,87.358364 56.10625,82.31875 C54.804696,79.635986 53.127294,77.064434 51.9125,75.8875 C49.155684,73.216606 47.695578,73.313064 42.08125,76.53125 C39.674776,77.910662 37.452826,79.104252 37.14375,79.1875 C36.627922,79.326438 31.4875,73.41427 31.4875,72.68125 C31.4875,71.692834 56.374272,50.396436 60.9875,47.4375 C66.701746,43.772374 68.046608,43.254156 72.6125,42.9375 C75.236414,42.75552 76.126312,42.925776 78.4625,44.06875 C79.986132,44.814198 82.169332,46.475022 83.34375,47.78125 C87.11701,51.978028 88.066156,54.543632 90.9125,68.1875 C91.051692,68.854704 92.051956,74.352074 93.1375,80.40625 C97.307546,103.663022 99.999138,112.502298 104,116.08125 C107.160736,118.90868 111.342094,115.713462 118.43125,105.05625 C128.58266,89.795516 131.395918,77.90723 126.2,72.2375 C124.635036,70.529826 124.449834,70.466312 120.4125,70.2625 C117.753032,70.12824 115.091694,70.31889 113.0875,70.7875 L109.94375,71.51875 L110.25625,70.275 C110.795262,68.127416 114.577712,60.608828 116.6125,57.64375 C120.993294,51.260092 128.207568,45.157066 133.56875,43.29375 C136.772976,42.180092 143.024236,41.378774 147.65,41.41875 L147.65,41.41875 L147.65,41.41875 Z M147.65,41.41875"fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'youtube_username', '' ) !== '' ) : ?>
			<a class="contact-link YouTubeLink" href="<?php echo esc_url( 'http://youtube.com/user/' . get_theme_mod( 'youtube_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,1.5158245e-14 0,44.771524 0,100 C-1.5158245e-14,155.228476 44.771524,200 100,200 C155.228476,200 200,155.228476 200,100 C200,44.771524 155.228476,-2.2737368e-14 100,0 L100,0 L100,0 Z M64.087495,29.3759643 C64.6671855,29.3754756 65.3010639,29.3978516 65.916503,29.4484003 L68.9044863,29.6958898 L71.5544351,39.1729278 C73.0122561,44.3845135 74.406065,48.4466351 74.6510724,48.2032774 C74.8960701,47.9599273 76.1385883,43.6944673 77.4157115,38.7262394 L79.7396985,29.6958898 L83.4158234,29.460473 C86.1576327,29.2845405 87.0919484,29.5003378 87.0919484,30.3055591 C87.0919484,30.89942 85.1777248,37.6692944 82.8363358,45.3541296 L78.5746868,59.3282334 L78.5746868,70.2479542 L78.5746868,81.1676751 L74.789908,81.1676751 L71.0051291,81.1676751 L70.6791673,69.3666501 L70.3532055,57.5595887 L65.6871225,43.7484659 C62.356745,33.8893485 61.2990274,29.8307579 61.9808159,29.5691269 C62.3091227,29.4431463 63.1213461,29.3767795 64.087495,29.3759643 L64.087495,29.3759643 L64.087495,29.3759643 Z M114.182997,42.4687639 L117.665959,42.4687639 L121.148922,42.4687639 L121.148922,58.7185641 L121.148922,74.9744006 L122.965857,74.9744006 C126.957165,74.9744006 127.342196,73.4186558 127.342196,57.3060629 L127.342196,42.4687639 L130.825159,42.4687639 L134.308121,42.4687639 L134.308121,61.8152013 L134.308121,81.1676751 L130.825159,81.1676751 C127.85811,81.1676751 127.342196,80.9410606 127.342196,79.6223746 C127.342196,77.6629529 127.219517,77.6751048 123.780762,80.0086997 C120.336256,82.3462043 117.800694,82.4674215 115.728298,80.3950248 C114.268106,78.9348337 114.182997,77.8135193 114.182997,60.656226 L114.182997,42.4687639 L114.182997,42.4687639 Z M97.9754512,42.4748003 C99.9359275,42.480033 101.929332,42.9111255 103.408148,43.7846839 C107.347619,46.1117866 107.992935,48.7192126 107.989723,62.3222531 C107.987405,73.1235923 107.804963,74.887149 106.474604,77.0690071 C103.565972,81.8393264 97.4558227,83.2963709 92.6574446,80.3708795 C88.5936907,77.8932703 87.8645986,75.0767342 87.8645986,61.8031287 C87.8645986,49.1445991 88.3641266,47.1062203 92.2107561,44.080464 C93.5713932,43.0101851 95.7535776,42.4688702 97.9754512,42.4748003 L97.9754512,42.4748003 L97.9754512,42.4748003 Z M97.9271606,48.6680748 C97.4965761,48.6680748 97.0683753,48.8221567 96.5750227,49.1328722 C95.4099704,49.8666214 95.1849109,51.4917192 94.9935042,60.7407346 C94.7182959,74.0388931 94.9135407,74.9744006 97.9271606,74.9744006 C99.6609664,74.9744006 100.323748,74.5530222 100.649545,73.2359376 C100.886479,72.2780966 100.983218,66.6549781 100.860817,60.7407346 C100.66941,51.4917192 100.444351,49.8666214 99.2792985,49.1328722 C98.7859459,48.8221567 98.357745,48.6680748 97.9271606,48.6680748 L97.9271606,48.6680748 L97.9271606,48.6680748 Z M97.7098527,90.0169347 C118.932022,89.9681148 142.48865,90.8679066 146.688634,92.1598319 C150.495694,93.3309069 153.468667,95.5853631 154.93426,98.419506 C159.079705,106.435905 160.100745,140.397381 156.708941,157.454813 C155.845267,161.798272 152.528639,166.425616 148.958294,168.271916 C145.391881,170.11618 105.875468,171.941137 85.932973,171.181427 C69.5362245,170.556791 54.2104406,169.269832 51.9665445,168.332279 C48.2754012,166.790019 44.7075768,162.057706 43.7692085,157.454813 C42.4622339,151.043886 41.3327796,131.609939 41.8315466,124.128235 C43.2747703,102.479219 44.4587969,97.6767419 49.1717238,94.320838 C52.8606554,91.6940938 55.1106438,91.3914042 78.0736715,90.4032599 C83.8257704,90.1557375 90.6357956,90.0332087 97.7098527,90.0169347 L97.7098527,90.0169347 L97.7098527,90.0169347 Z M49.9383377,102.838099 L49.9383377,106.707387 L49.9383377,110.582711 L54.1939503,110.582711 L58.4555992,110.582711 L58.4555992,133.025785 L58.4555992,155.474896 L62.7112118,155.474896 L66.9668244,155.474896 L66.9668244,133.025785 L66.9668244,110.582711 L71.222437,110.582711 L75.4840859,110.582711 L75.4840859,106.707387 L75.4840859,102.838099 L62.7112118,102.838099 L49.9383377,102.838099 L49.9383377,102.838099 Z M102.569098,102.838099 L102.569098,129.156498 L102.569098,155.474896 L106.052061,155.474896 C109.001346,155.474896 109.535023,155.238744 109.535023,153.947705 C109.535023,152.501671 109.682275,152.52095 112.353989,154.33403 C115.897251,156.738556 118.154558,156.753549 120.913505,154.382321 L123.080547,152.511058 L123.297855,136.774346 C123.497983,122.134848 123.406982,120.85377 121.95779,118.514448 C119.997113,115.349468 115.882499,114.849077 112.112536,117.319255 L110.31371,118.496339 L110.31371,110.667219 L110.31371,102.838099 L106.444422,102.838099 L102.569098,102.838099 L102.569098,102.838099 Z M139.378638,115.840354 C137.143326,115.836951 134.972336,116.342372 133.613943,117.337364 C129.596398,120.280116 128.893533,123.034464 128.893533,135.736098 C128.893533,148.906921 129.607105,151.388826 134.308121,154.557374 C138.061774,157.087398 143.469875,156.624751 146.742961,153.488944 C149.242241,151.094481 150.869378,146.850945 150.443231,143.830816 C150.207124,142.157501 149.731659,141.901609 146.495471,141.693955 L142.819346,141.458538 L142.819346,144.500849 C142.819346,147.925486 141.445039,149.526347 138.829332,149.148823 C136.814197,148.857987 136.046457,146.790209 135.931894,141.37403 L135.853421,137.728086 L143.012509,137.504742 L150.171596,137.281398 L150.135378,130.315473 C150.094588,122.250195 148.854465,119.078892 144.938098,117.053656 C143.375637,116.245677 141.350973,115.843358 139.378638,115.840354 L139.378638,115.840354 L139.378638,115.840354 Z M89.4159354,115.91279 L89.4159354,131.051906 C89.4159354,145.306022 89.3189832,146.275899 87.816308,147.778576 C86.9387164,148.656167 85.6316433,149.262839 84.9128333,149.124677 C83.7431277,148.89985 83.5846765,147.145862 83.3977145,132.434225 L83.1924792,115.997299 L79.7698802,115.997299 C77.8877892,115.997299 76.1162046,116.374 75.8341931,116.830312 C75.5521815,117.286616 75.5756875,125.690103 75.88852,135.506717 C76.3966361,151.451481 76.6126015,153.506775 77.9046542,154.798827 C79.5485893,156.44277 81.7760665,156.648757 84.2428006,155.378315 C85.1726524,154.899409 86.7135931,153.793957 87.671436,152.921529 L89.4159354,151.333974 L89.4159354,153.404435 C89.4159354,155.341705 89.6391038,155.474896 92.8988977,155.474896 L96.3818601,155.474896 L96.544841,139.99171 C96.6348973,131.477566 96.7216331,122.681036 96.7380036,120.446074 L96.7681852,116.383624 L93.0920603,116.148207 L89.4159354,115.91279 L89.4159354,115.91279 Z M139.891726,122.263009 C140.409336,122.244369 140.800504,122.59833 141.606044,123.403876 C142.345574,124.143406 142.819346,125.967713 142.819346,128.05185 L142.819346,131.480485 L139.771,131.480485 C138.093296,131.480485 136.494391,131.118987 136.221638,130.677653 C135.318116,129.21572 136.716688,123.742594 138.195517,122.951151 C139.009109,122.515731 139.489141,122.277508 139.891726,122.263009 L139.891726,122.263009 L139.891726,122.263009 Z M113.35602,122.456172 C113.848071,122.467043 114.279594,122.727826 114.816812,123.26504 C115.766362,124.214598 116.117462,126.65264 116.356076,133.985562 C116.730203,145.482808 116.058325,148.796193 113.295657,149.124677 C112.219554,149.25262 111.009284,148.905679 110.603453,148.352027 C110.17989,147.774164 109.987528,142.312945 110.156765,135.530862 C110.42897,124.622239 110.575043,123.6531 112.021991,122.878715 C112.554867,122.593528 112.973315,122.447715 113.35602,122.456172 L113.35602,122.456172 L113.35602,122.456172 Z M113.35602,122.456172" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'youtube_url', '' ) !== '' ) : ?>
			<a class="contact-link YouTubeLink" href="<?php echo esc_url( get_theme_mod( 'youtube_url' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,1.5158245e-14 0,44.771524 0,100 C-1.5158245e-14,155.228476 44.771524,200 100,200 C155.228476,200 200,155.228476 200,100 C200,44.771524 155.228476,-2.2737368e-14 100,0 L100,0 L100,0 Z M64.087495,29.3759643 C64.6671855,29.3754756 65.3010639,29.3978516 65.916503,29.4484003 L68.9044863,29.6958898 L71.5544351,39.1729278 C73.0122561,44.3845135 74.406065,48.4466351 74.6510724,48.2032774 C74.8960701,47.9599273 76.1385883,43.6944673 77.4157115,38.7262394 L79.7396985,29.6958898 L83.4158234,29.460473 C86.1576327,29.2845405 87.0919484,29.5003378 87.0919484,30.3055591 C87.0919484,30.89942 85.1777248,37.6692944 82.8363358,45.3541296 L78.5746868,59.3282334 L78.5746868,70.2479542 L78.5746868,81.1676751 L74.789908,81.1676751 L71.0051291,81.1676751 L70.6791673,69.3666501 L70.3532055,57.5595887 L65.6871225,43.7484659 C62.356745,33.8893485 61.2990274,29.8307579 61.9808159,29.5691269 C62.3091227,29.4431463 63.1213461,29.3767795 64.087495,29.3759643 L64.087495,29.3759643 L64.087495,29.3759643 Z M114.182997,42.4687639 L117.665959,42.4687639 L121.148922,42.4687639 L121.148922,58.7185641 L121.148922,74.9744006 L122.965857,74.9744006 C126.957165,74.9744006 127.342196,73.4186558 127.342196,57.3060629 L127.342196,42.4687639 L130.825159,42.4687639 L134.308121,42.4687639 L134.308121,61.8152013 L134.308121,81.1676751 L130.825159,81.1676751 C127.85811,81.1676751 127.342196,80.9410606 127.342196,79.6223746 C127.342196,77.6629529 127.219517,77.6751048 123.780762,80.0086997 C120.336256,82.3462043 117.800694,82.4674215 115.728298,80.3950248 C114.268106,78.9348337 114.182997,77.8135193 114.182997,60.656226 L114.182997,42.4687639 L114.182997,42.4687639 Z M97.9754512,42.4748003 C99.9359275,42.480033 101.929332,42.9111255 103.408148,43.7846839 C107.347619,46.1117866 107.992935,48.7192126 107.989723,62.3222531 C107.987405,73.1235923 107.804963,74.887149 106.474604,77.0690071 C103.565972,81.8393264 97.4558227,83.2963709 92.6574446,80.3708795 C88.5936907,77.8932703 87.8645986,75.0767342 87.8645986,61.8031287 C87.8645986,49.1445991 88.3641266,47.1062203 92.2107561,44.080464 C93.5713932,43.0101851 95.7535776,42.4688702 97.9754512,42.4748003 L97.9754512,42.4748003 L97.9754512,42.4748003 Z M97.9271606,48.6680748 C97.4965761,48.6680748 97.0683753,48.8221567 96.5750227,49.1328722 C95.4099704,49.8666214 95.1849109,51.4917192 94.9935042,60.7407346 C94.7182959,74.0388931 94.9135407,74.9744006 97.9271606,74.9744006 C99.6609664,74.9744006 100.323748,74.5530222 100.649545,73.2359376 C100.886479,72.2780966 100.983218,66.6549781 100.860817,60.7407346 C100.66941,51.4917192 100.444351,49.8666214 99.2792985,49.1328722 C98.7859459,48.8221567 98.357745,48.6680748 97.9271606,48.6680748 L97.9271606,48.6680748 L97.9271606,48.6680748 Z M97.7098527,90.0169347 C118.932022,89.9681148 142.48865,90.8679066 146.688634,92.1598319 C150.495694,93.3309069 153.468667,95.5853631 154.93426,98.419506 C159.079705,106.435905 160.100745,140.397381 156.708941,157.454813 C155.845267,161.798272 152.528639,166.425616 148.958294,168.271916 C145.391881,170.11618 105.875468,171.941137 85.932973,171.181427 C69.5362245,170.556791 54.2104406,169.269832 51.9665445,168.332279 C48.2754012,166.790019 44.7075768,162.057706 43.7692085,157.454813 C42.4622339,151.043886 41.3327796,131.609939 41.8315466,124.128235 C43.2747703,102.479219 44.4587969,97.6767419 49.1717238,94.320838 C52.8606554,91.6940938 55.1106438,91.3914042 78.0736715,90.4032599 C83.8257704,90.1557375 90.6357956,90.0332087 97.7098527,90.0169347 L97.7098527,90.0169347 L97.7098527,90.0169347 Z M49.9383377,102.838099 L49.9383377,106.707387 L49.9383377,110.582711 L54.1939503,110.582711 L58.4555992,110.582711 L58.4555992,133.025785 L58.4555992,155.474896 L62.7112118,155.474896 L66.9668244,155.474896 L66.9668244,133.025785 L66.9668244,110.582711 L71.222437,110.582711 L75.4840859,110.582711 L75.4840859,106.707387 L75.4840859,102.838099 L62.7112118,102.838099 L49.9383377,102.838099 L49.9383377,102.838099 Z M102.569098,102.838099 L102.569098,129.156498 L102.569098,155.474896 L106.052061,155.474896 C109.001346,155.474896 109.535023,155.238744 109.535023,153.947705 C109.535023,152.501671 109.682275,152.52095 112.353989,154.33403 C115.897251,156.738556 118.154558,156.753549 120.913505,154.382321 L123.080547,152.511058 L123.297855,136.774346 C123.497983,122.134848 123.406982,120.85377 121.95779,118.514448 C119.997113,115.349468 115.882499,114.849077 112.112536,117.319255 L110.31371,118.496339 L110.31371,110.667219 L110.31371,102.838099 L106.444422,102.838099 L102.569098,102.838099 L102.569098,102.838099 Z M139.378638,115.840354 C137.143326,115.836951 134.972336,116.342372 133.613943,117.337364 C129.596398,120.280116 128.893533,123.034464 128.893533,135.736098 C128.893533,148.906921 129.607105,151.388826 134.308121,154.557374 C138.061774,157.087398 143.469875,156.624751 146.742961,153.488944 C149.242241,151.094481 150.869378,146.850945 150.443231,143.830816 C150.207124,142.157501 149.731659,141.901609 146.495471,141.693955 L142.819346,141.458538 L142.819346,144.500849 C142.819346,147.925486 141.445039,149.526347 138.829332,149.148823 C136.814197,148.857987 136.046457,146.790209 135.931894,141.37403 L135.853421,137.728086 L143.012509,137.504742 L150.171596,137.281398 L150.135378,130.315473 C150.094588,122.250195 148.854465,119.078892 144.938098,117.053656 C143.375637,116.245677 141.350973,115.843358 139.378638,115.840354 L139.378638,115.840354 L139.378638,115.840354 Z M89.4159354,115.91279 L89.4159354,131.051906 C89.4159354,145.306022 89.3189832,146.275899 87.816308,147.778576 C86.9387164,148.656167 85.6316433,149.262839 84.9128333,149.124677 C83.7431277,148.89985 83.5846765,147.145862 83.3977145,132.434225 L83.1924792,115.997299 L79.7698802,115.997299 C77.8877892,115.997299 76.1162046,116.374 75.8341931,116.830312 C75.5521815,117.286616 75.5756875,125.690103 75.88852,135.506717 C76.3966361,151.451481 76.6126015,153.506775 77.9046542,154.798827 C79.5485893,156.44277 81.7760665,156.648757 84.2428006,155.378315 C85.1726524,154.899409 86.7135931,153.793957 87.671436,152.921529 L89.4159354,151.333974 L89.4159354,153.404435 C89.4159354,155.341705 89.6391038,155.474896 92.8988977,155.474896 L96.3818601,155.474896 L96.544841,139.99171 C96.6348973,131.477566 96.7216331,122.681036 96.7380036,120.446074 L96.7681852,116.383624 L93.0920603,116.148207 L89.4159354,115.91279 L89.4159354,115.91279 Z M139.891726,122.263009 C140.409336,122.244369 140.800504,122.59833 141.606044,123.403876 C142.345574,124.143406 142.819346,125.967713 142.819346,128.05185 L142.819346,131.480485 L139.771,131.480485 C138.093296,131.480485 136.494391,131.118987 136.221638,130.677653 C135.318116,129.21572 136.716688,123.742594 138.195517,122.951151 C139.009109,122.515731 139.489141,122.277508 139.891726,122.263009 L139.891726,122.263009 L139.891726,122.263009 Z M113.35602,122.456172 C113.848071,122.467043 114.279594,122.727826 114.816812,123.26504 C115.766362,124.214598 116.117462,126.65264 116.356076,133.985562 C116.730203,145.482808 116.058325,148.796193 113.295657,149.124677 C112.219554,149.25262 111.009284,148.905679 110.603453,148.352027 C110.17989,147.774164 109.987528,142.312945 110.156765,135.530862 C110.42897,124.622239 110.575043,123.6531 112.021991,122.878715 C112.554867,122.593528 112.973315,122.447715 113.35602,122.456172 L113.35602,122.456172 L113.35602,122.456172 Z M113.35602,122.456172" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'kickstarter_url', '' ) !== '' ) : ?>
			<a class="contact-link KickstarterLink" href="<?php echo esc_url( get_theme_mod( 'kickstarter_url' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,3.03201907e-14 0,44.771524 0,100 C0,155.228476 44.771524,200 100,200 C155.228476,200 200,155.228476 200,100 C200,44.771524 155.228476,-3.41060513e-14 100,0 Z M90.6470148,80.8951037 L112.461565,49.0106518 C116.58593,43.0035506 121.910844,40 128.437611,40 C133.762525,40 138.370499,41.9054925 142.265442,45.7177925 C146.157779,49.5300925 148.103947,54.0932801 148.103947,59.4073555 C148.103947,63.335379 147.075463,66.8018235 145.013281,69.8053741 L125.344338,98.6573445 L149.39444,129.416122 C151.798147,132.477535 153,136.059703 153,140.159996 C153,145.589795 151.112491,150.252926 147.332258,154.152019 C143.553329,158.052426 138.970122,160 133.59046,160 C127.691993,160 123.19873,158.066892 120.105457,154.195415 L90.6470148,117.112611 L90.6470148,137.561478 C90.6470148,143.396309 89.6459049,147.929251 87.6410779,151.164248 C83.9768591,157.054311 78.651945,160 71.6676389,160 C65.3116337,160 60.3855992,157.83413 56.8947497,153.502389 C53.6307142,149.516504 52,144.230044 52,137.646956 L52,61.8336036 C52,55.5950555 53.6580883,50.4558804 56.9807826,46.4108184 C60.4729356,42.1369395 65.2816525,40 71.4082368,40 C77.2493482,40 82.1154204,42.1369395 86.0090602,46.4108184 C88.1846493,48.7792048 89.5585684,51.1765222 90.1308175,53.6027704 C90.474949,55.1058607 90.6470148,57.9055802 90.6470148,62.0071889 L90.6470148,80.8951037 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'gittip_username', '' ) !== '' ) : ?>
			<a class="contact-link GittipLink" href="<?php echo esc_url( 'http://gittip.com/' . get_theme_mod( 'gittip_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,3.03201907e-14 0,44.771524 0,100 C0,155.228476 44.771524,200 100,200 C155.228476,200 200,155.228476 200,100 C200,44.771524 155.228476,-3.41060513e-14 100,0 Z M111.410273,60.5540541 C109.295408,63.0135135 105.667029,65.9121622 98.8156781,65.9121622 C91.9643268,65.9121622 88.3359484,63.0135135 86.2210835,60.5540541 C80.5386511,53.9527027 69.7008133,48.2567568 58.3021646,55.777027 C44.903516,64.6081081 48.8021646,80.5743243 52.70757,85.1689189 L98.8156781,147.594595 L144.923786,85.1689189 C148.822435,80.5743243 152.721084,64.6081081 139.329192,55.777027 C127.923786,48.2567568 117.085948,53.9527027 111.410273,60.5540541 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'goodreads_username', '' ) !== '' ) : ?>
			<a class="contact-link GoodreadsLink" href="<?php echo esc_url( 'http://goodreads.com/' . get_theme_mod( 'goodreads_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,3.03201907e-14 0,44.771524 0,100 C0,155.228476 44.771524,200 100,200 C155.228476,200 200,155.228476 200,100 C200,44.771524 155.228476,-3.41060513e-14 100,0 L100,0 L100,0 Z M99.62248,128.323556 C114.81688,128.197556 125.62144,120.618889 132.03148,105.590667 L132.36688,105.590667 L132.36688,128.511778 C132.36688,130.219778 132.25456,132.868889 132.03148,136.468444 C131.5744,140.194 130.35292,144.204222 128.37172,148.497556 C126.38584,152.538889 123.18004,155.982889 118.76212,158.821778 C114.39256,161.915778 108.29608,163.525778 100.468,163.653333 C92.92696,163.653333 86.54968,161.694889 81.32992,157.781111 C75.99472,153.928 72.87784,147.676222 71.97304,139.025778 L65.33992,139.025778 C66.02008,150.264667 69.61744,158.285111 76.13824,163.085556 C82.48744,167.693111 90.54328,170 100.29952,170 C109.9372,170 117.45328,168.200222 122.83996,164.599111 C128.16892,161.127111 131.9956,156.799556 134.32312,151.621111 C136.64752,146.444222 138.03748,141.517778 138.48832,136.846444 C138.83308,132.172 139,128.826 139,126.805333 L139,32.2742222 L132.36376,32.2742222 L132.36376,53.1124444 L132.02836,53.1124444 C129.47464,45.4731111 125.25172,39.6957778 119.35024,35.7788889 C113.39728,31.9273333 106.81876,30 99.61936,30 C87.08164,30.2535556 77.55628,35.0835556 71.03704,44.4931111 C64.34308,53.8373333 61,65.364 61,79.0668889 C61,93.1493333 64.1746,104.798889 70.5238,114.018667 C76.93852,123.429778 86.63392,128.197556 99.62248,128.323556 L99.62248,128.323556 Z M75.63436,49.6093333 C80.84788,41.0833333 88.84288,36.664 99.62248,36.3482222 C110.67976,36.6655556 118.86976,40.9588889 124.20496,49.2313333 C129.53392,57.5053333 132.19996,67.45 132.19996,79.07 C132.19996,90.69 129.53392,100.570889 124.20496,108.717333 C118.86976,117.370889 110.67976,121.788667 99.62248,121.978444 C89.18764,121.787111 81.24412,117.492222 75.80284,109.095333 C70.30072,100.948889 67.552,90.9404444 67.552,79.0684444 C67.55044,67.954 70.24456,58.1337778 75.63436,49.6093333 L75.63436,49.6093333 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'tumblr_username', '' ) !== '' ) : ?>
			<a class="contact-link TumblrLink" href="<?php echo esc_url( 'http://' . get_theme_mod( 'tumblr_username' ) . '.tumblr.com' );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,0 0,44.771526 0,100 C0,155.228474 44.771524,200 100,200 C155.228476,200 200,155.228474 200,100 C200,44.771526 155.228476,-2.2737368e-14 100,0 L100,0 L100,0 Z M83.70625,23.8125 L94.4,24 L105.09375,24.1875 L105.275,43.53125 L105.45625,62.875 L123.24375,62.875 L141.0375,62.875 L141.0375,74.4125 L141.0375,85.95625 L123.21875,86.3 C113.418206,86.488478 105.313502,86.765238 105.20625,86.9125 C105.098988,87.05976 105.182726,99.505824 105.39375,114.56875 C105.822722,145.186268 105.710682,144.529308 110.89375,148.09375 C114.911788,150.856974 117.131032,151.419076 123.91875,151.40625 C130.893356,151.39311 136.368914,149.98737 142.3375,146.68125 C143.995204,145.763014 145.52973,145.18598 145.74375,145.4 C145.957764,145.614008 146.243452,150.782168 146.38125,156.88125 L146.63125,167.96875 L143.6625,169.23125 C137.266452,171.948026 130.884404,173.982384 125.975,174.86875 C119.395078,176.056704 102.970274,176.016552 97.36875,174.8 C87.588698,172.675998 77.004154,165.465886 73.10625,158.26875 C72.121278,156.450098 70.978026,153.115688 70.5625,150.85625 C70.139362,148.555434 69.610182,133.570498 69.3625,116.79375 L68.925,86.8375 L60.81875,86.8375 L52.7125,86.8375 L52.7375,76.05 L52.75625,65.26875 L58.725,62.4125 C65.875856,58.990382 71.340804,54.291038 75.58125,47.9125 C78.886088,42.941308 82.447938,33.404152 83.23125,27.425 L83.70625,23.8125 L83.70625,23.8125 Z M83.70625,23.8125" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'medium_username', '' ) !== '' ) : ?>
			<a class="contact-link MediumLink" href="<?php echo esc_url( 'http://medium.com/@' . get_theme_mod( 'medium_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,0 0,44.771526 0,100 C0,155.228474 44.771524,200 100,200 C155.228476,200 200,155.228474 200,100 C200,44.771526 155.228476,-2.2737368e-14 100,0 Z M170,60.7998552 L164.462913,60.7998552 C162.406362,60.7998552 160.03353,63.5197353 160.03353,65.4405873 L160.03353,135.03854 C160.03353,136.96084 162.406362,139.838499 164.462913,139.838499 L170,139.838499 L170,156 L120.327936,156 L120.327936,139.838499 L130.294406,139.838499 L130.294406,66.7201902 L129.819267,66.7201902 L105.299518,156 L86.3154236,156 L62.1133873,66.7201902 L61.6382483,66.7201902 L61.6382483,139.838499 L72.0798577,139.838499 L72.0798577,156 L30,156 L30,139.838499 L35.3782303,139.838499 C37.5936376,139.838499 39.9664704,136.96084 39.9664704,135.03854 L39.9664704,65.4405873 C39.9664704,63.5197353 37.5936376,60.7998552 35.3782303,60.7998552 L30,60.7998552 L30,44 L82.520036,44 L99.7624305,108.960116 L100.23757,108.960116 L117.638821,44 L170,44 L170,60.7998552 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'svbtle_url', '' ) !== '' ) : ?>
			<a class="contact-link SvbtleLink" href="<?php echo esc_url( get_theme_mod( 'svbtle_url' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,0 0,44.771526 0,100 C0,155.228474 44.771524,200 100,200 C155.228476,200 200,155.228474 200,100 C200,44.771526 155.228476,-2.2737368e-14 100,0 Z M100,185 C146.944206,185 185,146.944206 185,100 C185,53.0557939 146.944206,15 100,15 C53.0557939,15 15,53.0557939 15,100 C15,146.944206 53.0557939,185 100,185 Z M100.5,178 C143.30207,178 178,143.30207 178,100.5 C178,57.6979298 143.30207,23 100.5,23 C57.6979298,23 23,57.6979298 23,100.5 C23,143.30207 57.6979298,178 100.5,178 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'wordpress_url', '' ) !== '' ) : ?>
			<a class="contact-link WordPressLink" href="<?php echo esc_url( get_theme_mod( 'wordpress_url' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M149.868313,160.544386 L113.76602,53.159318 C119.780129,52.8430335 125.199295,52.2104644 125.199295,52.2104644 C130.582011,51.5731922 129.94709,43.6625514 124.562022,43.9776602 C124.562022,43.9776602 108.380952,45.2475015 97.9353322,45.2475015 C88.1199295,45.2475015 71.6261023,43.9776602 71.6261023,43.9776602 C66.2386831,43.6625514 65.6072898,51.8918283 70.9923574,52.2104644 C70.9923574,52.2104644 76.0881834,52.8430335 81.4708995,53.159318 L97.0335097,95.8036449 L75.1687243,161.368607 L38.792475,53.159318 C44.8112875,52.8430335 50.2245738,52.2104644 50.2245738,52.2104644 C55.6037625,51.5731922 54.9688419,43.6625514 49.5861258,43.9776602 C49.5861258,43.9776602 33.4085832,45.2475015 22.9617872,45.2475015 C21.0875955,45.2475015 18.8783069,45.2016461 16.5326279,45.1263962 C34.3950617,18.0082305 65.0970018,0.0999412111 99.9988242,0.0999412111 C126.004703,0.0999412111 149.684891,10.0435038 167.45679,26.3280423 C167.026455,26.3021752 166.606702,26.2480894 166.163433,26.2480894 C156.350382,26.2480894 149.387419,34.7960024 149.387419,43.9776602 C149.387419,52.2104644 154.137566,59.175779 159.20047,67.4074074 C162.999412,74.0611405 167.436802,82.6078777 167.436802,94.9582598 C167.436802,103.507349 164.148148,113.429747 159.835391,127.252205 L149.868313,160.544386 Z M56.4056437,189.90241 C23.0781893,173.711934 0.102292769,139.537919 0.102292769,99.9964727 C0.102292769,85.5132275 3.20870076,71.7648442 8.75249853,59.3415638 L56.4056437,189.90241 Z M99.9988242,199.901235 C90.1928277,199.901235 80.728983,198.463257 71.776602,195.830688 L101.753086,108.734862 L132.457378,192.86067 C132.659612,193.354497 132.907701,193.809524 133.172252,194.237507 C122.788948,197.893004 111.631981,199.901235 99.9988242,199.901235 Z M187.659024,52.0717225 C195.45679,66.2998236 199.89418,82.627866 199.89418,99.9964727 C199.89418,136.851264 179.921223,169.027631 150.222222,186.343327 L180.733686,98.1246326 C186.432687,83.8730159 188.330394,72.4773663 188.330394,62.3445032 C188.330394,58.6666667 188.088183,55.2533804 187.659024,52.0717225 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'stackoverflow_userid', '' ) !== '' ) : ?>
			<a class="contact-link StackOverflowLink" href="<?php echo esc_url( 'http://stackoverflow.com/users/' . get_theme_mod( 'stackoverflow_userid' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,3.03201907e-14 0,44.771524 0,100 C0,155.228476 44.771524,200 100,200 C155.228476,200 200,155.228476 200,100 C200,44.771524 155.228476,-3.41060513e-14 100,0 Z M126.939121,113.085466 L126.939121,161.614991 L54.4418681,161.614991 L54.4418681,113.085466 L45,113.085466 L45,170.928284 L45.0942857,170.928284 C45.0942857,170.973259 47.8503297,170.973259 47.8503297,170.973259 L136.287912,170.973259 L136.287912,170.928284 C136.380989,170.928284 136.380989,168.15569 136.380989,168.15569 L136.380989,113.085466 L126.939121,113.085466 Z M131.403187,94.3446207 L100.258681,48.4260259 L110.013626,41.7370345 L141.154505,87.6592759 L131.403187,94.3446207 Z M123.484396,106.197129 L75.8737363,77.9594483 L81.872967,67.7369483 L129.481209,95.9734138 L123.484396,106.197129 Z M119.449451,121.014284 L66.0716484,106.586095 L69.1371429,95.1225517 L122.513736,109.551957 L119.449451,121.014284 Z M117.799451,136.859767 L62.7607692,131.764319 L63.8450549,119.942198 L118.882527,125.042509 L117.799451,136.859767 Z M143.268681,86.9372586 L133.815934,32.1782069 L145.446923,30.1482931 L154.902088,84.9085603 L143.268681,86.9372586 Z M117.554066,152.133957 L62.2784615,152.159483 L62.2736264,140.289957 L117.546813,140.262 L117.554066,152.133957 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'reddit_username', '' ) !== '' ) : ?>
			<a class="contact-link redditLink" href="<?php echo esc_url( 'http://reddit.com/user/' . get_theme_mod( 'reddit_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M137.537017,47.8018735 L111.526115,41.5688289 C110.245733,41.2620084 108.946828,42.0008242 108.556132,43.2581518 L98.8460785,74.5067892 C82.083987,74.7041677 66.8224616,79.1937079 55.4810762,86.4658987 L55.4810762,86.4658987 C52.5077931,83.8805204 48.7099499,82.4330113 44.7621119,82.4330113 C35.6623097,82.4330113 28.259377,89.9490302 28.259377,99.186375 C28.259377,104.98439 31.1306556,110.226058 35.8688444,113.28671 C35.62508,114.833231 35.5,116.405657 35.5,118 C35.5,142.294364 64.5425959,161.5 100,161.5 C135.457404,161.5 164.5,142.294364 164.5,118 C164.5,116.570733 164.39948,115.159079 164.203049,113.767912 C169.343763,110.817804 172.577412,105.276734 172.577412,99.186375 C172.577412,89.9490302 165.174479,82.4330113 156.074677,82.4330113 C151.942286,82.4330113 148.012178,83.9923114 144.994222,86.7737953 L144.994222,86.7737953 C134.258869,79.7480541 119.910618,75.245482 104.062714,74.5844802 L104.062714,74.5844802 L112.750093,46.8318 L136.503502,52.689397 C136.501172,52.7926493 136.5,52.8961878 136.5,53 C136.5,60.4557478 142.544096,66.5 150,66.5 C157.455904,66.5 163.5,60.4557478 163.5,53 C163.5,45.5439692 157.456031,39.5 150,39.5 C144.386166,39.5 139.572825,42.9263045 137.537017,47.8018735 L137.537017,47.8018735 Z M100.5,145.449991 C100.338445,145.482785 100.171233,145.5 100,145.5 C90.0707237,145.5 82.4431332,143.70308 77.2811178,138.815336 C76.2785356,137.866023 76.2353518,136.2837 77.1846642,135.281118 C78.1339766,134.278536 79.7162999,134.235352 80.7188822,135.184664 C84.7066938,138.960593 91.2411891,140.5 100,140.5 C100.171233,140.5 100.338445,140.517215 100.5,140.550009 C100.661555,140.517215 100.828767,140.5 101,140.5 C109.759401,140.5 116.290054,138.96115 120.281723,135.184091 C121.284622,134.235113 122.866931,134.278824 123.815909,135.281723 C124.764887,136.284622 124.721176,137.866931 123.718277,138.815909 C118.552871,143.703599 110.929209,145.5 101,145.5 C100.828767,145.5 100.661555,145.482785 100.5,145.449991 L100.5,145.449991 Z M100,0 C44.771524,3.03201907e-14 0,44.771524 0,100 C0,155.228476 44.771524,200 100,200 C155.228476,200 200,155.228476 200,100 C200,44.771524 155.228476,-3.41060513e-14 100,0 Z M122.081252,100 C116.602946,100 112,104.593296 112,110.074893 C112,115.55649 116.602946,120 122.081252,120 C127.559558,120 132,115.55649 132,110.074893 C132,104.593296 127.559558,100 122.081252,100 Z M79.0750946,100 C73.5961912,100 69,104.596099 69,110.074893 C69,115.553687 73.5961912,120 79.0750946,120 C84.553998,120 89,115.553687 89,110.074893 C89,104.596099 84.553998,100 79.0750946,100 Z M158.5,53 C158.5,57.6943529 154.694451,61.5 150,61.5 C145.305549,61.5 141.5,57.6943529 141.5,53 C141.5,48.3053929 145.305393,44.5 150,44.5 C154.694607,44.5 158.5,48.3053929 158.5,53 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'github_username', '' ) !== '' ) : ?>
			<a class="contact-link GithubLink" href="<?php echo esc_url( 'http://github.com/' . get_theme_mod( 'github_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 C44.7714,0 0,44.7714 0,100 Z M150.6562,25.4 C152.7698,28.626 153.9846,37.9372 153.1562,44.5938 L152.625,48.8562 L155.2062,51.9874 C160.3374,58.2082 163.155,65.7298 163.7186,74.725 C164.034,79.7584 163.3252,91.5746 162.4686,95.5688 C162.1878,96.8788 162.0424,98.0364 162.1498,98.1438 C162.2572,98.2512 166.8388,98.1216 172.331,97.8562 C178.1866,97.5734 183.088,97.5428 184.181,97.7812 C185.5178,98.0728 182.883,98.2622 174.8622,98.45 C168.6674,98.595 163.112,98.9354 162.4122,99.2124 C161.564,99.5484 161.0194,100.2144 160.7498,101.2436 C160.2702,103.0744 159.043,102.8318 172.0686,103.4686 C177.4508,103.7316 182.584,104.134 183.481,104.3624 C185.6578,104.9166 184.4476,104.941 180.456,104.4186 C178.6618,104.1838 173.3102,103.9562 168.5684,103.9186 L159.9496,103.8562 L158.362,106.575 C156.0142,110.5964 149.9218,116.4444 145.9182,118.5188 C141.0736,121.029 133.606,123.3814 127.037,124.4688 C123.8662,124.9936 120.9826,125.524 120.6308,125.6438 C120.1902,125.7938 120.6514,126.5576 122.1058,128.1126 C124.5016,130.674 125.7218,132.867 126.8246,136.5626 C127.4282,138.5848 127.6564,142.1844 127.887,153.6314 C128.1692,167.6364 128.1454,168.1478 127.287,168.4064 C124.4818,169.2516 119.346,170.5814 118.8808,170.5814 C118.4844,170.5814 118.2874,167.082 118.1496,157.6502 C117.9526,144.1822 117.7022,142.432 115.7496,140.8126 C115.0346,140.2196 114.9808,141.315 114.9808,155.8064 L114.9808,171.4376 L111.837,171.7814 C110.107,171.9716 107.8496,172.1466 106.8246,172.169 L104.9622,172.2128 L104.6684,163.8252 C104.5082,159.212 104.3504,151.712 104.3184,147.1628 L104.2622,138.894 L102.8684,138.894 L101.4684,138.894 L101.4684,155.669 L101.4684,172.444 L97.6246,172.369 C95.5102,172.328 93.0952,172.2098 92.2622,172.1066 L90.7498,171.919 L90.7498,155.8128 C90.7498,141.2492 90.6786,139.7714 90.0186,140.319 C87.8628,142.1082 87.7304,143.0656 87.5748,157.6628 L87.4248,171.544 L85.706,171.2316 C84.762,171.0588 82.6282,170.575 80.9622,170.1628 L77.9372,169.4128 L77.806,160.4004 L77.681,151.388 L75.3748,151.7068 C71.1312,152.2904 63.6152,152.0834 61.0248,151.313 C54.8256,149.4696 51.088,146.0926 47.831,139.3818 C45.0914,133.737 42.6232,130.4148 38.9622,127.4568 C35.1348,124.3644 34.4232,123.297 35.7246,122.6006 C36.2236,122.3336 37.7496,122.1218 39.1122,122.1256 C41.4146,122.132 45.6202,124.0678 48.212,126.4568 C49.3702,127.5244 51.2484,129.6986 52.387,131.2944 C57.1718,137.9996 62.2318,140.692 69.0246,140.1506 C72.9632,139.8368 77.6932,138.4634 78.1996,137.4882 C78.3978,137.1062 79.0304,135.5618 79.6058,134.057 C80.2762,132.3034 81.56,130.3448 83.1746,128.6008 C85.553,126.0318 85.6276,125.8664 84.6058,125.6632 C84.0104,125.5448 81.0126,125.0038 77.937,124.457 C66.5278,122.4286 58.1082,118.6336 51.7932,112.6694 C49.683,110.6764 47.272,107.974 46.4308,106.6632 L44.8996,104.2756 L34.8558,104.5632 C29.2726,104.7216 23.162,105.154 21.0996,105.5382 C17.7304,106.1658 16.5926,106.1826 17.1808,105.5944 C17.5474,105.2278 31.0384,103.96 37.7432,103.6632 C41.2674,103.5072 44.1494,103.181 44.1494,102.9382 C44.1494,102.6954 43.8384,101.891 43.4556,101.1506 C42.5108,99.3238 41.229,99.1882 27.2556,99.3694 C20.912,99.4518 15.7242,99.3752 15.7244,99.207 C15.7254,98.5884 25.0512,98.224 33.5932,98.507 C41.7982,98.7788 42.3604,98.7478 42.0682,97.9946 C41.8962,97.551 41.3,95.4044 40.7432,93.2258 C39.8556,89.7522 39.727,88.004 39.7244,79.0134 C39.7216,69.4458 39.7984,68.5452 40.8306,65.501 C42.279,61.2302 44.7806,56.4408 47.1994,53.326 L49.1432,50.826 L48.2308,46.976 C47.089,42.1816 47.2926,34.6312 48.7058,29.4948 C50.0216,24.7126 50.2068,24.5514 54.1558,24.8572 C59.2318,25.2504 65.6766,27.8206 73.7434,32.6634 L77.4746,34.901 L81.1996,34.001 C92.476,31.2752 108.7204,31.018 120.7496,33.376 L124.4184,34.0948 L128.2622,31.7386 C133.5286,28.509 138.6762,26.2346 143.1434,25.1636 C145.3898,24.624 146.9306,24.3292 148.0312,24.2876 C149.4462,24.234 150.1326,24.601 150.6562,25.4 Z M44.8113392,125.5 C43.8279276,125.5 43.5,125.686465 43.5,126.256901 C43.5,127.558949 44.7160805,128.004007 46.0532305,127.191897 C47.0542826,126.583882 46.2569319,125.5 44.8113392,125.5 L44.8113392,125.5 L44.8113392,125.5 Z M41.3302053,123.6 C40.4451349,123.6 40.15,123.786465 40.15,124.356901 C40.15,125.658949 41.2444724,126.104007 42.4479075,125.291897 C43.3488544,124.683882 42.6312387,123.6 41.3302053,123.6 L41.3302053,123.6 L41.3302053,123.6 Z M48.3,128.7376 C47.3198,128.7494 46.7682,129.372 47.1124,130.2688 C47.505,131.2918 49.9122,131.027 50.1186,129.9376 C50.2206,129.3996 49.8658,129.0394 49.0374,128.8314 C48.7708,128.7642 48.5262,128.7348 48.3,128.7376 L48.3,128.7376 L48.3,128.7376 Z M51.1688,132.8312 C49.4992,132.8312 48.8476,133.6996 49.925,134.4874 C50.986,135.2632 52.5374,134.8028 52.5374,133.7124 C52.5376,133.052 52.2002,132.8312 51.1688,132.8312 L51.1688,132.8312 L51.1688,132.8312 Z M53.95,136.175 C53.8814,136.175 53.8118,136.1778 53.7438,136.1874 C53.1452,136.273 52.7166,136.7296 52.625,137.375 C52.4988,138.263 52.6868,138.425 53.875,138.425 C54.6466,138.425 55.416,138.205 55.5812,137.9374 C56.016,137.234 54.9778,136.1766 53.95,136.175 L53.95,136.175 L53.95,136.175 Z M57.7124,139.4062 C56.6628,139.4298 56.0858,140.0874 56.4312,140.9874 C56.871,142.1332 59.2936,141.7424 59.2936,140.525 C59.2936,139.8996 58.9332,139.5422 58.1936,139.4374 C58.0258,139.4138 57.8624,139.403 57.7124,139.4062 L57.7124,139.4062 L57.7124,139.4062 Z M74.4376,140.2876 C73.9878,140.2876 73.363,140.6032 73.0438,140.9876 C72.3314,141.8458 73.1532,143.0876 74.4376,143.0876 C74.8874,143.0876 75.5184,142.772 75.8376,142.3876 C76.5498,141.5294 75.7218,140.2876 74.4376,140.2876 L74.4376,140.2876 L74.4376,140.2876 Z M68.7624,141.2438 C67.7892,141.3118 67.1762,142.1646 67.6312,143.35 C67.9936,144.294 69.7554,144.0466 70.4312,142.9562 C70.8276,142.3162 70.7836,142.0254 70.2436,141.6812 C69.718,141.3462 69.2048,141.213 68.7624,141.2438 L68.7624,141.2438 L68.7624,141.2438 Z M63.275,141.3188 C62.6408,141.3448 62.0504,141.7068 61.9312,142.3312 C61.6416,143.8496 63.6208,144.5664 64.6562,143.3188 C65.1198,142.7602 65.116,142.4766 64.6374,141.9 C64.2926,141.4844 63.7684,141.2986 63.275,141.3188 L63.275,141.3188 L63.275,141.3188 Z M63.275,141.3188" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'bitbucket_username', '' ) !== '' ) : ?>
			<a class="contact-link BitbucketLink" href="<?php echo esc_url( 'http://bitbucket.org/' . get_theme_mod( 'bitbucket_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 C44.7714,0 0,44.7714 0,100 Z M144.387295,128.89461 C143.464918,128.89461 142.725033,129.547943 142.725033,129.547943 C142.725033,129.547943 127.784508,141.39234 100.781672,141.393333 C73.7778443,141.39234 58.8373197,129.547943 58.8373197,129.547943 C58.8373197,129.547943 58.0984262,128.89461 57.1760492,128.89461 C56.0741557,128.89461 55.0297869,129.635319 55.0297869,131.269645 C55.0297869,131.442411 55.0466475,131.615177 55.0783852,131.783972 C57.3962295,144.20922 59.0912213,153.025248 59.3887623,154.366667 C61.4130328,163.506383 79.2724344,170.403121 100.779689,170.404113 L100.782664,170.404113 C122.29091,170.403121 140.150311,163.506383 142.174582,154.366667 C142.471131,153.025248 144.166123,144.20922 146.484959,131.783972 C146.515705,131.615177 146.533557,131.442411 146.533557,131.269645 C146.533557,129.635319 145.488197,128.89461 144.387295,128.89461 Z M100.781672,30.1807092 L100.781672,30.182695 L100.78068,30.1807092 C67.3826967,30.1807092 40.111082,39.1704965 40.111082,50.3307801 C40.111082,53.2707801 47.3948852,95.4236879 50.2840082,112.140284 C51.5793033,119.63773 70.9313689,130.62922 100.765803,130.62922 L100.796549,130.539858 L100.796549,130.62922 C130.630984,130.62922 149.984041,119.63773 151.279336,112.140284 C154.168459,95.4236879 161.45127,53.2707801 161.45127,50.3307801 C161.45127,39.1704965 134.179656,30.1807092 100.781672,30.1807092 Z M100.770762,56.5592908 C79.3121066,56.524539 61.9218279,52.7921986 61.9297623,48.2208511 C61.9367049,43.6485106 79.339877,39.972766 100.797541,40.0075177 C122.256197,40.0412766 139.645484,43.773617 139.638541,48.3459574 C139.631598,52.9182979 122.229418,56.5930496 100.770762,56.5592908 Z M100.781672,117.08695 C90.1297049,117.08695 81.4950656,108.441702 81.4950656,97.7798582 C81.4950656,87.1160284 90.1297049,78.472766 100.781672,78.472766 C111.432648,78.472766 120.067287,87.1160284 120.067287,97.7798582 C120.067287,108.441702 111.432648,117.08695 100.781672,117.08695 Z M110.427951,97.7739007 C110.427951,103.118723 106.100713,107.449787 100.762828,107.449787 C95.4239508,107.449787 91.0977049,103.118723 91.0977049,97.7739007 C91.0977049,92.429078 95.4239508,88.0980142 100.762828,88.0980142 C106.100713,88.0980142 110.427951,92.429078 110.427951,97.7739007 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'runkeeper_username', '' ) !== '' ) : ?>
			<a class="contact-link RunkeeperLink" href="<?php echo esc_url( 'http://runkeeper.com/user/' . get_theme_mod( 'runkeeper_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 C44.7714,0 0,44.7714 0,100 Z M102.921975,39.8630403 C100.892709,39.8989047 99.2872507,39.6935636 97.7666484,40.4303068 C93.4146363,42.5388034 89.0035536,44.530565 84.7014703,46.735872 C81.3726476,48.4423596 78.1584502,50.3759881 74.9233905,52.260391 C73.6756387,52.9872891 72.5178994,53.8707715 71.6025376,55.0130398 C70.9888584,55.7786152 70.5083228,56.5873215 70.4696455,57.6421558 C70.3278289,61.5068344 70.2396916,65.3738571 70.5158238,69.2310346 C70.6424039,70.9972961 70.8228978,72.8003596 72.1484729,74.2356375 C74.1003853,76.3490567 74.0103728,78.9985662 73.6271163,81.5381384 C73.3973968,83.0599128 73.3198079,84.5481668 73.3254337,86.0638465 C73.3268401,86.4543696 73.3695023,86.8484089 73.3327003,87.234947 C73.2290921,88.322364 73.648213,89.2213173 74.2982253,90.0386967 C74.9831644,90.9001447 75.8028879,91.6289181 76.6891831,92.2695541 C77.5398484,92.8846397 78.4329415,93.0156736 79.4169847,92.4460631 C80.4279848,91.8607472 81.5029782,91.3863062 82.5496083,90.8626395 C84.3885362,89.942824 85.4874391,88.3704176 83.5683439,86.1618289 C82.8667618,85.354529 82.3864606,84.4349479 82.0657909,83.4122274 C81.4132001,81.3299844 80.7582652,79.2470382 80.0407434,77.1865952 C78.8133851,73.6627453 78.0682032,70.0596656 77.9934272,66.318051 C77.9706897,65.1809396 78.382075,64.2681563 79.1012377,63.4521833 C80.0217564,62.4078973 81.1895752,61.7006895 82.4176368,61.0860727 C83.7108637,60.4388733 85.072772,59.963729 86.4381965,59.4951481 C88.7998533,58.6850354 91.1439296,57.8226497 93.5140252,57.0387906 C96.3208221,56.1105364 97.7235174,57.9393847 97.313304,60.0089697 C96.9952129,61.6139587 97.2139152,63.2672357 97.4063639,64.9073859 C97.8308761,68.5280461 97.8522072,72.1372204 96.8665231,75.7060766 C96.6009393,76.6680855 96.1506422,77.4278006 95.4035851,78.023196 C94.0937152,79.0672476 93.4434685,80.4115753 93.4240126,82.0786824 C93.4195589,82.4710808 93.3136067,82.8463674 93.1846825,83.2197788 C92.5487346,85.0626915 91.8755158,86.895056 91.3145784,88.7609407 C90.7662989,90.5855697 90.1779358,92.4036353 90.1287102,94.3501562 C90.0905017,95.8665392 90.5091538,97.286815 90.8546706,98.7213897 C91.0954073,99.7209039 91.1078309,100.625952 90.5543944,101.530765 C89.7597526,102.829852 89.1289616,104.216373 88.4878568,105.596331 C86.2023824,110.515844 84.1703026,115.532167 82.5695329,120.721015 C81.9103787,122.85764 81.1190185,124.930038 79.0660765,126.202871 C77.7735528,127.004311 76.5604934,127.939598 75.2414816,128.691343 C70.4944927,131.39711 66.9228237,135.204593 64.3187893,139.984868 C63.0689278,142.279015 62.0089365,144.675365 60.5942865,146.880906 C59.3097327,148.883216 58.0554174,150.905216 56.7673475,152.905182 C56.163279,153.843047 55.3367577,154.390623 54.1579218,154.431879 C53.1075412,154.468681 52.0606767,154.646362 51.0152187,154.783022 C49.8422429,154.936324 48.9704809,155.55352 48.4845539,156.626638 C48.0230053,157.645373 47.861264,158.739822 48.130364,159.833334 C48.3577394,160.756666 48.3910253,161.684451 48.4313434,162.620675 C48.4597067,163.283346 48.4784593,163.950704 48.5733944,164.605639 C49.1219082,168.383821 49.748011,172.151689 50.2311252,175.938076 C50.4709242,177.817791 51.3890988,179.00108 53.1098853,179.692114 C54.6919023,180.327359 55.4863098,180.021926 56.0362301,178.378728 C56.5073894,176.971345 56.7378121,175.504891 56.9159619,174.03492 C57.1077074,172.453606 57.4972929,170.942146 58.687146,169.807848 C60.4170743,168.15879 61.0466932,166.014194 61.6158349,163.804434 C62.2290453,161.423321 62.981025,159.067524 64.1521255,156.903942 C66.6677882,152.256342 70.2359411,148.530198 74.5354458,145.488994 C75.7513182,144.628952 76.9142145,143.699995 77.8438751,142.536161 C79.2861853,140.730519 81.134255,139.327823 82.632823,137.570704 C83.5397461,136.507431 84.8348483,135.828586 86.0823657,135.180684 C89.1552153,133.584836 91.5607064,131.357495 93.5773152,128.49069 C97.4893442,122.929369 102.200703,118.015247 106.815955,113.032444 C107.681154,112.09833 108.384142,111.506919 109.777461,112.073014 C110.952078,112.550268 111.557318,112.964935 111.718122,114.219953 C111.940575,115.955742 111.515828,117.518772 110.659537,119.036327 C108.742786,122.432659 106.887449,125.863918 105.020393,129.288145 C103.091921,132.824418 101.081172,136.304199 98.0887245,139.081695 C95.5613414,141.427647 93.5822378,144.149588 92.3087011,147.361676 C91.3555997,149.765761 91.063059,152.132106 92.3743353,154.570883 C93.7662478,157.159446 95.3780347,159.59166 97.1234339,161.940893 C98.0139484,163.139654 99.0870666,164.157452 100.512734,164.739251 C100.971235,164.926309 101.383558,164.938029 101.868782,164.813324 C103.215688,164.467339 103.599882,163.406644 103.736776,162.25875 C103.90344,160.863321 103.946102,159.422886 103.659891,158.053477 C103.206312,155.883331 103.324453,153.701699 103.24077,151.521708 C103.18123,149.971805 103.454081,148.507461 104.145818,147.101015 C104.609007,146.159399 104.983356,145.167386 105.31809,144.171154 C106.027408,142.059141 107.132405,140.227714 108.769508,138.689766 C110.077034,137.461235 111.338616,136.173634 112.522843,134.826494 C115.461377,131.483372 118.660338,128.387316 121.652083,125.092717 C124.352693,122.118787 127.139096,119.217993 129.869008,116.267738 C130.869225,115.186885 131.605734,113.882875 131.799355,112.448769 C132.370137,108.21818 131.109727,104.64112 127.558921,102.08467 C125.565518,100.649392 123.465694,99.3624946 121.457993,97.9459693 C120.216336,97.069988 118.809421,96.4349777 117.704893,95.362094 C116.69483,94.3808636 116.45761,93.4094784 117.129891,92.2029824 C118.195977,90.2899817 119.03961,88.2738417 119.998571,86.3118498 C122.344523,81.5118848 124.685552,76.7095757 127.026346,71.9070321 C127.487192,70.9614318 127.865995,69.9666058 128.412633,69.0742159 C129.039908,68.0503234 129.755554,68.1201769 130.326337,69.1841531 C130.546446,69.5943665 130.721314,70.0369281 130.857739,70.4827714 C131.553695,72.7560566 132.209802,75.0417654 132.922401,77.3096592 C133.283389,78.4589598 133.531393,79.6544387 134.189609,80.6970838 C135.023866,82.0193773 136.201764,82.2718343 137.45397,81.3553005 C137.765732,81.1269874 138.067415,80.8588251 138.299244,80.5526887 C138.840257,79.8377455 139.348218,79.096783 139.848444,78.3520699 C142.328008,74.6599153 144.694587,70.8957976 147.032803,67.1124585 C149.032535,63.8771644 150.811454,60.5617029 151.524288,56.7685186 C151.813781,55.2277572 152.123668,53.7104366 151.318712,52.2203073 C151.17502,51.9540203 151.172442,51.6150668 151.077507,51.3183068 C150.658855,50.0072649 148.824615,48.9212544 147.35652,49.8736526 C146.405528,50.4906134 145.394059,50.9983404 144.448459,51.6164733 C142.797292,52.6959204 141.774102,54.0808007 142.163219,56.2125037 C142.316287,57.0507454 142.2973,57.9201633 142.423646,58.7731726 C142.660163,60.3676133 141.598531,62.1441888 140.116137,62.7431003 C138.682266,63.3225559 137.189792,62.7194251 136.656984,61.2628161 C136.081279,59.6892377 135.566988,58.0929217 135.168261,56.4607414 C134.687022,54.4914829 134.227114,52.5142545 133.653988,50.5712497 C132.836374,47.799145 130.606689,46.6625024 128.042738,46.0171782 C126.305543,45.580008 124.498729,45.341381 123.224723,43.8728172 C122.065812,42.5366938 122.192861,41.0217172 123.556176,39.8801521 C124.189311,39.3501564 124.90988,38.9563516 125.610993,38.536762 C127.385693,37.4748954 128.274098,35.9512458 128.123374,33.8680652 C127.987418,31.9876472 128.260737,30.2312308 129.410272,28.6527298 C130.211477,27.5524204 130.020435,26.3503781 129.178677,25.4164981 C127.206137,23.2280685 125.362287,20.7745238 122.104255,20.4184586 C120.736018,20.2689066 119.375516,19.6875756 117.971648,20.2206186 C116.587706,20.7461605 115.198137,21.2574035 113.822868,21.8049797 C112.230537,22.4390524 111.098114,23.5771014 110.302768,25.0831705 C109.756364,26.1178457 109.180894,27.1377533 108.601907,28.154848 C107.325088,30.3978946 106.878307,32.5685093 108.499471,34.9371984 C109.719093,36.7191652 108.87757,38.6638109 106.880417,39.4964268 C105.439045,40.0976824 103.951963,39.792718 102.921975,39.8630403 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'strava_userid', '' ) !== '' ) : ?>
			<a class="contact-link StravaLink" href="<?php echo esc_url( 'http://strava.com/athletes/' . get_theme_mod( 'strava_userid' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M41,86.5497647 L41,83 L72,83 L72,92.6130952 L62.1318328,92.6130952 L62.1318328,117 L50.8681672,117 L50.8681672,92.6130952 L41,92.6130952 L41,86.9828526 L35.7083853,94.2372529 C33.5380941,92.6675664 30.2136764,91.3668971 27.4115124,91.0786044 C26.3474154,90.9696566 23.6077718,90.7618177 23.330598,91.9820332 C22.9713142,93.5714142 25.0140638,93.9342942 26.1523517,94.2473096 C33.3634538,96.2305789 42.6339776,96.4183043 41.965843,106.760385 C41.4831855,114.230434 34.5309179,116.963347 27.2172824,116.999384 C19.6552326,117.036259 15.9206811,115.42006 10,111.434246 L16.0019577,104.193407 C17.4195034,105.25062 17.4095001,105.249363 20.1374732,106.572659 C22.2514961,107.522601 29.4621813,109.153465 30.4587564,107.159301 C31.3136185,105.448402 28.1396666,104.832428 26.9146837,104.586457 C20.4092285,103.277826 11.3037586,101.446665 11.8314307,92.9152131 C12.3215906,84.9905169 18.8232946,82.1981007 25.7530548,82.0128894 C31.7634158,81.8525829 36.0767621,83.1775632 41,86.5497647 L41,86.5497647 Z M0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 C44.7714,0 0,44.7714 0,100 Z M146.950139,119 L165,83 L154.229917,83 L147.049861,97.4606742 L139.770083,83 L129,83 L146.950139,119 Z M106.075243,113.87384 L100.223412,105.402955 C101.360147,104.801674 101.762881,104.634861 102.823525,103.766343 C105.063364,101.932666 106.22196,99.9460415 106.711714,97.0640078 C107.438148,92.7903288 106.101728,88.8649813 102.769715,86.1178263 C100.305388,84.0858223 96.1561367,83.1164607 92.757282,83.1164607 L75,83.1164607 L75,117 L86.3000885,117 L86.3000885,107.318989 C89.1381428,107.318989 88.5449722,107.054274 89.4479703,108.408103 L94.8289649,116.542841 C95.0160385,116.855457 95.0185609,117 95.4814105,117 L115.155672,117 L122.823589,102.478483 L130.289299,117 L141,117 L122.821487,81 L106.075243,113.87384 Z M91.2424441,100 L86,100 L86,93 L90.5500459,93 C92.5819051,93 95.0745389,93.5752564 94.9982927,96.3285897 C94.92658,98.8037179 93.5438441,100 91.2424441,100 Z M171.950139,81 L190,117 L179.229917,117 L172.049861,102.539326 L164.770083,117 L154,117 L171.950139,81 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'foursquare_username', '' ) !== '' ) : ?>
			<a class="contact-link FoursquareLink" href="<?php echo esc_url( 'http://foursquare.com/' . get_theme_mod( 'foursquare_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M157.879537,55.1929514 L168.776668,66.1064788 C170.568808,67.9018984 170.567168,70.8040834 168.773388,72.594584 L102.503551,138.890656 C101.629616,139.756392 100.458904,140.243369 99.1865341,140.23845 C99.0110912,140.24009 98.8356484,140.231891 98.6618452,140.207297 C97.6387021,140.0958 96.6795053,139.635058 95.940022,138.893935 L58.9970103,101.87386 C57.1983114,100.08008 57.2048701,97.1778947 59.0019293,95.3857545 L69.9154567,84.4837046 C70.7729949,83.6294457 71.9568241,83.1457482 73.1619687,83.1424688 C74.3785909,83.1391895 75.5525821,83.632725 76.4068411,84.4902632 L99.2324443,107.358497 L151.379954,55.1880324 C152.253889,54.3239355 153.404925,53.8418777 154.633025,53.8467967 C155.862764,53.8418777 157.003962,54.3222959 157.879537,55.1929514 Z M100,200 C44.7715223,200 0,155.228478 0,100 C0,44.7715223 44.7715223,0 100,0 C155.228478,0 200,44.7715223 200,100 C200,155.228478 155.228478,200 100,200 Z M164.678554,88.1510508 L108.546689,144.305871 C106.123282,146.706323 102.916122,148.026243 99.5023654,148.026243 L97.0100936,148.022964 L96.4870444,147.673718 C94.1997291,147.129353 92.0845773,145.950443 90.4137713,144.271439 L53.4822372,107.264481 C51.06211,104.849272 49.7274329,101.637193 49.7290725,98.2201572 C49.7290725,94.8014816 51.0653893,91.5861229 53.4838769,89.174194 L64.4105215,78.2573873 C66.7847384,75.8962876 70.0689624,74.5386553 73.449926,74.5320967 C76.8210517,74.5320967 80.118393,75.9061255 82.4860512,78.286901 L99.513843,95.3458462 L135.686218,59.1570747 L111.594803,35.0656597 C105.216555,28.6890509 94.7834454,28.6890509 88.405197,35.0656597 L35.0656597,88.405197 C28.6874113,94.7818057 28.6874113,105.218194 35.0656597,111.594803 L88.4068366,164.93434 C94.7850851,171.310949 105.218194,171.310949 111.596443,164.93434 L164.93434,111.594803 C171.312589,105.218194 171.312589,94.7834454 164.93434,88.405197 Z M164.678554,88.1510508" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'yelp_url', '' ) !== '' ) : ?>
			<a class="contact-link YelpLink" href="<?php echo esc_url( get_theme_mod( 'yelp_url' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.771524,3.03201907e-14 0,44.771524 0,100 C0,155.228476 44.771524,200 100,200 C155.228476,200 200,155.228476 200,100 C200,44.771524 155.228476,-3.41060513e-14 100,0 Z M47.9872204,97.3634973 C45.6511303,101.114877 44.6642541,112.930005 45.4758906,120.770679 C45.7604904,123.359157 46.2282355,125.518642 46.9094304,126.805621 C47.8449205,128.587592 49.4154898,129.647535 51.206097,129.712214 C52.3550369,129.770293 53.0691716,129.574936 74.66977,122.618649 C74.66977,122.618649 84.2697432,119.548378 84.3079533,119.529899 C86.7033351,118.918749 88.3134321,116.714384 88.468908,113.89887 C88.6243838,111.010757 87.1381403,108.461878 84.6847846,107.539213 C84.6847846,107.539213 77.9149984,104.775177 77.9018225,104.775177 C54.6924446,95.1842126 53.6475944,94.8080187 52.4788905,94.7948189 C50.6869658,94.72354 49.0966326,95.6264054 47.9872204,97.3634973 Z M100.813425,86.9462258 C100.391795,77.2061034 97.4641065,33.835565 97.1202151,31.8265575 C96.6274358,30.006307 95.2057543,28.704808 93.16744,28.1913364 C86.9049266,26.6377215 62.9669205,33.3537728 58.534542,37.9380587 C57.1062726,39.4269946 56.5805535,41.2617649 57.0087708,42.8866586 C57.7097296,44.3241154 87.3647661,91.0685191 87.3647661,91.0685191 C91.7470761,98.188484 95.32302,97.0836618 96.4969942,96.7127478 C97.6591101,96.3550336 101.216608,95.2502115 100.813425,86.9462258 Z M125.439214,107.239578 C149.972771,101.283834 150.921437,100.972319 151.888549,100.334769 C153.374793,99.3329054 154.12055,97.6552126 153.991426,95.6145256 C153.991426,95.5485267 154.003284,95.4772478 153.991426,95.405969 C153.361617,89.3723466 142.807707,73.6751605 137.608491,71.1262818 C135.76518,70.2418961 133.921869,70.2999751 132.390827,71.3282385 C131.442161,71.9459885 130.747791,72.8818534 117.611401,90.8797622 C117.611401,90.8797622 111.679603,98.9751912 111.607136,99.05307 C110.043155,100.959119 110.016803,103.690155 111.549162,106.030477 C113.132907,108.456598 115.806301,109.639299 118.260974,108.95687 C118.260974,108.95687 118.163472,109.132427 118.13712,109.164106 C119.344034,108.710034 121.506202,108.176762 125.439214,107.239578 Z M136.59658,160.909909 C142.048775,158.731945 153.938722,143.57463 154.77671,137.742964 C155.067898,135.714157 154.432819,133.963865 153.037489,132.845843 C152.121763,132.156814 151.427392,131.890179 129.83997,124.790014 C129.83997,124.790014 120.370438,121.655064 120.246585,121.596985 C117.955293,120.706 115.339873,121.532306 113.580888,123.703671 C111.750753,125.934435 111.478012,128.879307 112.937903,131.103471 L116.748379,137.319251 C129.56064,158.165674 130.540929,159.64273 131.461925,160.363438 C132.890195,161.48938 134.707154,161.670217 136.59658,160.909909 Z M99.9121919,168.823181 C100.287706,167.730239 100.333821,166.983131 100.398383,144.250459 C100.398383,144.250459 100.449769,134.205421 100.456357,134.107743 C100.613151,131.643343 99.0228175,129.399379 96.4192563,128.398835 C93.7392748,127.365292 90.8511138,128.001522 89.2278408,130.023729 C89.2278408,130.023729 84.489781,135.654758 84.4766051,135.654758 C68.218841,154.791808 67.5363285,155.676194 67.141051,156.807416 C66.9012493,157.470045 66.8037476,158.185473 66.8814855,158.894302 C66.9789873,159.908045 67.4401444,160.909909 68.1990772,161.845774 C71.9700246,166.332382 90.0526532,172.998274 95.8289752,172.00961 C97.8343498,171.645296 99.295559,170.514074 99.9121919,168.823181 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'slideshare_username', '' ) !== '' ) : ?>
			<a class="contact-link SlideShareLink" href="<?php echo esc_url( 'http://slideshare.net/' . get_theme_mod( 'slideshare_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M49.8552021,103.888776 C66.9161426,112.994187 81.5816656,111.388172 89.5647443,111.137091 C93.6944856,110.929764 96.0117525,112.108443 97.132922,114.176598 L97.132922,114.176598 C98.799745,115.702875 100.422394,117.008198 102.001428,118.070307 L102.001428,118.070307 C102.06335,113.715983 104.149828,110.821576 110.433932,111.137091 C118.371593,111.386723 132.915876,112.975701 149.85042,104.045297 L149.85042,56.1517682 C149.85042,47.916039 147.180071,44.6535295 139.617182,44.6535295 L60.0588379,44.6535295 C52.0767061,44.6535295 49.8552021,47.3985423 49.8552021,56.1517682 L49.8552021,103.888776 Z M43,99.7065932 C42.6283708,99.4505949 42.255927,99.1891233 41.8827087,98.9220651 C38.0677069,96.2531435 35.5662125,99.8859569 37.9058334,103.357892 C42.4602404,108.950115 51.1170434,115.894674 64.3927285,121.356957 C50.3481443,169.313669 98.6735584,176.931302 97.935525,152.34381 C97.935525,152.797193 97.9622128,138.564317 97.9812482,128.354927 C99.5126575,128.711642 100.800854,129.06087 102.02038,129.345144 C102.039046,139.458749 102.063789,152.782708 102.063789,152.34381 C101.326438,176.931302 149.684366,169.313669 135.606778,121.356957 C148.882539,115.894674 157.541449,108.950115 162.093824,103.357892 C164.433458,99.8859569 161.934007,96.2531435 158.117612,98.9220651 C157.408859,99.4292483 156.702894,99.9162821 155.999995,100.383942 L156,50.5000681 C156,43.5860629 150.81695,38 144.443636,38 L54.5542992,38 C48.1809852,38 43,43.5860629 43,50.5000681 L43,99.7065932 Z M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M103,90.4996546 C103,98.5096587 109.943453,105 118.501036,105 C127.057238,105 134,98.5096587 134,90.4996546 C134,82.4910321 127.057238,76 118.501036,76 C109.943453,76 103,82.4910321 103,90.4996546 Z M98,90.4996546 C98,98.5096587 91.0581551,105 82.5,105 C73.9425357,105 67,98.5096587 67,90.4996546 C67,82.4910321 73.9425357,76 82.5,76 C91.0581551,76 98,82.4910321 98,90.4996546 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'researchgate_username', '' ) !== '' ) : ?>
			<a class="contact-link ResearchGateLink" href="<?php echo esc_url( 'http://www.researchgate.net/profile/' . get_theme_mod( 'researchgate_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M49.8571429,96 L49.8571429,66.55 L59.6236948,66.55 C69.1987936,66.55 73.9862712,71.2676713 73.9862712,80.7031553 C73.9862712,86.2310147 72.6457775,90.1624074 69.9647498,92.4974515 C67.2837222,94.8324955 63.4537401,96 58.4746887,96 L49.8571429,96 Z M31,52 L31,149 L50.6363636,149 L50.6363636,107.971989 L61.1363636,107.971989 C65.2272932,107.971989 68.136355,109.058813 69.8636364,111.232493 C71.5909177,113.406173 72.5454536,116.394939 72.7272727,120.19888 L73.2727273,138.810924 C73.3636368,140.712895 73.5454532,142.54691 73.8181818,144.313025 C74.0909105,146.07914 74.7272677,147.64145 75.7272727,149 L97,149 L97,148.184874 C95.1818091,147.188604 94.0000027,145.331946 93.4545455,142.614846 C93.0909073,139.897746 92.8181827,135.958009 92.6363636,130.795518 C92.5454541,128.168988 92.4545459,125.791561 92.3636364,123.663165 C92.2727268,121.53477 92.1363645,119.564902 91.9545455,117.753501 C91.4090882,112.319301 90.0000114,108.379564 87.7272727,105.934174 C85.4545341,103.488783 81.8636609,101.903832 76.9545455,101.179272 L76.9545455,100.907563 C82.5000277,99.7301528 86.5908959,97.0810197 89.2272727,92.960084 C91.8636495,88.8391484 93.1818182,83.5182399 93.1818182,76.9971989 C93.1818182,68.5741876 90.9091136,62.3023082 86.3636364,58.1813725 C81.8181591,54.0604369 75.4545864,52 67.2727273,52 L31,52 Z M150.429787,80.5818674 L168.92766,80.5818674 C168.92766,70.7487104 166.604279,63.1935311 161.957447,57.9161028 C157.310615,52.6386746 149.714946,50 139.170213,50 C133.004224,50 127.865978,51.0374276 123.755319,53.1123139 C119.64466,55.1872003 116.33831,58.2769303 113.83617,62.3815968 C111.33403,66.4862632 109.569154,71.6057429 108.541489,77.7401894 C107.513825,83.874636 107,91.0013126 107,99.120433 C107,107.510191 107.357443,114.884948 108.07234,121.244926 C108.787238,127.604903 110.19467,132.949911 112.294681,137.280108 C114.394691,141.610306 117.298918,144.8128 121.007447,146.887686 C124.715976,148.962572 129.519119,150 135.417021,150 C139.974491,150 143.884026,149.210653 147.145745,147.631935 C150.407463,146.053217 153.199988,143.369437 155.523404,139.580514 L155.791489,139.580514 L155.791489,148.511502 L170,148.511502 L170,96.4140731 L138.768085,96.4140731 L138.768085,110.757781 L151.502128,110.757781 L151.502128,120.635995 C151.502128,123.252156 151.100004,125.529986 150.295745,127.469553 C149.491485,129.409121 148.486176,131.010368 147.279787,132.273342 C146.073398,133.536317 144.777666,134.483533 143.392553,135.11502 C142.00744,135.746507 140.734048,136.062246 139.57234,136.062246 C136.802114,136.062246 134.545753,135.182688 132.803191,133.423545 C131.06063,131.664403 129.720217,129.138492 128.781915,125.845737 C127.843612,122.552983 127.195746,118.561142 126.838298,113.870095 C126.480849,109.179047 126.302128,103.946804 126.302128,98.173207 C126.302128,86.0847388 127.329777,77.4244736 129.385106,72.1921516 C131.440436,66.9598295 134.791466,64.3437077 139.438298,64.3437077 C141.404265,64.3437077 143.07978,64.8624215 144.464894,65.8998647 C145.850007,66.9373078 146.989357,68.2453687 147.882979,69.8240866 C148.7766,71.4028045 149.424466,73.1393681 149.826596,75.0338295 C150.228725,76.9282909 150.429787,78.7776184 150.429787,80.5818674 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'youversion_username', '' ) !== '' ) : ?>
			<a class="contact-link YouVersionLink" href="<?php echo esc_url( 'http://bible.com/users/' . get_theme_mod( 'youversion_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M179.638005,100.218227 C179.638005,85.2558166 173.275325,77.3499143 161.222013,77.3499143 C149.156255,77.3499143 142.771796,85.2558166 142.771796,100.218227 C142.771796,115.180637 149.156255,123.102096 161.222013,123.102096 C173.275325,123.102096 179.638005,115.180637 179.638005,100.218227 Z M20.7110111,100.218227 C20.7110111,115.180637 27.0892479,123.102096 39.1394485,123.102096 C47.5556097,123.102096 57.5927766,119.141367 57.5927766,100.218227 C57.5927766,85.2558166 51.2145397,77.3499143 39.1394485,77.3499143 C27.0892479,77.3499143 20.7110111,85.2558166 20.7110111,100.218227 Z M100.175752,179.701947 C119.083335,179.701947 123.059622,169.680337 123.059622,161.261065 C123.059622,152.832458 119.083335,142.801514 100.175752,142.801514 C81.2526127,142.801514 77.2887719,152.832458 77.2887719,161.261065 C77.2887719,169.680337 81.2526127,179.701947 100.175752,179.701947 Z M100.175752,20.7376177 C81.2526127,20.7376177 77.2887719,30.7592278 77.2887719,39.1753891 C77.2887719,47.5822164 81.2526127,57.6224945 100.175752,57.6224945 C119.083335,57.6224945 123.059622,47.5822164 123.059622,39.1753891 C123.059622,30.7592278 119.083335,20.7376177 100.175752,20.7376177 Z M43.5273643,66.7327946 C49.1868827,57.1996641 57.1363437,49.2346464 66.6756969,43.5875733 C66.4827942,42.1252458 66.3147821,40.6629184 66.3147821,39.1788116 C66.3147821,35.0158453 67.1143952,30.9524417 68.6762854,27.1815037 C50.0829472,35.2274161 35.176541,50.1369336 27.143074,68.7333831 C30.9109007,67.1777155 34.9836383,66.3749911 39.1372705,66.3749911 C40.6151547,66.3749911 42.0774821,66.5492259 43.5273643,66.7327946 Z M133.674252,43.6021966 C143.182492,49.2554923 151.135064,57.2049534 156.782137,66.7318612 C158.241354,66.5514038 159.722349,66.3740577 161.222013,66.3740577 C165.366311,66.3740577 169.407935,67.1643368 173.150871,68.7013363 C165.132961,50.1235548 150.235889,35.22026 131.673664,27.1899043 C133.223109,30.9515083 134.032056,35.0242459 134.032056,39.1778782 C134.032056,40.661985 133.867155,42.1305351 133.674252,43.6021966 Z M66.6601403,156.878438 C57.1363437,151.225142 49.171326,143.253902 43.5273643,133.71766 C42.0774821,133.910563 40.6151547,134.078575 39.1372705,134.078575 C34.9680816,134.078575 30.8984554,133.269628 27.1275173,131.710849 C35.1609844,150.322855 50.0829472,165.244818 68.6887307,173.284508 C67.1143952,169.504236 66.3178934,165.428387 66.3178934,161.262309 C66.3178934,159.784425 66.4827942,158.32832 66.6601403,156.878438 Z M156.781204,133.717971 C151.146576,143.241768 143.197115,151.213008 133.667096,156.85697 C133.866222,158.322409 134.031122,159.784736 134.031122,161.26262 C134.031122,165.428698 133.231509,169.501435 131.660285,173.269262 C150.238067,165.235795 165.144473,150.335612 173.165494,131.745385 C169.422558,133.282384 165.362266,134.075775 161.221079,134.075775 C159.733861,134.075775 158.255977,133.910874 156.781204,133.717971 Z M156.781204,133.717971" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'psn_username', '' ) !== '' ) : ?>
			<a class="contact-link PSNLink" href="<?php echo esc_url( 'http://us.playstation.com/publictrophy/index.htm?onlinename=' . get_theme_mod( 'psn_username' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M137.746269,114.149625 C145.751119,114.18 153.796269,115.18125 161.452985,117.594375 C162.955224,118.053375 164.410448,118.647375 165.90709,119.126625 C168.574627,120.1065 171.245522,121.2945 173.381343,123.221625 C174.665299,124.398375 175.771269,125.9835 175.78694,127.793625 C175.86306,129.26625 175.199254,130.67925 174.248881,131.766 C172.439925,133.8045 170.048881,135.205125 167.647761,136.426875 C165.092164,137.736375 162.345149,138.58125 159.665299,139.578 C143.308582,145.480875 126.950746,151.3815 110.596269,157.291125 C110.59403,152.6865 110.600746,148.083 110.59403,143.480625 C110.618657,143.29725 110.51791,142.976625 110.776493,142.92825 C123.222015,138.47775 135.664179,134.014875 148.107463,129.553125 C149.789925,128.920875 151.602239,128.463 153.030597,127.3155 C153.614925,126.85425 154.18694,126.12075 153.900373,125.329875 C153.601493,124.638 152.887313,124.254375 152.230224,123.968625 C150.367537,123.22725 148.339179,123.08325 146.357836,123.028125 C143.25597,123.0495 140.126119,123.43425 137.176493,124.43325 C128.31194,127.555125 119.46306,130.71525 110.596269,133.827 C110.597388,128.882625 110.59403,123.941625 110.598507,118.998375 C117.013806,116.736 123.712313,115.364625 130.457836,114.585 C132.877985,114.30375 135.313806,114.237375 137.746269,114.149625 Z M76.6033582,107.966625 C76.6201493,112.1775 76.6033582,116.3895 76.6100746,120.60375 C76.6033582,121.17525 76.6402985,121.749 76.5686567,122.317125 C68.130597,125.323125 59.7093284,128.382 51.2791045,131.407125 C50.1104478,131.850375 48.9115672,132.35325 48.0104478,133.249875 C47.5906716,133.670625 47.2492537,134.291625 47.4787313,134.894625 C47.7675373,135.6045 48.4884328,135.990375 49.1533582,136.282875 C51.0026119,137.038875 53.0242537,137.14575 54.994403,137.236875 C57.1906716,137.202 59.3958955,137.036625 61.5473881,136.559625 C63.0014925,136.27275 64.4007463,135.78 65.7865672,135.256875 C69.388806,133.94625 72.9910448,132.62775 76.5988806,131.330625 C76.6257463,134.892375 76.6033582,138.456375 76.6100746,142.0215 C76.5988806,142.733625 76.6425373,143.45025 76.5720149,144.160125 C72.1414179,144.96 67.658209,145.503375 63.1548507,145.57425 C54.0865672,145.780125 44.9970149,144.369375 36.383209,141.520875 C33.5578358,140.6985 30.7503731,139.603875 28.391791,137.8005 C27.0932836,136.79025 25.9313433,135.520125 25.3402985,133.9575 C24.8455224,132.6345 24.8813433,131.105625 25.4981343,129.82875 C26.0925373,128.55525 27.1313433,127.548375 28.2753731,126.7665 C30.9227612,124.929375 33.8421642,123.52875 36.8007463,122.278875 C39.3496269,121.185375 41.9936567,120.334875 44.5962687,119.380875 C55.2675373,115.584 65.9276119,111.751125 76.6033582,107.966625 Z M100.803731,46.81275 C104.473134,47.88375 108.132463,48.991875 111.768284,50.172 C117.479478,52.000125 123.166045,54.070125 128.338806,57.157125 C130.65597,58.57125 132.881343,60.16875 134.783209,62.11725 C136.84403,64.141125 138.53097,66.541875 139.76903,69.154125 C142.024627,73.888125 142.797015,79.17675 143.025373,84.3765 C143.132836,87.7695 143.126119,91.19175 142.495896,94.540875 C141.972015,97.45125 141.040672,100.321125 139.491418,102.849 C138.123507,105.082125 136.221642,107.012625 133.913433,108.256875 C131.699254,109.456125 129.163806,110.027625 126.652985,109.977 C122.844776,110.0175 119.149627,108.796875 115.73209,107.19825 C115.670522,95.776125 115.723134,84.35175 115.705224,72.93075 C115.680597,70.864125 115.820522,68.776125 115.406343,66.737625 C115.115299,65.158125 114.473881,63.56625 113.240299,62.494125 C112.422015,61.75275 111.36194,61.33425 110.296269,61.108125 C109.218284,60.90225 108.068657,61.362375 107.401493,62.232 C106.292164,63.62475 106.001119,65.47425 105.950746,67.207875 C105.941791,97.7865 105.96194,128.36625 105.941791,158.942625 C97.7567164,156.336 89.5705224,153.727125 81.3876866,151.112625 C81.3787313,114.741375 81.3820896,78.37125 81.3865672,42 C87.9440299,43.2285 94.3895522,44.9835 100.803731,46.81275 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'xbox_live_username', '' ) !== '' ) : ?>
			<a class="contact-link XboxLiveLink" href="<?php echo esc_url( 'http://live.xbox.com/Profile?GamerTag=' . str_replace( ' ' , '%20', get_theme_mod( 'xbox_live_username' ) ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M167.455062,26.176199 C187.455217,44.4611219 200,70.7655263 200,100 C200,123.226018 192.081879,144.602611 178.797786,161.577629 L178.797786,161.577629 C181.36533,125.252683 140.057811,73.4264509 127.169921,57.316014 C127.566995,56.6474637 127.973818,55.9760466 128.39118,55.3015303 C136.846479,43.7058318 152.080355,29.7690201 167.455062,26.176199 Z M150.155731,13.4684324 C135.411935,4.90414122 118.278695,0 100,0 C81.7221546,0 64.5896569,4.90368547 49.8463247,13.4672386 L49.8463247,13.4672386 C70.276639,13.4102891 88.9045135,22.8674393 100.400717,30.1905679 C111.748069,22.9371796 130.046544,13.6012145 150.155731,13.4684324 Z M100.36063,80.8296517 C96.4863975,84.0319575 92.8976283,87.1708474 89.3649585,90.251947 C89.3639396,90.2497443 89.3629207,90.2475417 89.3619018,90.2453391 C63.9110888,113.373814 31.4358547,143.902276 31.1823579,172.55473 C49.1098731,189.564438 73.3362259,200 100,200 C126.933969,200 151.380868,189.351871 169.360698,172.03561 C168.631231,143.553032 136.561966,113.2805 111.384727,90.3088567 C111.3841,90.3102151 111.383474,90.3115734 111.382847,90.3129318 C107.841451,87.2141109 104.243308,84.056833 100.36063,80.8296517 Z M32.6677679,26.0640895 C12.5961588,44.3535182 0,70.7057246 0,100 C0,123.571005 8.15509089,145.237236 21.7977011,162.33112 L21.7977019,162.331128 C18.4789197,126.007194 60.4788831,73.5168407 73.5229252,57.2840331 C73.1244409,56.6159842 72.716205,55.9450615 72.2974246,55.2710379 C63.7385145,43.5711574 48.2430107,29.4854646 32.6677679,26.0640895 L32.6677679,26.0640895 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
			
		<?php if ( get_theme_mod( 'steam_url', '' ) !== '' ) : ?>
			<a class="contact-link SteamLink" href="<?php echo esc_url( get_theme_mod( 'steam_url' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M158.258929,64 C146.358414,64 136.692907,73.5974571 136.584821,85.4732143 L123.080357,104.825893 C122.5302,104.768964 121.971036,104.736607 121.40625,104.736607 C118.389071,104.736603 115.56945,105.566009 113.147321,107.013393 L51.9866071,82.4151786 C50.3881671,75.1588836 43.90355,69.6919643 36.1830357,69.6919643 C27.2692014,69.6919621 20,76.9834843 20,85.8973214 C19.9999991,94.8111543 27.2691986,102.080357 36.1830357,102.080357 C39.2000793,102.080353 42.0198336,101.250999 44.4419643,99.8035714 L105.602679,124.357143 C107.184964,131.630394 113.670264,137.10268 121.40625,137.10268 C129.785757,137.10268 136.699314,130.67943 137.5,122.504464 L158.258929,107.325893 C170.224079,107.325891 179.933043,97.6358043 179.933036,85.6741071 C179.933043,73.7055671 170.224943,64 158.258929,64 Z M158.258929,71.1428571 C166.275943,71.1428571 172.790179,77.6568986 172.790179,85.6741071 C172.790171,93.6913143 166.275943,100.183036 158.258929,100.183036 C150.241921,100.183034 143.727679,93.6913157 143.727679,85.6741071 C143.727671,77.6568971 150.241914,71.1428571 158.258929,71.1428571 Z M169.924114,85.6071436 C169.924114,92.0142864 164.724114,97.2142871 158.316964,97.2142871 C151.909829,97.2142871 146.709821,92.0142864 146.709821,85.6071436 C146.709821,79.2 151.909829,74 158.316964,74 C164.724114,74 169.924114,79.2 169.924114,85.6071436 Z M36.1830357,73.9776786 C40.7526086,73.9776764 44.7018479,76.5306829 46.6964286,80.2946429 L40.78125,77.9285714 L40.78125,77.9508929 C36.0155329,76.2394643 30.72125,78.56875 28.8169643,83.3080357 C26.9126771,88.0473171 29.1033929,93.4117857 33.7276786,95.4732143 L33.7276786,95.4955357 L38.75,97.5044643 C37.9243764,97.684295 37.0644021,97.7946429 36.1830357,97.7946429 C29.5880421,97.7946443 24.2857143,92.4923186 24.2857143,85.8973214 C24.2857143,79.3023229 29.5880386,73.9776786 36.1830357,73.9776786 Z M121.40625,109.022321 C128.001614,109.022316 133.303571,114.324251 133.303571,120.919643 C133.303543,127.515037 128.001643,132.816966 121.40625,132.816966 C116.81865,132.816966 112.857507,130.259109 110.870536,126.477679 C112.827036,127.267187 114.786907,128.04863 116.741071,128.843751 C121.590336,130.792323 127.113214,128.44893 129.0625,123.598214 C131.011757,118.748925 128.644643,113.247679 123.794643,111.299107 L118.839286,109.3125 C119.664914,109.132676 120.524829,109.022321 121.40625,109.022321 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'twitch_url', '' ) !== '' ) : ?>
			<a class="contact-link TwitchLink" href="<?php echo esc_url( get_theme_mod( 'twitch_url' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 Z M48.2515912,37 L40,58.9135 L40,146.557 L70.2417758,146.557 L70.2417758,163 L86.7525497,163 L103.246875,146.557 L127.995322,146.557 L161,113.70124 L161,37 L48.2515912,37 Z M59,48 L150,48 L150,108.350584 L130.692895,127.555548 L100.365482,127.555548 L83.8316372,144 L83.8316372,127.555548 L59,127.555548 L59,48 Z M90,103 L101,103 L101,70 L90,70 L90,103 Z M120,103 L131,103 L131,70 L120,70 L120,103 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'skype_username', '' ) !== '' ) : ?>
			<a class="contact-link SkypeLink" href="skype:<?php echo get_theme_mod( 'skype_username' );?>?userinfo" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> rel="me">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C44.7714,0 0,44.7714 0,100 C0,155.2286 44.7714,200 100,200 C155.2286,200 200,155.2286 200,100 C200,44.7714 155.2286,0 100,0 L100,0 L100,0 Z M164.926099,114.836301 C167.45958,119.935497 168.890707,125.679343 168.890707,131.759126 C168.890707,152.807004 151.826776,169.864489 130.778897,169.864489 C124.261468,169.864489 118.13083,168.226358 112.767327,165.344764 C108.867185,166.066774 104.844558,166.447119 100.73168,166.447119 C64.4377874,166.447119 35.0158825,137.025214 35.0158825,100.731322 C35.0158825,96.2058664 35.4800318,91.7900021 36.3503116,87.5159611 C33.0239087,81.8623655 31.1092931,75.2804713 31.1092931,68.2408745 C31.1092931,47.1994421 48.1732243,30.1355108 69.2211032,30.1355108 C76.6732772,30.1355108 83.6226228,32.2822011 89.4954001,35.982502 C93.1441289,35.3507433 96.9024484,35.0219709 100.73168,35.0219709 C137.025572,35.0219709 166.447477,64.4438758 166.447477,100.731322 C166.447477,105.57194 165.918862,110.291507 164.926099,114.836301 Z M80.4996434,57.3491254 C74.9742618,59.3926714 70.6830301,62.3716786 67.7441345,66.2044913 C64.7837505,70.0645226 63.2824283,74.5384056 63.2824283,79.5029402 C63.2824283,84.7110098 64.7128388,89.1419161 67.5349808,92.6724587 C70.3134298,96.1507129 74.111861,98.9298781 78.8235489,100.934745 C83.4320924,102.89377 89.2260789,104.627883 96.0457779,106.088377 C101.060452,107.138443 105.115311,108.142668 108.102914,109.073831 C110.967317,109.967032 113.326026,111.267796 115.11386,112.940309 C116.822187,114.539762 117.651639,116.57901 117.651639,119.173375 C117.651639,122.456801 116.061498,125.138552 112.788816,127.372629 C109.438059,129.65971 104.984949,130.820083 99.5526833,130.820083 C95.6016845,130.820083 92.3906026,130.247775 90.0082564,129.120351 C87.6395194,128.000806 85.7850713,126.566814 84.4972004,124.860636 C83.1563248,123.086411 81.8856446,120.835144 80.7216901,118.167718 C79.6795031,115.718042 78.3816043,113.822049 76.8688216,112.539909 C75.2858434,111.201898 73.3382789,110.524298 71.0805653,110.524298 C68.329335,110.524298 66.0221981,111.382401 64.2221872,113.075686 C62.4035531,114.784729 61.4809848,116.872685 61.4809848,119.280101 C61.4809848,123.132969 62.8970698,127.127661 65.6884118,131.153869 C68.4525351,135.139966 72.0926685,138.370387 76.5078166,140.754882 C82.6835802,144.031146 90.5970383,145.691482 100.03474,145.691482 C107.898774,145.691482 114.807292,144.477388 120.570479,142.081432 C126.389535,139.661839 130.881325,136.253064 133.921216,131.951088 C136.972567,127.633354 138.519015,122.698904 138.519015,117.285978 C138.519015,112.761955 137.620084,108.868259 135.847292,105.714479 C134.078797,102.57216 131.58686,99.9391162 128.438811,97.88984 C125.355227,95.8835406 121.57327,94.1565902 117.197517,92.7555471 C112.876202,91.3738436 107.988309,90.0952843 102.670649,88.9535345 C98.4689521,87.9822592 95.4039913,87.2315981 93.5781944,86.7244721 C91.7953742,86.2316716 90.0161354,85.5426106 88.2884688,84.6744796 C86.6231185,83.8414463 85.3058801,82.8400873 84.3725677,81.6990537 C83.4908274,80.6224853 83.0617758,79.3711447 83.0617758,77.8734039 C83.0617758,75.4323226 84.3940561,73.3715859 87.1352585,71.5744402 C89.9796052,69.7092479 93.810269,68.7644749 98.5212406,68.7644749 C103.593217,68.7644749 107.284206,69.6168478 109.49178,71.2965237 C111.767401,73.0256229 113.75078,75.4803134 115.388911,78.5939812 C116.804996,81.0321973 118.08069,82.7276314 119.310543,83.8142277 C120.632795,84.9846287 122.537383,85.5791408 124.970585,85.5791408 C127.649471,85.5791408 129.920077,84.6300702 131.719372,82.7584314 C133.508639,80.8989693 134.416165,78.7651721 134.416165,76.4172072 C134.416165,73.9775586 133.723523,71.4555378 132.360442,68.9213402 C131.010971,66.4122124 128.8607,63.996201 125.971227,61.7384874 C123.101811,59.4972482 119.450217,57.6757489 115.118874,56.326278 C110.811884,54.9868349 105.652521,54.3085181 99.7840417,54.3085181 C92.4407422,54.3092343 85.953397,55.3320818 80.4996434,57.3491254 Z M80.4996434,57.3491254" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'paypal_url', '' ) !== '' ) : ?>
			<a class="contact-link PayPal" href="<?php echo esc_url( get_theme_mod( 'paypal_url', '' ) ); ?>" rel="me" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?>>
				<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve">
					<ellipse cx="65" cy="8.5" rx="117" ry="100.5" style="display:none; fill:#BC3939;" />
					<path class="social-icon-fill SocialIconFill" d="M100,0C44.8,0,0,44.8,0,100c0,55.2,44.8,100,100,100s100-44.8,100-100C200,44.8,155.2,0,100,0z M62.7,143.3 c-1.7,0-3.1-1.6-2.8-3.3l13.7-87.1c0.4-2.3,2.3-4,4.7-4h30.7c11.4,0,20.2,2.5,25.2,8c5,5.5,6.9,13.4,2.5,26.7 c-3.5,10.6-10.3,17.3-20.6,20.2c-4.1,1.2-8.6,1.7-13.8,1.7c0,0-3.9,0-9.7,0c-4.5,0-6.4,3.2-6.9,6.2c-0.1,0.9-5,31.5-5,31.5H62.7z M149.1,99.3c-3.8,19.5-16.8,26.3-33.5,26.3h-2.6c-2,0-3.8,1.5-4.1,3.5l-3.6,22.5c-0.3,2-2,3.5-4.1,3.5H86.4c-1.4,0-2.7-1.2-2.5-2.7 c0.4-2.5,6.3-40.1,6.3-40.1c0.2-1.2,1.2-2.1,2.4-2.1h2c0,0,2.8,0,7.4,0c31.3,0,38.6-19.9,40.9-32.9C150.2,82,150.7,91.1,149.1,99.3z" fill="#444444" />
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'periscope_username', '' ) !== '' ) : ?>
			<a class="contact-link Periscope" href="<?php echo esc_url( 'http://www.periscope.tv/' . get_theme_mod( 'periscope_username', '' ) ); ?>" rel="me" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?>>
				<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve">
					<ellipse cx="65" cy="8.5" rx="117" ry="100.5" style="display:none; fill:#BC3939;" />
					<g>
						<path class="social-icon-fill SocialIconFill" d="M100,55.5c-2.4,0-4.8,0.3-7,0.8c4.1,2,6.9,6.2,6.9,11.1c0,6.8-5.5,12.3-12.3,12.3c-6.6,0-11.9-5.1-12.3-11.6 c-3.6,5-5.8,11.2-5.8,17.9c0,16.9,13.7,30.5,30.5,30.5s30.5-13.7,30.5-30.5C130.5,69.2,116.9,55.5,100,55.5z" fill="#444444" />
						<path class="social-icon-fill SocialIconFill" d="M100,0C44.8,0,0,44.8,0,100c0,55.2,44.8,100,100,100s100-44.8,100-100C200,44.8,155.2,0,100,0z M100,164.4 c-10.1,0-50.3-41.1-50.3-78.6c0-27.8,22.5-50.3,50.3-50.3c27.8,0,50.3,22.5,50.3,50.3C150.3,123.3,110.1,164.4,100,164.4z" fill="#444444" />
					</g>
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'amazon_wishlist_url', '' ) !== '' ) : ?>
			<a class="contact-link AmazonWishlist" href="<?php echo esc_url( get_theme_mod( 'amazon_wishlist_url', '' ) ); ?>" rel="me" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?>>
				<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve">
					<ellipse cx="65" cy="8.5" rx="117" ry="100.5" style="display:none;fill:#BC3939;" />
					<g>
						<path class="social-icon-fill SocialIconFill" d="M77.1,123.5c1.2,2.7,3.6,4,6.4,3.7c1.9-0.2,3.6-1,4.9-2.3c1.4-1.3,2.3-3,3-4.8c0.7-1.9,0.9-3.9,1-6 c0-1.7,0-3.5,0-5.2c0-0.1,0-0.3,0-0.5c-0.1,0-0.2,0-0.2,0c-2.2,0-4.5,0.2-6.7,0.6c-1.7,0.4-3.3,0.9-4.8,1.8 c-1.8,1.1-3.1,2.6-3.8,4.6c-0.5,1.5-0.7,3.1-0.6,4.6C76.4,121.2,76.6,122.4,77.1,123.5z" fill="#444444" />
						<path class="social-icon-fill SocialIconFill" d="M132.4,77.6c-0.1,0.9-0.3,1.7-0.8,2.4c-0.5,0.7-1.2,1.2-2,1.5c1.9,0.1,3.2,1,4,2.9c0.1-2,1-3.3,2.8-4.1 C134.5,80.2,133.2,79.3,132.4,77.6z" fill="#444444" />
						<path class="social-icon-fill SocialIconFill" d="M118,65.9c0.1-5.2,2.5-8.6,7.3-10.4c-5.2,0-8.7-2.5-10.5-7.5c0.3,4.6-2.5,9.1-7.3,10.6 C112.7,58.7,116.2,61.1,118,65.9z" fill="#444444" />
						<path class="social-icon-fill SocialIconFill" d="M100,0C44.8,0,0,44.8,0,100c0,55.2,44.8,100,100,100s100-44.8,100-100C200,44.8,155.2,0,100,0z M108.7,51.9 c3.3-4.6,4.6-9.8,4.1-15.4c1.5,5.5,4.5,9.9,9.1,13.1c4.6,3.2,9.8,4.5,15.5,3.9c-5.5,1.4-10,4.4-13.2,9.1c-3.3,4.6-4.5,9.8-4,15.5 c-1.4-5.5-4.4-10-9.1-13.2c-4.7-3.3-9.9-4.5-15.6-3.9C101,59.4,105.5,56.5,108.7,51.9z M60.5,119.8c0.1-2.5,0.7-4.8,1.7-7.1 c1.8-3.9,4.8-6.8,8.6-8.7c2.3-1.2,4.7-1.9,7.2-2.4c2.5-0.5,5-0.9,7.6-1.2c2.2-0.2,4.3-0.5,6.5-0.7c0.1,0,0.2,0,0.3-0.1 c0-0.1,0-0.2,0-0.3c0-1.5,0-3,0-4.5c0-0.8-0.1-1.5-0.3-2.3c-0.6-2.4-2.1-4-4.5-4.6c-2.6-0.7-5-0.4-7.4,0.8c-2.1,1.1-3.4,3-3.9,5.3 c-0.1,0.5-0.3,0.9-0.6,1.3c-0.4,0.5-0.9,0.8-1.7,0.7c-2.2-0.2-4.4-0.5-6.6-0.7c-1.1-0.1-2.2-0.2-3.2-0.4c-0.3,0-0.6-0.1-0.8-0.2 c-0.9-0.4-1.3-1.1-1.1-2.1c0.7-3.5,2.1-6.7,4.5-9.3c2.1-2.3,4.6-4,7.5-5.1c2.4-1,4.9-1.6,7.5-1.9c2-0.3,4.1-0.4,6.1-0.3 c3.9,0.2,7.7,0.9,11.3,2.7c2.7,1.4,5,3.3,6.5,6c1,1.7,1.5,3.6,1.8,5.6c0.3,2.3,0.4,4.5,0.4,6.8c0,6.6,0,13.1,0,19.7 c0,1.6,0.2,3.2,0.7,4.8c0.4,1.2,1.1,2.3,1.8,3.4c0.5,0.7,1,1.3,1.5,2c0.2,0.3,0.4,0.7,0.6,1.1c0.3,0.8,0.1,1.5-0.6,2 c-1.6,1.3-3.2,2.7-4.8,4.1c-1.1,0.9-2.1,1.9-3.2,2.8c-0.4,0.4-0.9,0.7-1.4,0.7c-0.7,0.1-1.2-0.1-1.8-0.5c-1.9-1.6-3.5-3.4-4.9-5.4 c-0.3-0.5-0.7-1-1-1.5c-0.6,0.5-1.1,1.1-1.6,1.6c-1.6,1.5-3.3,2.9-5.3,4c-2.1,1.2-4.4,1.8-6.9,2.1c-1.8,0.2-3.6,0.3-5.5,0.2 c-2.2-0.1-4.4-0.6-6.5-1.6c-3.9-1.9-6.4-5-7.7-9.2C60.6,124.9,60.4,122.4,60.5,119.8z M117.6,146.3c-0.1,0.3-0.3,0.5-0.5,0.7 c-1.9,1.9-4,3.5-6.3,4.9c-4.7,2.8-9.7,4.8-15,6c-3.5,0.8-7,1.3-9.7,1.2c-7.7-0.1-14.2-1.7-20.3-4.5c-5.3-2.5-10.2-5.8-14.5-9.7 c-1.2-1.1-2.4-2.3-3.6-3.5c-0.2-0.2-0.3-0.4-0.4-0.6c-0.1-0.3,0-0.7,0.2-0.9c0.3-0.2,0.6-0.2,0.9,0c0.1,0.1,0.2,0.1,0.3,0.2 c7.7,5.1,16.2,8.6,25.3,10.4c5.1,1,10.2,1.4,15.4,1.2c7.3-0.3,14.3-1.9,21.1-4.5c1.7-0.7,3.4-1.5,5.2-2.2c0.2-0.1,0.3-0.2,0.5-0.2 c0.5-0.1,0.9-0.1,1.3,0.3C117.7,145.4,117.8,145.8,117.6,146.3z M123.3,147.4c-0.6,1.6-1.5,3-2.6,4.3c-0.2,0.2-0.4,0.4-0.6,0.5 c-0.3,0.2-0.6,0.2-0.7,0.1c-0.2-0.2-0.2-0.4-0.1-0.7c0.3-0.8,0.5-1.6,0.8-2.4c0.4-1.5,0.9-3,1.1-4.5c0.1-0.7,0.2-1.4,0.1-2.1 c-0.1-0.6-0.4-1-1-1.1c-0.8-0.2-1.6-0.2-2.4-0.2c-2,0.1-4,0.4-6,0.8c-0.3,0.1-0.6,0.1-0.9,0.1c-0.2,0-0.4,0-0.5-0.2 c-0.1-0.2-0.1-0.4,0.1-0.5c0.2-0.2,0.3-0.4,0.5-0.5c1.3-1,2.8-1.6,4.4-2.1c1.6-0.4,3.2-0.6,4.9-0.7c0.9,0.1,1.9,0.2,2.8,0.4 c1.2,0.2,1.5,0.6,1.6,1.8C124.7,142.7,124.2,145.1,123.3,147.4z M134.4,88.8c-1.6-4.3-4.7-6.5-9.3-6.5c4.4-1.7,6.5-4.8,6.5-9.4 c1.5,4.4,4.7,6.6,9.4,6.6C136.7,81,134.5,84.1,134.4,88.8z M157.9,62.6c-0.9,0.4-1.7,0.9-2.5,1.5c-0.8,0.6-1.5,1.3-2.2,2 c-0.6,0.7-1.2,1.5-1.7,2.4c-0.5,0.9-0.9,1.8-1.2,2.7c-0.3,0.9-0.5,1.9-0.6,2.9c-0.1,1-0.1,2-0.1,3c-0.9-3.5-2.8-6.2-5.8-8.3 c-2.9-2-6.2-2.9-9.8-2.6c3.5-1,6.3-2.9,8.4-5.8c2.1-3,2.9-6.3,2.5-10c1.6,6.7,8.1,11.8,15.6,11.1C159.7,61.9,158.8,62.2,157.9,62.6 z" fill="#444444" />
						<path class="social-icon-fill SocialIconFill" d="M146.4,58.2c0,3.3-1.6,5.5-4.7,6.7c3.2,0,5.4,1.5,6.6,4.6c0.1-3.3,1.6-5.4,4.7-6.6 C149.7,62.9,147.5,61.3,146.4,58.2z" fill="#444444" />
					</g>
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'stumbleupon_url', '' ) !== '' ) : ?>
			<a class="contact-link StumbleUpon" href="<?php echo esc_url( get_theme_mod( 'stumbleupon_url', '' ) ); ?>" rel="me" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?>>
				<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve">
					<ellipse cx="65" cy="8.5" rx="117" ry="100.5" style="display:none;fill:#BC3939;" />
					<path class="social-icon-fill SocialIconFill" d="M99.8,0C44.5,0-0.2,44.8-0.2,100c0,55.2,44.8,100,100,100s100-44.8,100-100C199.8,44.8,155,0,99.8,0z M102.3,74.2c-3.7,0-6.7,3-6.7,6.7l0,40.3C95.3,136.6,82.8,149,67.4,149c-15.6,0-28.2-12.6-28.2-28.2c0-0.2,0-17.5,0-17.5h21.6v17.3 c0,3.7,3,6.7,6.7,6.7c3.7,0,6.7-3,6.7-6.7V79.7c0.5-15.1,12.9-27.2,28.2-27.2c15.3,0,27.7,12.2,28.2,27.4v8.9l-12.9,3.8l-8.6-4v-7.8 C109,77.2,106,74.2,102.3,74.2z M165.4,120.8c0,15.6-12.6,28.2-28.2,28.2c-15.5,0-28.1-12.5-28.2-28v-17.6l8.6,4l12.9-3.8v17.7 c0,3.7,3,6.7,6.7,6.7c3.7,0,6.7-3,6.7-6.7v-18.1h21.6C165.4,103.2,165.4,120.6,165.4,120.8z" fill="#444444" />
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'google_scholar_url', '' ) !== '' ) : ?>
			<a class="contact-link GoogleScholar" href="<?php echo esc_url( get_theme_mod( 'google_scholar_url', '' ) ); ?>" rel="me" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?>>
				<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve">
					<ellipse cx="65" cy="8.5" rx="117" ry="100.5" style="display:none;fill:#BC3939;" />
					<g>
						<path class="social-icon-fill SocialIconFill" d="M93.2,54.4c-5.2,1.7-8.2,5.4-8.8,10.7c-1.1,9.2,1.1,17.5,7,24.7c2.2,2.6,4.9,4.4,8.4,5 c8.8,1.5,15.4-4.8,15.4-16.1c-0.5-6.9-2.6-14.7-8.8-20.8C102.7,54,98.3,52.7,93.2,54.4z" fill="#444444" />
						<path class="social-icon-fill SocialIconFill" d="M99.8,0C44.5,0-0.2,44.8-0.2,100c0,55.2,44.8,100,100,100s100-44.8,100-100C199.8,44.8,155,0,99.8,0z M147.4,44.5c-1.4,1.2-2,2.5-1.8,4.3c0.3,2.8-0.8,5.9,2,8.2c0.6,0.5,0.6,2,0.6,3c0,10.8,0,21.7,0,32.5c0,3.3-1.7,5.2-4.3,5.2 c-2.5-0.1-4.1-2-4.1-5.1c0-10.9,0-21.8,0-32.8c0-1,0.4-2,0.7-3c0.6-1.9,1.3-3.9,1.9-5.8c-0.3-0.2-0.6-0.3-0.9-0.5 c-1.4,1.4-2.8,2.7-4.2,4.1c-3,3-6.1,6-9,9.1c-0.7,0.7-1.1,2.2-0.9,3.1c2.5,10,0,18.3-7.9,24.9c-2,1.7-4,3.4-5.7,5.3 c-2.6,3.1-2.4,6.3,0.6,9c3.7,3.4,7.6,6.4,11.3,9.7c12,10.5,8.8,26.4-1.6,34.9c-6.7,5.5-14.6,8.1-23.1,8.9 c-8.5,0.7-16.9,0.3-24.9-3.3c-8.3-3.8-13.1-10.7-12.4-18.6c0.6-6.9,4-12.1,9.7-16c7.4-4.9,15.8-6.3,24.4-7.2c1-0.1,2.1-0.2,3.1-0.3 c0.1,0,0.3-0.2,0.8-0.6c-3.4-4.2-4.6-8.8-2.7-14.3C82.1,99.8,72,92.5,70.7,74.7c-7.3,0-14.9,0-23,0c0.8-0.9,1.2-1.4,1.7-1.9 c10.4-10.4,20.9-20.9,31.4-31.3c0.8-0.8,2.2-1.5,3.3-1.5c22-0.1,44-0.1,66-0.1c0.3,0,0.7,0,1.6,0.1 C150.1,41.8,148.9,43.3,147.4,44.5z" fill="#444444" />
						<path class="social-icon-fill SocialIconFill" d="M105.8,118.7c-7,0-13.8,0.7-20.1,3.9c-5.3,2.7-8.8,6.8-8.9,11.4c-0.1,8.4,3.4,13,9,15.9 c8.5,4.4,17.5,5,26.4,2.1c11.3-3.6,14.6-15.6,6.6-24.1c-3.2-3.3-7.1-5.8-10.8-8.7C107.5,118.8,106.6,118.7,105.8,118.7z" fill="#444444" />
					</g>
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'my_ncbi_bibliography_url', '' ) !== '' ) : ?>
			<a class="contact-link MyNCBIBibliography" href="<?php echo esc_url( get_theme_mod( 'my_ncbi_bibliography_url', '' ) ); ?>" rel="me" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?>>
				<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 200 200" style="enable-background:new 0 0 200 200;" xml:space="preserve">
					<ellipse cx="65" cy="8.5" rx="117" ry="100.5" style="display:none;fill:#BC3939;" />
					<circle class="social-icon-fill SocialIconFill" cx="100" cy="99.7" r="100" fill="#444444" />
					<g>
						<path d="M77.8,84.9c5.4-1.8,11.2-2.3,16.8-3.5c9.5-2,19.1-3.8,28.5-6.4c3.5-0.9,6.7-3.4,9.6-5.8c2.8-2.3,4-5.8,1.6-9.1 c-4.7-6.8-11.9-9.8-19.9-13c4.4,3.5,8.4,6.2,11.8,9.5c3.3,3.4,2.5,7.2-1.9,9.1c-3.2,1.4-6.6,2.4-10,3c-8.8,1.5-17.8,2.4-26.6,4.1 c-7,1.4-14,3.4-19.5,8.5c-3.6,3.3-4,6.8-0.6,9.8c4.7,4.1,10.1,7.4,15.1,11c0.3-0.4,0.5-0.7,0.8-1.1c-2.5-1.9-5.2-3.7-7.6-5.8 C71,90.7,71.5,86.9,77.8,84.9z" style="fill:#FFFFFF;" />
						<path d="M68.1,55.7c5.3,4.2,11.3,7.5,16.9,11.2c0.3-0.4,0.5-0.8,0.8-1.2c-2.6-1.7-5.2-3.2-7.7-5.1 c-2.7-2.1-6.3-4.6-4.9-8c1-2.4,4.7-4.5,7.5-5.2c5.6-1.4,11.5-1.7,17.3-2.6c1.2-0.2,3.3-0.9,3.4-1.6c0.4-3,0.2-6.1,0.2-10 c-7.4,1.7-14.1,2.8-20.5,4.7c-4.4,1.4-8.7,3.5-12.5,6.1C63.7,47.4,63.4,52.1,68.1,55.7z" style="fill:#FFFFFF;" />
						<path d="M118.6,105.4c-5.5,1.1-11.1,1.6-16.6,2.6c-1.1,0.2-2.9,1.2-3.1,2c-0.4,2.8-0.1,5.8-0.1,8.9 c3.6-0.6,6.4-0.9,9.2-1.5c8.1-1.7,16.1-3.6,22.8-8.7c5.4-4,5.8-8.9,1.2-13.5c-5-4.9-11.3-7.7-17.9-9.7c2.5,1.5,5,2.9,7.4,4.7 c3.1,2.3,6.8,4.9,6,9.3C126.7,103.8,122.3,104.7,118.6,105.4z" style="fill:#FFFFFF;" />
						<path d="M75.7,157.6c-0.4,0.1-0.7,0.3-1.1,0.4c-5-6.1-10-12.2-14.9-18.4c-3.4-4.4-3.6-4.6-8.4-3.4 c4.2,9.8,0.4,19.6,0.3,29.4c1.7,0,3.5,0,5,0c0-7.5,0-14.5,0-22c6.7,7.8,12.6,15.6,19.6,22.5c0.4-0.2,0.8-0.5,1.2-0.7 c0.7-9.8,1.4-19.5,2.1-29.4c-1.7,0-3.6,0-4.8,0C75.1,143.3,75.4,150.5,75.7,157.6z" style="fill:#FFFFFF;" />
						<path d="M133.1,150.1c-0.8-0.5-1.7-0.8-2.8-1.3c0.8-0.8,1.3-1.4,1.9-1.9c2.1-2.3,3.2-4.8,1.9-7.8 c-1.3-3.1-4.1-3.9-7.1-3.8c-3.9,0.1-7.9,0.5-11.3,0.7c0,10,0,19.6,0,29.7c3,0.2,6.5,0.9,9.7,0.4c3.2-0.5,6.6-1.7,9.1-3.7 C138.7,158.9,137.7,152.8,133.1,150.1z M123.7,137.9c3.7-0.1,6,2,5.9,5.5c-0.1,4.2-2.3,5.5-8.5,4.8 C120.1,140.4,120.7,138,123.7,137.9z M132,159.4c-0.4,3.5-2.6,4.2-5.5,4c-2.7-0.2-5.7-0.1-5.6-4.2c0.1-2.5,0-4.9,0-7.6 C128.5,150.1,132.7,153.2,132,159.4z" style="fill:#FFFFFF;" />
						<path d="M92.8,158.2c-3.2-3.5-4-12.5-1.1-16.6c1-1.4,3-2.6,4.7-2.8c4.5-0.7,9-0.4,11.9,5c0.6-3.1,1-5.2,1.4-7.5 c-1.3-0.3-2.4-0.7-3.6-0.9c-6.7-0.7-13.1-0.3-17.7,5.6c-3.9,5-4.4,10.8-1.9,16.6c2.5,6,7.5,8,13.7,8.6c5.3,0.5,7.4-3,10.5-7.1 c-1.6,0.4-2.4,0.5-3,0.8C102,162.5,96,161.7,92.8,158.2z" style="fill:#FFFFFF;" />
						<path d="M143.1,136c0,10,0,19.7,0,29.6c1.8,0,3.9,0,5.5,0c0-10.1,0-19.9,0-29.6C146.9,136,144.7,136,143.1,136z" style="fill:#FFFFFF;" />
					</g>
				</svg>
			</a>
		<?php endif; ?>

		<?php if ( get_theme_mod( 'keybase_username', '' ) !== '' ) : ?>
			<a class="contact-link KeyBaseLink" href="https://keybase.io/<?php echo esc_attr( get_theme_mod( 'keybase_username', '' ) ); ?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?>>
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg"> <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd"> <path class="social-icon-fill SocialIconFill" d="m100 0c-39.323-0.5461-77.245 24.729-92.141 61.076-15.551 35.707-7.5052 80.064 19.754 107.91 26.228 28.23 69.437 38.53 105.62 25.36 37.5-12.74 65.15-49.58 66.64-89.2 2.49-38.519-19.83-77.018-54.34-94.211-14.02-7.2041-29.77-10.963-45.53-10.939zm1.15 67c3.52 0.084 7.02 0.624 10.21 1.453 9.38 2.495 13.32 12.117 12.94 20.344h-14.81c-0.12-3.513-1.01-7.405-4.02-9.83-6.291-5.094-13.998 1.787-14.14 8.064-1.735 10.935-1.668 22.239 0.508 33.119 0.596 5.83 7.962 10.75 13.592 6.62 6.03-3.71 4.81-10.76 4.91-16.5h-10.19v-10.21h25.01v37.08h-7.28c-2.47 0.15-5.13 0.48-4.1-2.59 0.98-6.84-2.43-0.08-6 1.55-7.43 3.24-17.135 2.92-23.997-1.37-8.273-6.41-8.374-17.2-8.957-26.32-0.035-11.275-1.018-23.767 6.135-33.592 4.65-5.982 12.453-8.002 20.189-7.818zm-55.777 0.088c6.94 0.053 14.177 1.817 18.174 7.432 5.617 8.448 5.716 20.577-1.225 28.43-6.895 7.16-17.885 6.55-27.386 6.5v28.09h-15.459v-70.376h22.951c0.969-0.056 1.954-0.084 2.945-0.076zm115.74 0c6.94 0.053 14.17 1.817 18.17 7.432 5.62 8.448 5.72 20.577-1.23 28.43-6.89 7.16-17.88 6.55-27.38 6.5v28.09h-15.46v-70.376h22.95c0.97-0.056 1.95-0.084 2.95-0.076zm-121.81 10.502c-1.507 0.016-2.994 0.067-4.365 0.021v21.387c3.349-0.101 6.777 0.271 10.074-0.361 7.734-1.813 8.464-11.072 5.711-16.727-2.212-4.102-6.9-4.367-11.42-4.32zm115.73 0c-1.5 0.016-2.99 0.067-4.36 0.021v21.387c3.35-0.101 6.78 0.271 10.07-0.361 7.74-1.813 8.47-11.072 5.72-16.727-2.22-4.102-6.91-4.367-11.43-4.32z" fill="#444444"></path> </g> </svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'show_rss_icon', false ) == true ) : ?>
			<a class="contact-link RSSLink" href="<?php bloginfo( 'rss2_url' ); ?>">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100,0 C155.228476,-3.41060513e-14 200,44.771524 200,100 C200,155.228476 155.228476,200 100,200 C44.771524,200 0,155.228476 0,100 C0,44.771524 44.771524,3.03201907e-14 100,0 Z M40.0135555,79.4855784 L40.0135555,102.780614 C55.2214198,102.790103 69.6051125,108.763989 80.3694989,119.544636 C91.1311742,130.291394 97.0806631,144.696768 97.1050629,159.95749 L97.1131962,159.95749 L97.1131962,159.999512 L120.504488,159.999512 C120.485511,137.809245 111.465711,117.709228 96.8827535,103.115434 C82.2970845,88.5243505 62.2051899,79.4991339 40.0135555,79.4855784 Z M44.7525423,155.112773 L44.7471201,155.112773 L44.7525423,155.118195 L44.7525423,155.112773 C47.7008537,158.048883 51.7200459,159.849046 56.1947014,159.849046 C60.6747791,159.849046 64.7034602,158.054305 67.6531271,155.118195 L67.6639714,155.112773 C70.6082161,152.172597 72.4056694,148.168318 72.4165138,143.718064 C72.4056694,139.259678 70.6082161,135.255399 67.6531271,132.304378 L67.6585492,132.304378 L67.6531271,132.300311 L67.6531271,132.304378 C64.6993935,129.369624 60.6747791,127.55726 56.1947014,127.55726 C51.7214015,127.55726 47.7022092,129.365557 44.7525423,132.304378 L44.7525423,132.300311 C41.8110087,135.24591 40,139.259678 40,143.718064 C40,148.17374 41.8110087,152.173952 44.7525423,155.112773 Z M40.0555774,62.9029686 C93.5271714,62.9416349 136.994841,106.477281 137.030841,159.999512 L160,159.999512 C159.984,126.919781 146.538769,96.9493582 124.809601,75.2055351 C103.073766,53.4683787 73.1233263,40.0151548 40.0555774,40.0004883 Z M40.0555774,62.9029686" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'email_address', '' ) !== '' ) : ?>
			<a class="contact-link EmailLink" href="<?php echo esc_url( 'mailto:' . antispambot( get_theme_mod( 'email_address' ), 1 ) );?>">
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M47.525,58.4312 C44.0017303,58.4312 40.8759923,60.0775002 38.8740909,62.6461034 L99.75,94.8175812 L163.968171,60.8797969 C162.084984,59.347607 159.678721,58.4312 157.05,58.4312 Z M36.8768341,66.781991 C36.6754591,67.614632 36.5688,68.4849911 36.5688,69.3812 L36.5688,129.6188 C36.5688,135.6864 41.4574,140.5688 47.525,140.5688 L157.05,140.5688 C163.1176,140.5688 168,135.6864 168,129.6188 L168,69.3812 C168,67.6380936 167.597054,65.9928022 166.878815,64.5329757 L99.7671275,100 L99.75,99.9564542 L99.7328725,100 Z M100,0 C155.2286,0 200,44.7714 200,100 C200,155.2286 155.2286,200 100,200 C44.7714,200 0,155.2286 0,100 C0,44.7714 44.7714,0 100,0 Z M173,61.2980665 L171.309648,57 Z M173,61.2980665" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		
		<?php if ( get_theme_mod( 'website_link', '' ) !== '' ) : ?>
			<a class="contact-link WebsiteLink" href="<?php echo esc_url( get_theme_mod( 'website_link' ) );?>" <?php if ( get_theme_mod( 'open_links_in_new_tab', false ) == true ) echo 'target="_blank"'; ?> >
				<svg width="200px" height="200px" viewBox="0 0 200 200" version="1.1" xmlns="http://www.w3.org/2000/svg">
					<g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
					<path class="social-icon-fill SocialIconFill" d="M100.201055,0 C155.540432,0 200.402109,44.8616775 200.402109,100.201055 C200.402109,155.540432 155.540432,200.402109 100.201055,200.402109 C44.8616775,200.402109 0,155.540432 0,100.201055 C0,44.8616775 44.8616775,0 100.201055,0 Z M10.3298172,100.210406 C10.3298172,126.647308 21.764832,150.41805 39.9673927,166.864419 L32.8424879,152.640954 C25.3384223,152.640954 21.5861525,135.7887 21.5861525,128.298284 C21.5861525,122.287597 19.1694766,117.482736 22.093754,111.947946 C11.5061635,101.334394 17.8338828,107.088684 17.8338828,100.210406 C17.8338828,96.6449605 14.4328107,93.0790417 10.8686995,90.3215808 C10.5122883,93.5691309 10.3298172,96.8682443 10.3298172,100.210406 Z M100.3805,10.3291965 C95.8253571,10.3291965 91.3488903,10.6669606 86.9752708,11.3183629 C86.0392177,13.3529896 85.3718947,15.5863011 85.3718947,17.8191396 C85.3718947,25.3095558 77.8678292,10.3291965 70.3637636,25.3095558 C62.8592241,40.289442 70.3637636,25.3095558 70.3637636,40.289442 C70.3637636,47.7798582 59.5031773,42.3600213 62.8592241,44.0346501 C70.3637636,47.7798582 70.3637636,47.7798582 62.8592241,55.2698013 C62.8592241,55.2698013 47.8510929,47.7798582 47.8510929,55.2698013 C47.8510929,62.7597444 40.3465534,62.7597444 32.8424879,62.7597444 C25.3384223,62.7597444 32.8424879,77.7401037 25.3384223,77.7401037 C19.5685433,77.7401037 22.6710263,68.8839662 17.5916938,64.7905867 C15.6608176,69.2808627 14.0858786,73.9594162 12.902423,78.7912408 C17.9599537,83.3141579 18.8069041,101.181596 25.3384223,107.700822 C32.8424879,100.210406 32.8424879,107.700822 40.3465534,107.700822 C47.8510929,107.700822 47.8510929,107.700822 51.6028888,115.190765 C59.1074283,115.190765 62.8592241,122.680709 70.3637636,130.170652 C77.8678292,137.661068 92.8759603,137.661068 92.8759603,145.151011 C92.8759603,152.640954 85.3718947,145.151011 85.3718947,160.13137 C85.3718947,167.621313 85.3718947,167.621313 77.8678292,167.621313 C73.143012,167.621313 68.417721,176.529487 65.565958,183.128187 C76.2763018,187.61326 88.0383428,190.091616 100.3805,190.091616 C125.584738,190.091616 148.370404,179.756696 164.715551,163.100762 L160.413972,154.513795 C160.413972,154.513795 169.79441,139.533435 162.290344,132.043492 C154.785805,124.553549 154.785805,117.063133 154.785805,117.063133 C154.785805,117.063133 139.777673,132.043492 132.273134,124.553076 C124.769068,117.063133 124.769068,124.553076 117.265003,109.57319 C109.760463,94.5928305 124.769068,87.1028874 124.769068,87.1028874 C124.769068,87.1028874 124.769068,72.1225281 132.273134,72.1225281 C139.777673,72.1225281 147.281739,57.1426419 162.290344,72.1225281 C162.290344,72.1225281 170.963173,66.3516814 183.233763,64.9410195 C179.384807,55.9453296 174.108785,47.7036957 167.68912,40.4994802 C166.341203,41.4668859 164.577158,42.1622826 162.290344,42.1622826 C154.785805,42.1622826 169.79441,57.1426419 162.290344,57.1426419 C154.785805,57.1426419 154.785805,49.6522257 147.281739,49.6522257 C139.777673,49.6522257 139.777673,57.1426419 132.273134,64.632585 C124.769068,72.1225281 132.273134,64.632585 124.769068,57.1426419 C117.265003,49.6522257 139.777673,57.1426419 132.273134,49.6522257 C124.769068,42.1622826 139.777673,42.1622826 139.777673,34.6723395 C139.777673,28.7974198 149.010238,27.5305678 152.992848,27.2571397 C148.661884,24.1401539 144.042758,21.3978309 139.777673,19.6919802 C147.281739,27.1819233 132.273134,34.6723395 124.769068,34.6723395 C117.719996,34.6723395 123.913587,21.454598 124.69134,13.6429748 C116.957883,11.4839335 108.80403,10.3291965 100.3805,10.3291965 Z" fill="#444444"></path>
					</g>
				</svg>
			</a>
		<?php endif; ?>
		<?php decode_social_icons_last(); ?>
	</div>
</div><!-- .contact-links -->