<?php
/*
Plugin Name: Display URL Params
Plugin URI: https://feel.com.au/plugins
Description: Use the [URLParam param='paramname'] shortcode to display GET parameters from the current URL in your pages and posts.
Author: Feel Creative
Version: 1.1
Author URI: https://feel.com.au
License: GPL2
*/

/* [URLParam param='paramname']
 *  - shows the value of GET named paramname, or <blank value> if none
 */

 function FeelDUP_Display( $atts ) {
     extract( shortcode_atts( array(
         'param' => 'param',
     ), $atts ) );
     return esc_attr(esc_html($_GET[$param]));
 }
 add_shortcode('URLParam', 'FeelDUP_Display');
