/*
 * Decompiled with CFR 0.152.
 */
package JUpload.gui;

import JUpload.Messages;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StatPanel
extends JPanel {
    private JLabel statBytesLabel;
    private JLabel statBytesValue;
    private JLabel statFilesLabel;
    private JLabel statFilesValue;
    private JPanel statFiles;
    private JPanel statBytes;

    public StatPanel() {
        Debug.println(this, "StatPanel() initialized");
        BoxLayout bl = new BoxLayout(this, 1);
        this.setLayout(bl);
        this.createFields();
        this.setVisible(true);
        this.doLayout();
    }

    public void updateColor() {
        this.statFiles.setOpaque(false);
        this.statBytes.setOpaque(false);
    }

    public void updateModel(DefaultListModel tModel) {
        this.statFilesLabel.setVisible(true);
        this.statBytesLabel.setVisible(true);
        long totalSize = 0L;
        long size = tModel.size();
        int i = 0;
        while ((long)i < size) {
            MyFile f = (MyFile)tModel.getElementAt(i);
            totalSize += f.length();
            ++i;
        }
        this.setFiles(tModel.size());
        this.setBytes(totalSize);
        this.getParent().validate();
    }

    private void setBytes(long i) {
        double size = i;
        String description = Messages.getString("StatPanel.1");
        String output = null;
        if (size > 1024.0) {
            size /= 1024.0;
            description = Messages.getString("StatPanel.2");
            if (size > 1.0) {
                description = Messages.getString("StatPanel.3");
            }
        }
        if (size > 1024.0) {
            size /= 1024.0;
            description = Messages.getString("StatPanel.4");
            if (size > 1.0) {
                description = Messages.getString("StatPanel.5");
            }
        }
        DecimalFormat myFormatter = new DecimalFormat(Messages.getString("StatPanel.6"));
        output = myFormatter.format(size);
        this.statBytesValue.setText(output + " " + description);
    }

    private void setFiles(long i) {
        this.statFilesValue.setText(Long.toString(i));
        if (i == 0L) {
            this.setVisible(false);
        } else {
            this.setVisible(true);
        }
    }

    private void createFields() {
        this.statFiles = new JPanel();
        this.statFiles.setLayout(new GridLayout(1, 2));
        this.statFilesLabel = new JLabel(Configurator.getLabelFiles());
        this.statFilesValue = new JLabel();
        this.statBytes = new JPanel();
        this.statBytes.setLayout(new GridLayout(1, 2));
        this.statBytesLabel = new JLabel(Configurator.getLabelBytes());
        this.statBytesValue = new JLabel();
        this.statFilesLabel.setVisible(false);
        this.statBytesLabel.setVisible(false);
        this.updateColor();
        this.statFiles.add(this.statFilesLabel);
        this.statFiles.add(this.statFilesValue);
        this.statBytes.add(this.statBytesLabel);
        this.statBytes.add(this.statBytesValue);
        this.add(this.statFiles);
        this.add(Box.createRigidArea(new Dimension(0, 5)));
        this.add(this.statBytes);
        this.add(Box.createRigidArea(new Dimension(0, 10)));
    }

    public void doResize() {
        int width = this.getWidth();
        this.statBytesLabel.setSize(new Dimension(width, this.statBytesLabel.getHeight()));
        this.statBytesValue.setSize(new Dimension(width, this.statBytesValue.getHeight()));
        this.statFilesLabel.setSize(new Dimension(width, this.statFilesLabel.getHeight()));
        this.statFilesValue.setSize(new Dimension(width, this.statFilesValue.getHeight()));
    }
}

