/*
 * Decompiled with CFR 0.152.
 */
package JUpload.security;

import JUpload.Messages;
import JUpload.gui.UploadStatus;
import JUpload.swingVersion.JUpload;
import JUpload.utilities.MyFile;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPEncryptedOutputStream
extends OutputStream {
    private static final Logger logger = Logger.getLogger((class$JUpload$security$PGPEncryptedOutputStream == null ? (class$JUpload$security$PGPEncryptedOutputStream = PGPEncryptedOutputStream.class$("JUpload.security.PGPEncryptedOutputStream")) : class$JUpload$security$PGPEncryptedOutputStream).getName());
    private ByteArrayOutputStream sendBuffer = new ByteArrayOutputStream();
    private final OutputStream pOut;
    private final URL targetURL;
    private int CURRENT_OFFSET = 0;
    private PGPCompressedDataGenerator comData;
    private PGPEncryptedDataGenerator cPk;
    private PGPLiteralDataGenerator lData;
    private OutputStream cOut;
    private byte[] minibuffer = new byte[65536];
    private int counter = 0;
    private OutputStream armoredBuffer;
    private UploadStatus status;
    private long FILE_TOTAL_SIZE;
    private long FILE_TOTAL_READ;
    private final MyFile file;
    static /* synthetic */ Class class$JUpload$security$PGPEncryptedOutputStream;

    public PGPEncryptedOutputStream(UploadStatus status, MyFile file, URL publicKeyURL, URL baseTargetURL) throws Exception {
        this.status = status;
        this.file = file;
        String safeFilename = URLEncoder.encode(file.getRelativeFilename(), "UTF-8");
        this.targetURL = new URL(baseTargetURL, safeFilename);
        PGPPublicKey encKey = this.readPublicKey(publicKeyURL.openStream());
        this.cPk = new PGPEncryptedDataGenerator(3, true, new SecureRandom(), "BC");
        this.cPk.addMethod(encKey);
        this.armoredBuffer = new ArmoredOutputStream((OutputStream)this.sendBuffer);
        logger.log(Level.FINE, "Size of buffer:" + this.minibuffer.length);
        this.FILE_TOTAL_SIZE = file.length();
        status.setFilename(file.getName());
        status.setValue(0L, this.FILE_TOTAL_SIZE);
        status.setProgressbarVisible(true);
        this.cOut = this.cPk.open(this.armoredBuffer, new byte[65536]);
        this.lData = new PGPLiteralDataGenerator();
        this.comData = new PGPCompressedDataGenerator(1);
        this.pOut = this.lData.open(this.comData.open(this.cOut), 'b', file.getName(), new Date(file.lastModified()), new byte[65536]);
    }

    private PGPPublicKey readPublicKey(InputStream in) throws IOException, PGPException {
        in = PGPUtil.getDecoderStream((InputStream)in);
        PGPPublicKeyRingCollection pgpPub = new PGPPublicKeyRingCollection(in);
        PGPPublicKey key = null;
        Iterator rIt = pgpPub.getKeyRings();
        while (key == null && rIt.hasNext()) {
            PGPPublicKeyRing kRing = (PGPPublicKeyRing)rIt.next();
            Iterator kIt = kRing.getPublicKeys();
            while (key == null && kIt.hasNext()) {
                PGPPublicKey k = (PGPPublicKey)kIt.next();
                if (!k.isEncryptionKey()) continue;
                key = k;
                logger.log(Level.FINE, "Using public key:" + key.getUserIDs().next());
            }
        }
        if (key == null) {
            throw new IllegalArgumentException(Messages.getString("PGPEncryptedOutputStream.CantFindPublicKey"));
        }
        return key;
    }

    public void write(int b) throws IOException {
        this.minibuffer[this.counter] = (byte)b;
        ++this.counter;
        if (this.counter >= this.minibuffer.length) {
            this.pOut.write(this.minibuffer);
            this.counter = 0;
        }
        ++this.FILE_TOTAL_READ;
    }

    private void processMinibuffer() throws IOException {
        logger.log(Level.FINE, "writing minibuffer bytes:" + this.counter);
        this.pOut.write(this.minibuffer, 0, this.counter);
        this.counter = 0;
    }

    public void flush() throws IOException {
        String str;
        logger.log(Level.FINE, "flush()");
        byte[] data = this.sendBuffer.toByteArray();
        this.sendBuffer.reset();
        HttpURLConnection conn = (HttpURLConnection)this.targetURL.openConnection();
        conn.setRequestMethod("HEAD");
        int remoteSize = conn.getContentLength();
        if (remoteSize > 0 && this.CURRENT_OFFSET + data.length < remoteSize) {
            logger.log(Level.FINE, "Remote file exists, skipping " + data.length + " bytes");
            this.CURRENT_OFFSET += data.length;
            this.status.setMessage(Messages.getString("PGPEncryptedOutputStream.SeekingFilePosition") + this.CURRENT_OFFSET);
            this.status.setValue(this.CURRENT_OFFSET, this.FILE_TOTAL_SIZE);
            return;
        }
        conn.disconnect();
        conn = (HttpURLConnection)this.targetURL.openConnection();
        conn.setDefaultUseCaches(false);
        conn.setUseCaches(false);
        conn.setAllowUserInteraction(false);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Host", "jupload.biz");
        conn.setRequestProperty("Content-Length", "" + data.length);
        int from = this.CURRENT_OFFSET;
        int to = this.CURRENT_OFFSET + data.length;
        int length = to - from;
        if (length == 0) {
            logger.log(Level.FINE, "0 bytes in buffer, omitting http request");
            return;
        }
        conn.setRequestProperty("Content-Range", "bytes " + from + "-" + to + "/" + length);
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        logger.log(Level.FINE, "flush() - writing data: " + data.length);
        conn.setDoInput(true);
        conn.setDoOutput(true);
        OutputStream urlOUT = null;
        int counter1 = 0;
        while (urlOUT == null && counter1++ < 5) {
            try {
                urlOUT = conn.getOutputStream();
            }
            catch (NullPointerException ex) {
                try {
                    Thread.sleep(15L);
                }
                catch (Exception e) {}
            }
        }
        this.status.setMessage(Messages.getString("PGPEncryptedOutputStream.SendingEncryptedData"));
        urlOUT.write(data);
        urlOUT.flush();
        urlOUT.close();
        this.CURRENT_OFFSET += data.length;
        logger.log(Level.FINE, "flush() - new offset: [" + this.CURRENT_OFFSET + "]");
        InputStream urlIN = conn.getInputStream();
        BufferedReader br = new BufferedReader(new InputStreamReader(urlIN));
        StringBuffer response = new StringBuffer();
        while ((str = br.readLine()) != null) {
            logger.log(Level.FINE, "Server: [" + str + "]");
            response.append(str);
        }
        JUpload.getInstance().serverResponse.addResponse(response.toString());
        this.status.setValue(this.FILE_TOTAL_READ, this.FILE_TOTAL_SIZE);
    }

    public void close() throws IOException {
        logger.log(Level.FINE, "close()");
        this.processMinibuffer();
        this.lData.close();
        this.sendBuffer.close();
        this.comData.close();
        this.cPk.close();
        this.armoredBuffer.close();
        this.flush();
        this.file.setUploaded(true);
        this.status.setProgressbarVisible(false);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

