/*
 * Decompiled with CFR 0.152.
 */
package JUpload.swingVersion;

import JUpload.Messages;
import JUpload.gui.UploadManager;
import JUpload.gui.UploadStatus;
import JUpload.http.HTTPPostRequest;
import JUpload.http.HTTPPutRequest;
import JUpload.http.HTTPRequest;
import JUpload.http.PgpEncryptedRequest;
import JUpload.startup;
import JUpload.swingVersion.JUpload;
import JUpload.swingVersion.UploadJob;
import JUpload.utilities.Configurator;
import JUpload.utilities.Debug;
import JUpload.utilities.MyFile;
import java.applet.AppletContext;
import java.util.Vector;
import javax.swing.JOptionPane;
import netscape.javascript.JSObject;

public class UploadThreadGenerator
extends Thread {
    private startup applet;
    AppletContext context;
    int fileSizes = 0;
    private HTTPRequest httprequest;
    String newline = "\r\n";
    JUpload parent;
    private UploadManager uploadmanager;
    private boolean threadSuspended;
    private UploadStatus myStatus;

    UploadThreadGenerator(startup t_applet, AppletContext t_context, HTTPRequest t_httprequest, JUpload t_parent, UploadManager t_uploadmanager) {
        this.applet = t_applet;
        this.context = t_context;
        this.httprequest = t_httprequest;
        this.parent = t_parent;
        this.uploadmanager = t_uploadmanager;
        this.threadSuspended = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            UploadThreadGenerator uploadThreadGenerator = this;
            synchronized (uploadThreadGenerator) {
                while (this.threadSuspended) {
                    try {
                        Debug.println(this, "Waiting for notification to generate upload jobs");
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.prepareUploadState();
                if (this.checkMaximumUploadSize()) {
                    this.generateUploadJobs();
                }
                this.threadSuspended = true;
            }
        }
    }

    private void prepareUploadState() {
        JSObject win;
        Debug.println(this, "myUploadListener() user pressed Uploadbutton");
        if (this.applet.javascriptUploadListenerRegistered && (win = this.applet.jsBrowserWindow) != null) {
            win.call(this.applet.javascriptUploadListenerName, null);
        }
        if (this.parent.getQueueSelectedFiles().size() == 0) {
            JOptionPane.showMessageDialog(this.parent, Messages.getString("myUploadListener.23"), Messages.getString("myUploadListener.24"), 0);
            this.parent.add.setEnabled(true);
            return;
        }
    }

    public void generateUploadJobs() {
        Debug.println(this, "generateUploadJobs();");
        this.myStatus = UploadStatus.getInstance();
        this.myStatus.setTotalProgressbarVisible(false);
        this.myStatus.setVisible(true);
        this.myStatus.start();
        this.myStatus.setMessage(Messages.getString("UploadThreadGenerator.0"));
        Vector<UploadJob> uploadJobs = new Vector<UploadJob>();
        int iNumberFiles = this.parent.getQueueSelectedFiles().size();
        for (int i = 0; i < iNumberFiles; ++i) {
            UploadJob job;
            this.myStatus.setMessage(Messages.getString("UploadThreadGenerator.1") + (i + 1) + Messages.getString("UploadThreadGenerator.2") + iNumberFiles);
            this.myStatus.setValue(i + 1, iNumberFiles);
            MyFile file = this.parent.getQueueSelectedFiles().getFileAt(i);
            Debug.println(this, i + ":" + file);
            boolean foundSlot = false;
            Debug.println(this, "There are " + uploadJobs.size() + " jobs,");
            for (int iJob = 0; iJob < uploadJobs.size(); ++iJob) {
                job = (UploadJob)uploadJobs.get(iJob);
                if (!job.hasSpaceFor(file)) continue;
                Debug.println(this, "Job " + iJob + " has room for file " + file);
                foundSlot = true;
                try {
                    job.addFile(file);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                file.setQueued(true);
                break;
            }
            if (foundSlot) continue;
            Debug.println(this, "Creating new job for file " + file);
            job = new UploadJob();
            uploadJobs.add(job);
            try {
                job.addFile(file);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            file.setQueued(true);
        }
        this.httprequest = Configurator.getUsePutMethod() ? (Configurator.getEncryptContent() ? new PgpEncryptedRequest(this.parent, uploadJobs) : new HTTPPutRequest(this.parent, uploadJobs)) : new HTTPPostRequest(this.parent, uploadJobs);
        this.httprequest.setActionURL(Configurator.getActionURL());
        this.httprequest.setMaxRetries(Configurator.getMaxRetries());
        this.parent.statpanel.updateModel(this.parent.getQueueSelectedFiles().getListModel());
        if (this.httprequest != null) {
            this.uploadmanager.addThread(this.httprequest);
        }
        this.myStatus.setMessage("");
    }

    private boolean checkMaximumUploadSize() {
        long totalSize = 0L;
        for (int i = 0; i < this.parent.getQueueSelectedFiles().getListModel().size(); ++i) {
            MyFile f = this.parent.getQueueSelectedFiles().getFileAt(i);
            if ((totalSize += f.length()) <= Configurator.getMaxFreeSpaceOnServer() || Configurator.getMaxFreeSpaceOnServer() == -1L) continue;
            String strMessage = Configurator.getMaxFreeSpaceOnServerWarning() + "\n" + f.getName() + "\n" + f.length() + Messages.getString("myUploadListener.22");
            String strTitle = Configurator.getMaxFreeSpaceOnServerTitle();
            JOptionPane.showMessageDialog(this.parent, strMessage, strTitle, 0);
            return false;
        }
        return true;
    }

    public synchronized void continueThread() {
        boolean bl = this.threadSuspended = !this.threadSuspended;
        if (!this.threadSuspended) {
            this.notify();
        }
    }
}

