/*
 * Decompiled with CFR 0.152.
 */
import JUpload.startup;
import JUpload.swingVersion.JUpload;
import JUpload.utilities.MyFile;
import java.applet.Applet;
import java.awt.Dimension;
import java.io.File;
import java.io.FileFilter;
import java.util.Vector;
import javax.swing.JApplet;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.filechooser.FileSystemView;

public class SimpleFileChooser
extends JPanel {
    private File currentFolder;
    private FileSystemView fsv;
    Explorer explorer;
    private JScrollPane scrollpane;
    private JApplet applet;
    private FileFilter filefilter;

    SimpleFileChooser(JApplet t_applet) {
        this.applet = t_applet;
        this.filefilter = null;
        this.setPreferredSize(new Dimension(t_applet.getSize()));
        this.fsv = FileSystemView.getFileSystemView();
        this.scrollpane = new JScrollPane();
        this.scrollpane.setPreferredSize(this.getPreferredSize());
        this.explorer = new Explorer();
        myMouseListener mouseListener = new myMouseListener(this);
        this.updateExplorer();
        this.explorer.addMouseListener(mouseListener);
        this.scrollpane.getViewport().setView(this.explorer.getView());
        this.add(this.scrollpane);
    }

    protected void sendFileToJUpload(File file) {
        Applet rawapplet = this.applet.getAppletContext().getApplet("JUpload");
        if (rawapplet == null) {
            return;
        }
        MyFile[] fileArray = new MyFile[]{new MyFile(file)};
        if (rawapplet instanceof startup) {
            startup j1 = (startup)rawapplet;
            JUpload j2 = j1.getJUpload();
            j2.walkFileTree(fileArray);
        }
    }

    protected void gotoFolder(File file) {
        if (file == null) {
            return;
        }
        if (file.isDirectory()) {
            this.currentFolder = file;
        }
        this.updateExplorer();
    }

    protected void gotoParentFolder() {
        this.gotoFolder(new MyFile(this.currentFolder.getParentFile()));
    }

    protected void updateExplorer() {
        if (this.currentFolder == null) {
            return;
        }
        if (this.fsv == null) {
            return;
        }
        if (this.explorer == null) {
            return;
        }
        if (this.explorer.getMode() == 1 && this.currentFolder.isDirectory()) {
            this.explorer.getViewList().setListData(this.getFiles(this.currentFolder, false));
        }
        if (this.explorer.getMode() == 3 && this.currentFolder.isDirectory()) {
            this.explorer.getViewThumbnail().setListData(this.getFiles(this.currentFolder, false));
        }
        if (this.explorer.getMode() == 2 && this.currentFolder.isDirectory()) {
            this.explorer.getTableModel().setFiles(this.getFiles(this.currentFolder, false));
        }
        this.scrollpane.getViewport().setView(this.explorer.getView());
    }

    private MyFile[] getFiles(File currentFolder2, boolean b) {
        MyFile[] files1 = JUpload.convertToMyfiles(this.fsv.getFiles(currentFolder2, b));
        Vector<MyFile> files2 = new Vector<MyFile>();
        for (int i = 0; i < files1.length; ++i) {
            MyFile file = files1[i];
            if (this.filefilter == null) {
                files2.addElement(file);
                continue;
            }
            if (!this.filefilter.accept(file)) continue;
            files2.addElement(file);
        }
        return this.getArrayFromVector(files2);
    }

    private MyFile[] getArrayFromVector(Vector files2) {
        MyFile[] array = new MyFile[files2.size()];
        for (int i = 0; i < files2.size(); ++i) {
            array[i] = (MyFile)files2.get(i);
        }
        return array;
    }

    public Explorer getExplorer() {
        return this.explorer;
    }

    public void moveUp() {
        this.gotoParentFolder();
    }

    public void viewThumbnail() {
        this.explorer.viewThumbnail();
        this.updateExplorer();
    }

    public void viewList() {
        this.explorer.viewList();
        this.updateExplorer();
    }

    public void viewDetailed() {
        this.explorer.viewDetailed();
        this.updateExplorer();
    }

    public void setFileFilter(FileFilter newFilter) {
        this.filefilter = newFilter;
        this.updateExplorer();
    }

    public void gotoHome() {
        this.gotoFolder(new MyFile(this.fsv.getHomeDirectory()));
    }

    public void gotoDefault() {
    }
}

