<?php

/*
Plugin Name: <img style="vertical-align:middle;" src="http://blogpig.com/favicon.ico"> CommentPiG
Description: Get more comments with CommentPiG a comment simulator plugin for WordPress. CommentPiG can transform any blog into a hive of user generated content within hours. <a href="http://blogpig.com/api_key" target="_blank">You need a BlogPiG API key</a> to use it. Don't forget to try out our other <a href="http://blogpig.com/products/" target="_blank">WordPress Automation Plugins.</a>
Plugin URI:  http://blogpig.com/products/commentpig
Version:     2.1.1
Author:      BlogPiG
Author URI:  http://blogpig.com
*/

function wpcommentpig_activate() {
  $this_app = 'commentpig';

  $installed_apps_string = trim(get_option('blogpig_apps'));
  $installed_apps = array();
  if($installed_apps_string != '') {
    $installed_apps = explode(',', get_option('blogpig_apps'));
  }
  if(array_search($this_app, $installed_apps) == FALSE) {
    array_push($installed_apps, $this_app);
    $installed_apps = array_unique($installed_apps);
    update_option('blogpig_apps', implode(',',  $installed_apps));
  }
  unset($installed_apps);


  # Initial Settings
  $filename = dirname(__FILE__) . "/initial_settings.txt";
  if(function_exists('commentpig_pro_read_api_key')) {
    commentpig_pro_read_api_key($filename);
  }
  if(function_exists('wpcommentpig_read_initial_settings') && @commentpig_pro_api_check()) {
    wpcommentpig_read_initial_settings($filename);
  }
  else {
    wpcommentpig_read_default_settings();
  }

  # Schedule next run...
  if(function_exists('wpcommentpig_reschedule_cron')) {
    wpcommentpig_reschedule_cron();
  }

}

function wpcommentpig_create_tables() {
  wpcommentpig_activate();

  # DB Tables...
  global $wpdb;
  $table = $wpdb->prefix . "comment_content";
  if($wpdb->get_var("SHOW TABLES LIKE '$table' ") != $table) {
    $structure = "CREATE TABLE IF NOT EXISTS $table ( " .
                "  ID bigint NOT NULL primary key auto_increment, " .
                "  content longtext NOT NULL, " .
                "  tags varchar(255) NOT NULL default '', " .
                "  used int NOT NULL default 0, " .
                "  INDEX idxUsed(used), " .
                "  INDEX idxContent(content(255)) " .
                ") ";
    $wpdb->query($structure);
  }

  $table = $wpdb->prefix . "comment_users";
  if($wpdb->get_var("SHOW TABLES LIKE '$table' ") != $table) {
    $structure = "CREATE TABLE IF NOT EXISTS $table ( " .
                "  ID bigint NOT NULL primary key auto_increment, " .
                "  name varchar(100) NOT NULL, " .
                "  email varchar(100) NOT NULL default '', " .
                "  used int NOT NULL default 0, " .
                "  INDEX idxUsed(used), " .
                "  INDEX idxNameEmail(name, email) " .
                ") ";
    $wpdb->query($structure);
  }

  # Create the global log table...
  include_once('log_functions.php');
  wpcommentpig_create_log_table();
}
register_activation_hook(__FILE__, 'wpcommentpig_create_tables');

function wpcommentpig_deactivate() {
  # Unschedule all runs...
  if(function_exists('wpcommentpig_unschedule_cron')) {
    wpcommentpig_unschedule_cron();
  }

  $this_app = 'commentpig';
  $installed_apps = explode(',', get_option('blogpig_apps'));
  if(count($installed_apps) > 0) {
    $output_apps = array();
    foreach($installed_apps as $app) {
      if($app != $this_app) {
        array_push($output_apps, $app);
      }
    }
    update_option('blogpig_apps', implode(',',  $output_apps));
    unset($output_apps);
  }
  unset($installed_apps);
}
register_activation_hook(__FILE__, 'wpcommentpig_deactivate');

function blogpig_comment_conf(){
  $pluginpath = dirname(__FILE__);
  include("$pluginpath/config.php");
}

function blogpig_comment_not_conf(){
  echo "<DIV>Not Available!</DIV>";
}
/*
function add_wpcommentpig_to_submenu() {
  if(function_exists('add_submenu_page')) {
    add_submenu_page('options-general.php', __('WP Self Comment'), __('WP Self Comment'), 'manage_options', 'wpcommentpig-config', 'wpcommentpig_conf');
  }
}
add_action('admin_menu', 'add_wpcommentpig_to_submenu');
*/

function add_blogpig_comment_to_submenu() {
  # CommentPiG
  if(function_exists('blogpig_comment_conf')) {
    define('COMMENT_CONF_FUNCTION', 'blogpig_comment_conf', TRUE);
  }
  else {
    define('COMMENT_CONF_FUNCTION', 'blogpig_comment_not_conf', TRUE);
  }
  if(!defined('BLOGPIG_CONF_PARENT')) {
    define('BLOGPIG_CONF_PARENT', __FILE__, TRUE);
    add_menu_page('BlogPiG Page', 'BlogPiG', 8, __FILE__, COMMENT_CONF_FUNCTION);
  }
  add_submenu_page(BLOGPIG_CONF_PARENT, 'CommentPiG Page', 'CommentPiG', 8, __FILE__, COMMENT_CONF_FUNCTION);
}
add_action('admin_menu', 'add_blogpig_comment_to_submenu');

/*
 * Add a plugin meta link
 */

function wpcommentpig_set_plugin_meta($links, $file) {
  $plugin = plugin_basename(__FILE__);
  if ($file == $plugin) {
    return array_merge(
      $links,
      array(sprintf('<a href="admin.php?page=%s">%s</a>', $plugin, __('Settings')))
    );
  }
  return $links;
}
add_filter('plugin_row_meta', 'wpcommentpig_set_plugin_meta', 10, 2);

require_once dirname(__FILE__) . "/commentpig_main.php";

# Add the PRO functionality...
$pro_file = dirname(__FILE__) . "/commentpig_pro.php";
commentpig_load_ioncube();
if(file_exists($pro_file) && (extension_loaded('ionCube Loader') || strpos(file_get_contents($pro_file), 'commentpigpro'))) {
  @include_once "$pro_file";
}

?>
